/*
 * Decompiled with CFR 0.152.
 */
package com.finchy.pipeorgans.content.pipes.hohlflute;

import com.finchy.pipeorgans.content.pipes.generic.EPipeSizes;
import com.finchy.pipeorgans.content.pipes.hohlflute.HohlfluteBlock;
import com.finchy.pipeorgans.content.pipes.hohlflute.HohlfluteBlockEntity;
import com.finchy.pipeorgans.init.AllPartialModels;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class HohlfluteRenderer
extends SafeBlockEntityRenderer<HohlfluteBlockEntity> {
    public HohlfluteRenderer(BlockEntityRendererProvider.Context context) {
    }

    protected void renderSafe(HohlfluteBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource bufferSource, int light, int overlay) {
        BlockState blockState = be.getBlockState();
        if (!(blockState.getBlock() instanceof HohlfluteBlock)) {
            return;
        }
        Direction direction = (Direction)blockState.getValue((Property)HohlfluteBlock.FACING);
        EPipeSizes.PipeSize size = (EPipeSizes.PipeSize)((Object)blockState.getValue((Property)HohlfluteBlock.SIZE));
        PartialModel mouth = switch (size) {
            default -> throw new MatchException(null, null);
            case EPipeSizes.PipeSize.TINY -> AllPartialModels.HOHLFLUTE_MOUTH_TINY;
            case EPipeSizes.PipeSize.SMALL -> AllPartialModels.HOHLFLUTE_MOUTH_SMALL;
            case EPipeSizes.PipeSize.MEDIUM -> AllPartialModels.HOHLFLUTE_MOUTH_MEDIUM;
            case EPipeSizes.PipeSize.LARGE -> AllPartialModels.HOHLFLUTE_MOUTH_LARGE;
            case EPipeSizes.PipeSize.HUGE -> AllPartialModels.HOHLFLUTE_MOUTH_HUGE;
        };
        float offset = be.animation.getValue(partialTicks);
        if (be.animation.getChaseTarget() > 0.0f && be.animation.getValue() > 0.5f) {
            float wiggleProgress = ((float)AnimationTickHolder.getTicks((LevelAccessor)be.getLevel()) + partialTicks) / 8.0f;
            offset -= (float)(Math.sin(wiggleProgress * ((float)Math.PI * 2) * (float)(4 - size.ordinal())) / 8.0);
        }
        SuperByteBuffer superByteBuffer = (SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)CachedBuffers.partial((PartialModel)mouth, (BlockState)blockState).center()).rotateYDegrees(AngleHelper.horizontalAngle((Direction)direction))).uncenter()).translateY(0.25f);
        ((SuperByteBuffer)((SuperByteBuffer)superByteBuffer.translateZ((switch (size) {
            default -> throw new MatchException(null, null);
            case EPipeSizes.PipeSize.TINY -> 6.0f;
            case EPipeSizes.PipeSize.SMALL -> 5.0f;
            case EPipeSizes.PipeSize.MEDIUM -> 4.0f;
            case EPipeSizes.PipeSize.LARGE -> 3.0f;
            case EPipeSizes.PipeSize.HUGE -> 2.0f;
        }) / 16.0f)).rotateXDegrees(-offset * 16.0f)).light(light).renderInto(ms, bufferSource.getBuffer(RenderType.solid()));
    }
}

