/*
 * Decompiled with CFR 0.152.
 */
package com.finchy.pipeorgans.content.pipes.generic;

import com.finchy.pipeorgans.content.pipes.generic.EExtensionShapes;
import com.finchy.pipeorgans.content.pipes.generic.EPipeSizes;
import com.finchy.pipeorgans.content.pipes.generic.GenericExtensionBlock;
import com.finchy.pipeorgans.content.pipes.generic.GenericPipeBlockEntity;
import com.finchy.pipeorgans.content.pipes.generic.GenericPipeBlockItem;
import com.finchy.pipeorgans.content.windchest.WindchestBlock;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.decoration.steamWhistle.WhistleBlock;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.fluids.tank.FluidTankBlock;
import com.simibubi.create.foundation.block.IBE;
import com.tterrag.registrate.util.entry.BlockEntityEntry;
import com.tterrag.registrate.util.entry.BlockEntry;
import java.util.Objects;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GenericPipeBlock
extends Block
implements IBE<GenericPipeBlockEntity>,
IWrenchable {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty WALL = WhistleBlock.WALL;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final EnumProperty<EPipeSizes.PipeSize> SIZE = EnumProperty.create((String)"size", EPipeSizes.PipeSize.class);
    protected BlockEntry<? extends GenericPipeBlock> baseBlock;
    protected BlockEntry<? extends GenericExtensionBlock<? extends EExtensionShapes.ExtensionShape>> extensionBlock;
    protected BlockEntityEntry<? extends GenericPipeBlockEntity> blockEntityType;
    public final int EPB;

    public GenericPipeBlock(BlockBehaviour.Properties pProperties, int EPB) {
        super(pProperties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)WALL, (Comparable)Boolean.valueOf(false))).setValue(SIZE, (Comparable)((Object)EPipeSizes.PipeSize.MEDIUM)));
        this.EPB = EPB;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING, WALL, POWERED, SIZE});
    }

    public Class<GenericPipeBlockEntity> getBlockEntityClass() {
        return GenericPipeBlockEntity.class;
    }

    public BlockEntityType<? extends GenericPipeBlockEntity> getBlockEntityType() {
        return (BlockEntityType)this.blockEntityType.get();
    }

    public abstract VoxelShape getShape(BlockState var1, BlockGetter var2, BlockPos var3, CollisionContext var4);

    public abstract void incrementSize(Level var1, BlockPos var2, boolean var3);

    public static void queuePitchUpdate(LevelAccessor level, BlockPos pos) {
        BlockState blockState = level.getBlockState(pos);
        Block block = blockState.getBlock();
        if (block instanceof GenericPipeBlock) {
            GenericPipeBlock pipe = (GenericPipeBlock)block;
            if (!level.getBlockTicks().hasScheduledTick(pos, (Object)pipe)) {
                level.scheduleTick(pos, (Block)pipe, 1);
            }
        }
    }

    @NotNull
    public ItemInteractionResult useItemOn(ItemStack heldItem, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (heldItem.getItem() == ((GenericPipeBlock)((Object)this.baseBlock.get())).asItem()) {
            this.incrementSize(pLevel, pPos, true);
            return ItemInteractionResult.SUCCESS;
        }
        if (heldItem.getItem() instanceof GenericPipeBlockItem) {
            if (this.substitutePipe(pState, pLevel, pPos, heldItem, pPlayer) == InteractionResult.SUCCESS) {
                if (!pPlayer.isCreative()) {
                    heldItem.shrink(1);
                    pPlayer.setItemInHand(pHand, heldItem);
                    pPlayer.getInventory().placeItemBackInInventory(new ItemStack((ItemLike)((GenericPipeBlock)((Object)this.baseBlock.get())).asItem()));
                }
                return ItemInteractionResult.SUCCESS;
            }
            AllSoundEvents.DENY.playOnServer(pLevel, (Vec3i)pPos);
            pPlayer.displayClientMessage((Component)Component.translatable((String)"pipeorgans.blocks.pipes.replace_pipe_deny"), true);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public InteractionResult substitutePipe(BlockState state, Level level, BlockPos pos, ItemStack heldItem, Player player) {
        GenericPipeBlock held = (GenericPipeBlock)((GenericPipeBlockItem)heldItem.getItem()).getBlock();
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof GenericPipeBlockEntity) {
            GenericPipeBlockEntity be = (GenericPipeBlockEntity)blockEntity;
            if (this.EPB <= held.EPB) {
                int removeDistance = (int)Math.ceil((float)be.pitch / (float)this.EPB);
                BlockPos currentPos = pos;
                for (int i = 1; i <= removeDistance; ++i) {
                    currentPos = currentPos.above();
                    level.destroyBlock(currentPos, false);
                }
            } else if (be.pitch > 0) {
                int checkDist = (int)Math.ceil((float)be.pitch / (float)held.EPB);
                BlockPos currentPos = pos;
                for (int i = 1; i <= checkDist; ++i) {
                    BlockState currentState = level.getBlockState(currentPos = currentPos.above());
                    if (currentState.canBeReplaced() || currentState.getBlock() instanceof GenericExtensionBlock) continue;
                    return InteractionResult.FAIL;
                }
                int removeDistance = (int)Math.ceil((float)be.pitch / (float)this.EPB);
                currentPos = pos;
                for (int i = 1; i <= removeDistance; ++i) {
                    currentPos = currentPos.above();
                    level.destroyBlock(currentPos, false);
                }
            }
            this.placeNewPipe(state, level, pos, heldItem, player, be.pitch);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    protected void placeNewPipe(BlockState state, Level level, BlockPos pos, ItemStack heldItem, Player player, int pitch) {
        EPipeSizes.PipeSize size = (EPipeSizes.PipeSize)((Object)state.getValue(SIZE));
        Direction facing = (Direction)state.getValue((Property)FACING);
        boolean wall = (Boolean)state.getValue((Property)WALL);
        boolean powered = (Boolean)state.getValue((Property)POWERED);
        level.destroyBlock(pos, false);
        GenericPipeBlock pipe = (GenericPipeBlock)((GenericPipeBlockItem)heldItem.getItem()).getBlock();
        level.setBlock(pos, (BlockState)((BlockState)((BlockState)((BlockState)pipe.defaultBlockState().setValue(SIZE, (Comparable)((Object)size))).setValue((Property)FACING, (Comparable)facing)).setValue((Property)WALL, (Comparable)Boolean.valueOf(wall))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(powered)), 3);
        GenericPipeBlock newPipe = (GenericPipeBlock)level.getBlockState(pos).getBlock();
        if (pitch > 0) {
            for (int i = 1; i <= pitch; ++i) {
                newPipe.incrementSize(level, pos, false);
            }
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            CriteriaTriggers.PLACED_BLOCK.trigger(sp, pos, heldItem);
        }
    }

    public void tick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        this.withBlockEntityDo((BlockGetter)pLevel, pPos, GenericPipeBlockEntity::updatePitch);
    }

    public boolean canSurvive(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        BlockState attachedState = pLevel.getBlockState(pPos.relative(GenericPipeBlock.getAttachedDirection(pState)));
        return FluidTankBlock.isTank((BlockState)attachedState) || attachedState.getBlock() instanceof WindchestBlock;
    }

    public static Direction getAttachedDirection(BlockState state) {
        return (Boolean)state.getValue((Property)WALL) != false ? (Direction)state.getValue((Property)FACING) : Direction.DOWN;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state;
        Level level = context.getLevel();
        BlockPos clickedPos = context.getClickedPos();
        Direction face = context.getClickedFace();
        boolean wall = true;
        if (face.getAxis() == Direction.Axis.Y) {
            face = context.getHorizontalDirection().getOpposite();
            wall = false;
        }
        if (!this.canSurvive(state = (BlockState)((BlockState)((BlockState)Objects.requireNonNull(super.getStateForPlacement(context)).setValue((Property)FACING, (Comparable)face.getOpposite())).setValue((Property)POWERED, (Comparable)Boolean.valueOf(level.hasNeighborSignal(clickedPos)))).setValue((Property)WALL, (Comparable)Boolean.valueOf(wall)), (LevelReader)level, clickedPos)) {
            return null;
        }
        return state;
    }

    public void neighborChanged(BlockState pState, Level pLevel, BlockPos pPos, Block pNeighborBlock, BlockPos pNeighborPos, boolean isMoving) {
        if (pLevel.isClientSide) {
            return;
        }
        boolean previouslyPowered = (Boolean)pState.getValue((Property)POWERED);
        if (previouslyPowered != pLevel.hasNeighborSignal(pPos)) {
            pLevel.setBlock(pPos, (BlockState)pState.cycle((Property)POWERED), 2);
        }
    }

    public BlockState updateShape(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        return GenericPipeBlock.getAttachedDirection(pState) == pFacing && !pState.canSurvive((LevelReader)pLevel, pCurrentPos) ? Blocks.AIR.defaultBlockState() : pState;
    }

    public void onPlace(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        FluidTankBlock.updateBoilerState((BlockState)pState, (Level)pLevel, (BlockPos)pPos.relative(GenericPipeBlock.getAttachedDirection(pState)));
        if (pOldState.getBlock() != this || pOldState.getValue(SIZE) != pState.getValue(SIZE)) {
            GenericPipeBlock.queuePitchUpdate((LevelAccessor)pLevel, pPos);
        }
    }

    public void onRemove(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        FluidTankBlock.updateBoilerState((BlockState)pState, (Level)pLevel, (BlockPos)pPos.relative(GenericPipeBlock.getAttachedDirection(pState)));
        super.onRemove(pState, pLevel, pPos, pNewState, pIsMoving);
    }

    public BlockState getRotatedBlockState(BlockState originalState, Direction targetedFace) {
        return (BlockState)originalState.cycle(SIZE);
    }

    public BlockState rotate(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.setValue((Property)FACING, (Comparable)pRotation.rotate((Direction)pState.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState pState, Mirror pMirror) {
        return pMirror == Mirror.NONE ? pState : pState.rotate(pMirror.getRotation((Direction)pState.getValue((Property)FACING)));
    }
}

