/*
 * Decompiled with CFR 0.152.
 */
package com.finchy.pipeorgans.content.pipes.generic;

import com.finchy.pipeorgans.content.pipes.generic.EPipeSizes;
import com.finchy.pipeorgans.content.pipes.generic.GenericPipeBlock;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.tterrag.registrate.util.entry.BlockEntry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class GenericExtensionBlock<P extends Enum<P> & StringRepresentable>
extends Block
implements IWrenchable {
    public final EnumProperty<P> SHAPE;
    public static final EnumProperty<EPipeSizes.PipeSize> SIZE = GenericPipeBlock.SIZE;
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    protected BlockEntry<? extends GenericPipeBlock> baseBlock;

    public GenericExtensionBlock(BlockBehaviour.Properties pProperties, EnumProperty<P> shapeProperty) {
        super(pProperties);
        this.SHAPE = shapeProperty;
        this.registerDefaultStateWithSize();
    }

    protected abstract void registerDefaultStateWithSize();

    public abstract VoxelShape getShape(BlockState var1, BlockGetter var2, BlockPos var3, CollisionContext var4);

    public abstract boolean canSurvive(BlockState var1, LevelReader var2, BlockPos var3);

    public abstract BlockState updateShape(BlockState var1, Direction var2, BlockState var3, LevelAccessor var4, BlockPos var5, BlockPos var6);

    public static BlockPos findRoot(LevelAccessor pLevel, BlockPos pPos) {
        BlockState blockState;
        BlockPos currentPos = pPos.below();
        while ((blockState = pLevel.getBlockState(currentPos)).getBlock() instanceof GenericExtensionBlock) {
            currentPos = currentPos.below();
        }
        return currentPos;
    }

    protected UseOnContext relocateContext(UseOnContext context, BlockPos target) {
        return new UseOnContext(context.getPlayer(), context.getHand(), new BlockHitResult(context.getClickLocation(), context.getClickedFace(), target, context.isInside()));
    }

    public boolean isDirectional() {
        return false;
    }

    public ItemInteractionResult useItemOn(ItemStack heldItem, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (heldItem.getItem() != ((GenericPipeBlock)((Object)this.baseBlock.get())).asItem()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        BlockPos root = GenericExtensionBlock.findRoot((LevelAccessor)pLevel, pPos);
        BlockState blockState = pLevel.getBlockState(root);
        Block block = blockState.getBlock();
        if (block instanceof GenericPipeBlock) {
            GenericPipeBlock pipe = (GenericPipeBlock)block;
            return pipe.useItemOn(heldItem, blockState, pLevel, root, pPlayer, pHand, new BlockHitResult(pHit.getLocation(), pHit.getDirection(), root, pHit.isInside()));
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public abstract InteractionResult onSneakWrenched(BlockState var1, UseOnContext var2);

    public InteractionResult sneakWrenchedRemove(BlockState state, UseOnContext context) {
        return super.onSneakWrenched(state, context);
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        BlockPos findRoot;
        Level level = context.getLevel();
        BlockState blockState = level.getBlockState(findRoot = GenericExtensionBlock.findRoot((LevelAccessor)level, context.getClickedPos()));
        Block block = blockState.getBlock();
        if (block instanceof GenericPipeBlock) {
            GenericPipeBlock pipe = (GenericPipeBlock)block;
            return pipe.onWrenched(blockState, this.relocateContext(context, findRoot));
        }
        return super.onWrenched(state, context);
    }

    protected InteractionResult callSuperOnSneakWrenched(BlockState state, UseOnContext context) {
        return super.onSneakWrenched(state, context);
    }

    public void onPlace(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pMovedByPiston) {
        if (pOldState.getBlock() != this || pOldState.getValue(this.SHAPE) != pState.getValue(this.SHAPE)) {
            GenericPipeBlock.queuePitchUpdate((LevelAccessor)pLevel, GenericExtensionBlock.findRoot((LevelAccessor)pLevel, pPos));
        }
    }

    public void onRemove(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pMovedByPiston) {
        if (pOldState.getBlock() != this || pOldState.getValue(this.SHAPE) != pState.getValue(this.SHAPE)) {
            GenericPipeBlock.queuePitchUpdate((LevelAccessor)pLevel, GenericExtensionBlock.findRoot((LevelAccessor)pLevel, pPos));
        }
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        return new ItemStack((ItemLike)this.baseBlock.get());
    }
}

