/*
 * Decompiled with CFR 0.152.
 */
package com.finchy.pipeorgans.content.midi.trackerBar;

import com.finchy.pipeorgans.init.AllItems;
import java.util.function.Consumer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;

public class TrackerBarSlot
extends SlotItemHandler {
    private final Consumer<ItemStack> onStackChanged;

    public TrackerBarSlot(IItemHandler itemHandler, int index, int xPosition, int yPosition, Consumer<ItemStack> onStackChanged) {
        super(itemHandler, index, xPosition, yPosition);
        this.onStackChanged = onStackChanged;
    }

    public boolean mayPlace(@NotNull ItemStack stack) {
        return AllItems.MUSIC_ROLL.isIn(stack);
    }

    public void set(@NotNull ItemStack stack) {
        super.set(stack);
        this.onStackChanged.accept(stack);
    }

    public void onQuickCraft(@NotNull ItemStack oldStackIn, @NotNull ItemStack newStackIn) {
        super.onQuickCraft(oldStackIn, newStackIn);
        if (ItemStack.matches((ItemStack)oldStackIn, (ItemStack)newStackIn)) {
            this.onStackChanged.accept(newStackIn);
        }
    }

    public void onTake(Player pPlayer, ItemStack pStack) {
        super.onTake(pPlayer, pStack);
        this.onStackChanged.accept(ItemStack.EMPTY);
    }
}

