/*
 * Decompiled with CFR 0.152.
 */
package com.finchy.pipeorgans.content.midi.trackerBar;

import com.finchy.pipeorgans.content.midi.MidiSequencerBehaviour;
import com.finchy.pipeorgans.content.midi.trackerBar.TrackerBarBlockEntity;
import com.simibubi.create.content.redstone.displayLink.DisplayLinkContext;
import com.simibubi.create.content.redstone.displayLink.source.SingleLineDisplaySource;
import com.simibubi.create.content.redstone.displayLink.target.DisplayTargetStats;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.block.entity.BlockEntity;

public class TrackerBarDisplaySources {

    public static class BPMSource
    extends SingleLineDisplaySource {
        protected MutableComponent provideLine(DisplayLinkContext context, DisplayTargetStats stats) {
            BlockEntity sourceBE = context.getSourceBlockEntity();
            if (!(sourceBE instanceof TrackerBarBlockEntity)) {
                return EMPTY_LINE;
            }
            TrackerBarBlockEntity trackerBar = (TrackerBarBlockEntity)sourceBE;
            MidiSequencerBehaviour sequencerBehaviour = (MidiSequencerBehaviour)trackerBar.getBehaviour(MidiSequencerBehaviour.TYPE);
            if (sequencerBehaviour == null) {
                return EMPTY_LINE;
            }
            if (!sequencerBehaviour.isSequenceLoaded()) {
                return EMPTY_LINE;
            }
            return Component.literal((String)(sequencerBehaviour.get10xBPM() / 10 + " BPM"));
        }

        protected String getTranslationKey() {
            return "tracker_bar_bpm";
        }

        protected boolean allowsLabeling(DisplayLinkContext context) {
            return true;
        }
    }

    public static class FilenameSource
    extends SingleLineDisplaySource {
        protected MutableComponent provideLine(DisplayLinkContext context, DisplayTargetStats stats) {
            BlockEntity sourceBE = context.getSourceBlockEntity();
            if (!(sourceBE instanceof TrackerBarBlockEntity)) {
                return EMPTY_LINE;
            }
            TrackerBarBlockEntity trackerBar = (TrackerBarBlockEntity)sourceBE;
            MidiSequencerBehaviour sequencerBehaviour = (MidiSequencerBehaviour)trackerBar.getBehaviour(MidiSequencerBehaviour.TYPE);
            if (sequencerBehaviour == null) {
                return EMPTY_LINE;
            }
            if (!sequencerBehaviour.isSequenceLoaded()) {
                return EMPTY_LINE;
            }
            return Component.literal((String)sequencerBehaviour.getCurrentMidi());
        }

        protected String getTranslationKey() {
            return "tracker_bar_filename";
        }

        protected boolean allowsLabeling(DisplayLinkContext context) {
            return true;
        }
    }
}

