/*
 * Decompiled with CFR 0.152.
 */
package com.finchy.pipeorgans.content.midi.trackerBar;

import com.finchy.pipeorgans.PipeOrgans;
import com.finchy.pipeorgans.content.midi.MidiSequencerBehaviour;
import com.finchy.pipeorgans.content.midi.MidiSourceBehaviour;
import com.finchy.pipeorgans.content.midi.trackerBar.TrackerBarMenu;
import com.finchy.pipeorgans.init.AllBlockEntities;
import com.finchy.pipeorgans.init.AllDataComponents;
import com.finchy.pipeorgans.init.AllSoundEvents;
import com.finchy.pipeorgans.util.MidiLoadException;
import com.finchy.pipeorgans.util.MidiUtils;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import javax.sound.midi.ShortMessage;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class TrackerBarBlockEntity
extends KineticBlockEntity
implements MenuProvider {
    private boolean buttonsEnabled = false;
    public TrackerBarInventory inventory = new TrackerBarInventory(this);
    protected final ContainerData data = new ContainerData(){

        public int get(int pIndex) {
            return switch (pIndex) {
                case 0 -> TrackerBarBlockEntity.this.midiSequencerBehaviour.channelInstruments.get(0);
                case 1 -> TrackerBarBlockEntity.this.midiSequencerBehaviour.channelInstruments.get(1);
                case 2 -> TrackerBarBlockEntity.this.midiSequencerBehaviour.channelInstruments.get(2);
                case 3 -> TrackerBarBlockEntity.this.midiSequencerBehaviour.channelInstruments.get(3);
                case 4 -> TrackerBarBlockEntity.this.midiSequencerBehaviour.channelInstruments.get(4);
                case 5 -> TrackerBarBlockEntity.this.midiSequencerBehaviour.channelInstruments.get(5);
                case 6 -> TrackerBarBlockEntity.this.midiSequencerBehaviour.channelInstruments.get(6);
                case 7 -> TrackerBarBlockEntity.this.midiSequencerBehaviour.channelInstruments.get(7);
                case 8 -> TrackerBarBlockEntity.this.midiSequencerBehaviour.channelInstruments.get(8);
                case 9 -> TrackerBarBlockEntity.this.midiSequencerBehaviour.channelInstruments.get(9);
                case 10 -> TrackerBarBlockEntity.this.midiSequencerBehaviour.channelInstruments.get(10);
                case 11 -> TrackerBarBlockEntity.this.midiSequencerBehaviour.channelInstruments.get(11);
                case 12 -> TrackerBarBlockEntity.this.midiSequencerBehaviour.channelInstruments.get(12);
                case 13 -> TrackerBarBlockEntity.this.midiSequencerBehaviour.channelInstruments.get(13);
                case 14 -> TrackerBarBlockEntity.this.midiSequencerBehaviour.channelInstruments.get(14);
                case 15 -> TrackerBarBlockEntity.this.midiSequencerBehaviour.channelInstruments.get(15);
                case 16 -> {
                    if (TrackerBarBlockEntity.this.midiSequencerBehaviour.isPlaying()) {
                        yield 1;
                    }
                    yield 0;
                }
                case 17 -> TrackerBarBlockEntity.this.midiSequencerBehaviour.getTickPosition();
                case 18 -> TrackerBarBlockEntity.this.midiSequencerBehaviour.getEndTick();
                case 19 -> TrackerBarBlockEntity.this.midiSequencerBehaviour.get10xBPM();
                case 20 -> {
                    if (TrackerBarBlockEntity.this.buttonsEnabled) {
                        yield 1;
                    }
                    yield 0;
                }
                default -> 0;
            };
        }

        public void set(int pIndex, int pValue) {
        }

        public int getCount() {
            return 21;
        }
    };
    public float rollerAngle = 0.0f;
    public static final float MAX_ROLLER_VELOCITY = 21.666f;
    public static final float SCROLL_SPEED = 0.03125f;
    MidiSourceBehaviour midiSourceBehaviour;
    MidiSequencerBehaviour midiSequencerBehaviour;

    public TrackerBarBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)AllBlockEntities.TRACKER_BAR_BLOCK_ENTITY.get(), (be, context) -> be.inventory);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.midiSourceBehaviour = new MidiSourceBehaviour((SmartBlockEntity)this);
        behaviours.add(this.midiSourceBehaviour);
        this.midiSequencerBehaviour = new MidiSequencerBehaviour((SmartBlockEntity)this);
        behaviours.add(this.midiSequencerBehaviour);
    }

    public void onBlockRemoved() {
        this.midiSourceBehaviour.link.stopAllNotes();
    }

    protected void write(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(tag, registries, clientPacket);
        tag.put("Inventory", (Tag)this.inventory.serializeNBT(registries));
    }

    protected void read(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(tag, registries, clientPacket);
        this.inventory.deserializeNBT(registries, tag.getCompound("Inventory"));
    }

    public Component getDisplayName() {
        return Component.translatable((String)"gui.pipeorgans.tracker_bar");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return TrackerBarMenu.create(pContainerId, pPlayerInventory, this, this.data);
    }

    public void tick() {
        super.tick();
        if (this.midiSequencerBehaviour.isPlaying() && this.speed != 0.0f) {
            this.midiSequencerBehaviour.tickSequencer();
            this.rollerAngle += 21.666f;
        }
    }

    public void setButtonsEnabled(boolean enabled) {
        this.buttonsEnabled = enabled;
    }

    public float getRollerAngle(float partialTicks) {
        return this.midiSequencerBehaviour.isPlaying() && this.speed != 0.0f ? (this.rollerAngle + 21.666f * partialTicks) / 360.0f : this.rollerAngle;
    }

    public float getScrollSpeed() {
        return this.midiSequencerBehaviour.isPlaying() && this.speed != 0.0f ? 0.03125f : 0.0f;
    }

    public void onRollChanged() {
        ItemStack stack = this.inventory.getStackInSlot(0);
        this.midiSequencerBehaviour.unloadSequence();
        if (stack.isEmpty()) {
            this.buttonsEnabled = false;
            if (!this.level.isClientSide) {
                this.level.playSound(null, this.getBlockPos(), (SoundEvent)AllSoundEvents.TRACKER_BAR_CHANGE_ROLL.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        } else if (MidiUtils.isMusicRollValid(stack)) {
            if (!this.level.isClientSide) {
                this.level.playSound(null, this.getBlockPos(), (SoundEvent)AllSoundEvents.TRACKER_BAR_CHANGE_ROLL.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            try {
                this.midiSequencerBehaviour.loadSequence((String)stack.get(AllDataComponents.MIDI_FILE), (String)stack.get(AllDataComponents.MIDI_OWNER));
                this.buttonsEnabled = true;
            }
            catch (MidiLoadException e) {
                PipeOrgans.LOGGER.warn(e.toString());
                this.buttonsEnabled = false;
            }
        } else {
            this.buttonsEnabled = false;
        }
    }

    public boolean getButtonsEnabled() {
        return this.buttonsEnabled;
    }

    public void pressTogglePlayButton() {
        if (this.midiSequencerBehaviour.isSequenceLoaded()) {
            this.midiSequencerBehaviour.toggleSequencer();
        }
    }

    public void pressStopButton() {
        this.midiSequencerBehaviour.restartPlayback();
    }

    public void handleNote(ShortMessage sm) {
        this.midiSourceBehaviour.handleNote(sm);
    }

    public void stopAllNotes() {
        this.midiSourceBehaviour.link.stopAllNotes();
    }

    public static class TrackerBarInventory
    extends ItemStackHandler {
        private final TrackerBarBlockEntity be;

        public TrackerBarInventory(TrackerBarBlockEntity be) {
            super(1);
            this.be = be;
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            this.be.setChanged();
        }
    }
}

