/*
 * Decompiled with CFR 0.152.
 */
package com.finchy.pipeorgans.content.midi.trackerBar;

import com.finchy.pipeorgans.content.midi.MidiSequencerBehaviour;
import com.finchy.pipeorgans.content.midi.keyboardRelay.KeyboardRelayBlock;
import com.finchy.pipeorgans.content.midi.trackerBar.TrackerBarBlockEntity;
import com.finchy.pipeorgans.init.AllBlockEntities;
import com.finchy.pipeorgans.init.AllShapes;
import com.simibubi.create.content.kinetics.base.HorizontalKineticBlock;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.item.ItemHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.items.IItemHandler;

public class TrackerBarBlock
extends HorizontalKineticBlock
implements IBE<TrackerBarBlockEntity> {
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final BooleanProperty TRANSMITTING = KeyboardRelayBlock.TRANSMITTING;

    public TrackerBarBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties.isViewBlocking((state, level, pos) -> false));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)TRANSMITTING, (Comparable)Boolean.valueOf(false))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return AllShapes.TRACKER_BAR.get((Direction)state.getValue(HORIZONTAL_FACING));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{POWERED, TRANSMITTING});
        super.createBlockStateDefinition(builder);
    }

    public Class<TrackerBarBlockEntity> getBlockEntityClass() {
        return TrackerBarBlockEntity.class;
    }

    public BlockEntityType<? extends TrackerBarBlockEntity> getBlockEntityType() {
        return (BlockEntityType)AllBlockEntities.TRACKER_BAR_BLOCK_ENTITY.get();
    }

    public boolean hasAnalogOutputSignal(BlockState pState) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState pState, Level pLevel, BlockPos pPos) {
        BlockEntity be = pLevel.getBlockEntity(pPos);
        if (be instanceof TrackerBarBlockEntity) {
            TrackerBarBlockEntity trackerBar = (TrackerBarBlockEntity)be;
            return (int)(((MidiSequencerBehaviour)trackerBar.getBehaviour(MidiSequencerBehaviour.TYPE)).getPlaybackPercentage() * 15.0);
        }
        return 0;
    }

    public void neighborChanged(BlockState pState, Level pLevel, BlockPos pPos, Block pNeighborBlock, BlockPos pNeighborPos, boolean isMoving) {
        boolean previouslyPowered = (Boolean)pState.getValue((Property)POWERED);
        boolean neighbourPowered = pLevel.hasNeighborSignal(pPos);
        if (!previouslyPowered && neighbourPowered) {
            BlockEntity blockEntity = pLevel.getBlockEntity(pPos);
            if (blockEntity instanceof TrackerBarBlockEntity) {
                TrackerBarBlockEntity be = (TrackerBarBlockEntity)blockEntity;
                be.pressTogglePlayButton();
            }
            pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)POWERED, (Comparable)Boolean.valueOf(true)), 3);
        } else if (previouslyPowered && !neighbourPowered) {
            pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)), 3);
        }
    }

    public InteractionResult useWithoutItem(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, BlockHitResult pHit) {
        if (pHit.getDirection().equals((Object)((Direction)pState.getValue(HORIZONTAL_FACING)).getClockWise()) || pHit.getDirection().equals((Object)((Direction)pState.getValue(HORIZONTAL_FACING)).getCounterClockWise())) {
            return InteractionResult.PASS;
        }
        if (pLevel.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        this.withBlockEntityDo((BlockGetter)pLevel, pPos, be -> pPlayer.openMenu((MenuProvider)be, arg_0 -> ((TrackerBarBlockEntity)((Object)be)).sendToMenu(arg_0)));
        return InteractionResult.SUCCESS;
    }

    public void onRemove(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pMovedByPiston) {
        if (!pState.is(pNewState.getBlock())) {
            if (!pLevel.isClientSide) {
                this.withBlockEntityDo((BlockGetter)pLevel, pPos, TrackerBarBlockEntity::onBlockRemoved);
            }
            this.withBlockEntityDo((BlockGetter)pLevel, pPos, be -> ItemHelper.dropContents((Level)pLevel, (BlockPos)pPos, (IItemHandler)be.inventory));
        }
        super.onRemove(pState, pLevel, pPos, pNewState, pMovedByPiston);
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return ((Direction)state.getValue(HORIZONTAL_FACING)).getClockWise().getAxis();
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return this.getRotationAxis(state) == face.getAxis();
    }
}

