/*
 * Decompiled with CFR 0.152.
 */
package com.finchy.pipeorgans.content.midi.keyboardRelay;

import com.finchy.pipeorgans.content.midi.MidiSourceBehaviour;
import com.finchy.pipeorgans.content.midi.keyboardRelay.KeyboardRelayBlock;
import com.finchy.pipeorgans.content.midi.keyboardRelay.KeyboardRelayMenu;
import com.finchy.pipeorgans.util.MidiUtils;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import java.util.UUID;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.ShortMessage;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class KeyboardRelayBlockEntity
extends SmartBlockEntity
implements MenuProvider {
    private UUID user = null;
    private boolean deactivatedThisTick;
    MidiSourceBehaviour midiSourceBehaviour;

    public KeyboardRelayBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.midiSourceBehaviour = new MidiSourceBehaviour(this);
        behaviours.add(this.midiSourceBehaviour);
    }

    public void onBlockRemoved() {
        Player player;
        Entity playerEntity = ((ServerLevel)this.level).getEntity(this.user);
        if (playerEntity instanceof Player && this.isUsedBy(player = (Player)playerEntity)) {
            this.user = null;
            if (player != null) {
                player.getPersistentData().remove("UsingKBRelayPos");
            }
        }
    }

    protected void write(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(tag, registries, clientPacket);
        this.midiSourceBehaviour.write(tag, registries, clientPacket);
    }

    protected void read(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(tag, registries, clientPacket);
        this.midiSourceBehaviour.read(tag, registries, clientPacket);
    }

    public Component getDisplayName() {
        return Component.translatable((String)"gui.pipeorgans.keyboard_relay");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return KeyboardRelayMenu.create(pContainerId, pPlayerInventory, this);
    }

    public void tryStartUsing(Player player) {
        if (!this.deactivatedThisTick && !this.hasUser() && !KeyboardRelayBlockEntity.playerIsUsing(player) && KeyboardRelayBlockEntity.playerInRange(player, this.level, this.worldPosition)) {
            this.startUsing(player);
        }
    }

    public void tryStopUsing(Player player) {
        if (this.isUsedBy(player)) {
            this.stopUsing(player);
        }
    }

    private void startUsing(Player player) {
        this.user = player.getUUID();
        player.getPersistentData().putIntArray("UsingKBRelayPos", new int[]{this.worldPosition.getX(), this.worldPosition.getY(), this.worldPosition.getZ()});
        this.level.setBlock(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)KeyboardRelayBlock.TRANSMITTING, (Comparable)Boolean.valueOf(false)), 3);
        this.notifyUpdate();
    }

    private void stopUsing(Player player) {
        this.user = null;
        if (player != null) {
            player.getPersistentData().remove("UsingKBRelayPos");
        }
        this.level.setBlock(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)KeyboardRelayBlock.TRANSMITTING, (Comparable)Boolean.valueOf(false)), 3);
        this.deactivatedThisTick = true;
        this.midiSourceBehaviour.link.stopAllNotes();
        this.notifyUpdate();
    }

    public static boolean playerIsUsing(Player player) {
        return player.getPersistentData().contains("UsingKBRelayPos");
    }

    public static BlockPos playerUsingKBRPos(Player player) {
        if (player.getPersistentData().contains("UsingKBRelayPos")) {
            int[] pos = player.getPersistentData().getIntArray("UsingKBRelayPos");
            return new BlockPos(pos[0], pos[1], pos[2]);
        }
        return null;
    }

    public boolean isUsedBy(Player player) {
        return this.hasUser() && this.user.equals(player.getUUID());
    }

    public boolean hasUser() {
        return this.user != null;
    }

    public void tick() {
        if (!this.level.isClientSide) {
            this.deactivatedThisTick = false;
            if (!(this.level instanceof ServerLevel) || this.user == null) {
                return;
            }
            Entity entity = ((ServerLevel)this.level).getEntity(this.user);
            if (!(entity instanceof Player)) {
                this.stopUsing(null);
                return;
            }
            Player player = (Player)entity;
            if (!KeyboardRelayBlockEntity.playerInRange(player, this.level, this.worldPosition) || !KeyboardRelayBlockEntity.playerIsUsing(player)) {
                this.stopUsing(player);
            }
        }
    }

    public void handleMidiMessage(MidiMessage mm) {
        ShortMessage sm;
        if (mm instanceof ShortMessage && (MidiUtils.isNoteOn(sm = (ShortMessage)mm) || MidiUtils.isNoteOff(sm))) {
            this.midiSourceBehaviour.handleNote(sm);
        }
    }

    public static boolean playerInRange(Player player, Level world, BlockPos pos) {
        double reach = 0.4 * player.getAttributeValue(Attributes.BLOCK_INTERACTION_RANGE);
        return player.distanceToSqr(Vec3.atCenterOf((Vec3i)pos)) < reach * reach;
    }
}

