/*
 * Decompiled with CFR 0.152.
 */
package com.finchy.pipeorgans.content.midi.keyboardRelay;

import com.finchy.pipeorgans.content.midi.keyboardRelay.KeyboardRelayBlockEntity;
import com.finchy.pipeorgans.init.AllBlockEntities;
import com.finchy.pipeorgans.init.AllShapes;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.block.IBE;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class KeyboardRelayBlock
extends Block
implements IBE<KeyboardRelayBlockEntity>,
IWrenchable {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty TRANSMITTING = BooleanProperty.create((String)"transmitting");

    public KeyboardRelayBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)TRANSMITTING, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return AllShapes.KBR.get((Direction)pState.getValue((Property)FACING));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING, TRANSMITTING});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        Direction facing = pContext.getHorizontalDirection().getOpposite();
        return (BlockState)Objects.requireNonNull(super.getStateForPlacement(pContext)).setValue((Property)FACING, (Comparable)facing);
    }

    public Class<KeyboardRelayBlockEntity> getBlockEntityClass() {
        return KeyboardRelayBlockEntity.class;
    }

    public BlockEntityType<? extends KeyboardRelayBlockEntity> getBlockEntityType() {
        return (BlockEntityType)AllBlockEntities.KEYBOARD_RELAY_BLOCK_ENTITY.get();
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (pLevel.isClientSide) {
            return ItemInteractionResult.SUCCESS;
        }
        if (pHand.equals((Object)InteractionHand.OFF_HAND)) {
            return ItemInteractionResult.SUCCESS;
        }
        if (pPlayer.isShiftKeyDown()) {
            this.withBlockEntityDo((BlockGetter)pLevel, pPos, be -> pPlayer.openMenu((MenuProvider)be, arg_0 -> ((KeyboardRelayBlockEntity)((Object)be)).sendToMenu(arg_0)));
            return ItemInteractionResult.SUCCESS;
        }
        if (KeyboardRelayBlockEntity.playerInRange(pPlayer, pLevel, pPos)) {
            if (!KeyboardRelayBlockEntity.playerIsUsing(pPlayer)) {
                this.withBlockEntityDo((BlockGetter)pLevel, pPos, be -> be.tryStartUsing(pPlayer));
            } else {
                this.withBlockEntityDo((BlockGetter)pLevel, pPos, be -> be.tryStopUsing(pPlayer));
            }
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public void onRemove(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pMovedByPiston) {
        if (!pState.is(pNewState.getBlock()) && !pLevel.isClientSide) {
            this.withBlockEntityDo((BlockGetter)pLevel, pPos, KeyboardRelayBlockEntity::onBlockRemoved);
        }
        super.onRemove(pState, pLevel, pPos, pNewState, pMovedByPiston);
    }
}

