/*
 * Decompiled with CFR 0.152.
 */
package com.finchy.pipeorgans.content.midi;

import com.finchy.pipeorgans.midi.PitchMapping;
import com.finchy.pipeorgans.util.MathUtils;
import com.simibubi.create.Create;
import com.simibubi.create.content.redstone.link.IRedstoneLinkable;
import com.simibubi.create.content.redstone.link.RedstoneLinkNetworkHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.createmod.catnip.data.Couple;
import net.createmod.catnip.data.IntAttached;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.ItemStackHandler;

public class RedstoneMidiTransmitter {
    public final List<RedstoneLinkNetworkHandler.Frequency> FrequencyKeys = new ArrayList<RedstoneLinkNetworkHandler.Frequency>(Collections.nCopies(16, RedstoneLinkNetworkHandler.Frequency.of((ItemStack)ItemStack.EMPTY)));
    private final ArrayList<Map<Integer, ManualNoteFrequency>> activeNotes;
    static final int TIMEOUT = 2;
    private final BlockEntity be;

    public RedstoneMidiTransmitter(BlockEntity be) {
        this.FrequencyKeys.set(9, RedstoneLinkNetworkHandler.Frequency.of((ItemStack)new ItemStack((ItemLike)Items.STICK)));
        this.activeNotes = new ArrayList();
        for (int i = 0; i < 16; ++i) {
            this.activeNotes.add(new HashMap());
        }
        this.be = be;
    }

    public void setFrequencyKeysOnLoad(ItemStackHandler ghostInv) {
        for (int i = 0; i < 16; ++i) {
            this.FrequencyKeys.set(i, RedstoneLinkNetworkHandler.Frequency.of((ItemStack)ghostInv.getStackInSlot(i)));
        }
    }

    public void changeFrequencyKey(int channel, ItemStack newKey) {
        for (Map.Entry<Integer, ManualNoteFrequency> entry : this.activeNotes.get(channel).entrySet()) {
            ManualNoteFrequency oldNote = entry.getValue();
            if (((RedstoneLinkNetworkHandler.Frequency)((Couple)oldNote.getSecond()).getFirst()).getStack().equals(newKey)) {
                return;
            }
            Create.REDSTONE_LINK_NETWORK_HANDLER.removeFromNetwork((LevelAccessor)this.be.getLevel(), (IRedstoneLinkable)oldNote);
            RedstoneLinkNetworkHandler.Frequency pitchFreq = (RedstoneLinkNetworkHandler.Frequency)((Couple)oldNote.getSecond()).getSecond();
            ManualNoteFrequency newNoteFrequency = ManualNoteFrequency.create(oldNote.pos, RedstoneLinkNetworkHandler.Frequency.of((ItemStack)newKey), pitchFreq, oldNote.strength);
            entry.setValue(newNoteFrequency);
            Create.REDSTONE_LINK_NETWORK_HANDLER.addToNetwork((LevelAccessor)this.be.getLevel(), (IRedstoneLinkable)newNoteFrequency);
        }
        this.FrequencyKeys.set(channel, RedstoneLinkNetworkHandler.Frequency.of((ItemStack)newKey));
    }

    public void stopAllNotes() {
        for (Map<Integer, ManualNoteFrequency> entry : this.activeNotes) {
            Iterator<Map.Entry<Integer, ManualNoteFrequency>> noteIterator = entry.entrySet().iterator();
            while (noteIterator.hasNext()) {
                Map.Entry<Integer, ManualNoteFrequency> noteEntry = noteIterator.next();
                noteIterator.remove();
                Create.REDSTONE_LINK_NETWORK_HANDLER.removeFromNetwork((LevelAccessor)this.be.getLevel(), (IRedstoneLinkable)noteEntry.getValue());
            }
        }
    }

    public ManualNoteFrequency noteFrequency(int channel, int pitch, int velocity) {
        RedstoneLinkNetworkHandler.Frequency keyFreq = this.FrequencyKeys.get(channel);
        RedstoneLinkNetworkHandler.Frequency pitchFreq = RedstoneLinkNetworkHandler.Frequency.of((ItemStack)PitchMapping.getStack(pitch));
        return ManualNoteFrequency.create(this.be.getBlockPos(), keyFreq, pitchFreq, ManualNoteFrequency.midiVelocityToRedstone(velocity));
    }

    public void activateNote(int channel, int pitch, int velocity) {
        ManualNoteFrequency noteFrequency = this.noteFrequency(channel, pitch, velocity);
        Create.REDSTONE_LINK_NETWORK_HANDLER.addToNetwork((LevelAccessor)this.be.getLevel(), (IRedstoneLinkable)noteFrequency);
        this.activeNotes.get(channel).put(pitch, noteFrequency);
    }

    public void deactivateNote(int channel, int pitch) {
        Map<Integer, ManualNoteFrequency> channelNotes = this.activeNotes.get(channel);
        if (channelNotes.containsKey(pitch)) {
            ManualNoteFrequency noteFrequency = channelNotes.get(pitch);
            channelNotes.remove(pitch);
            Create.REDSTONE_LINK_NETWORK_HANDLER.removeFromNetwork((LevelAccessor)this.be.getLevel(), (IRedstoneLinkable)noteFrequency);
        }
    }

    public boolean areNotesActive() {
        for (Map<Integer, ManualNoteFrequency> i : this.activeNotes) {
            if (i.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public static class ManualNoteFrequency
    extends IntAttached<Couple<RedstoneLinkNetworkHandler.Frequency>>
    implements IRedstoneLinkable {
        private final BlockPos pos;
        private final int strength;

        public ManualNoteFrequency(BlockPos pos, Couple<RedstoneLinkNetworkHandler.Frequency> second, int velocity) {
            super(Integer.valueOf(2), second);
            this.pos = pos;
            this.strength = velocity;
        }

        public static ManualNoteFrequency create(BlockPos pos, RedstoneLinkNetworkHandler.Frequency key, RedstoneLinkNetworkHandler.Frequency pitch, int velocity) {
            return new ManualNoteFrequency(pos, (Couple<RedstoneLinkNetworkHandler.Frequency>)Couple.create((Object)key, (Object)pitch), velocity);
        }

        public static int midiVelocityToRedstone(int velocity) {
            return Math.round(MathUtils.map(velocity, 0.0f, 127.0f, 0.0f, 15.0f));
        }

        public int getTransmittedStrength() {
            return this.isAlive() ? this.strength : 0;
        }

        public boolean isAlive() {
            return (Integer)this.getFirst() > 0;
        }

        public BlockPos getLocation() {
            return this.pos;
        }

        public void setReceivedStrength(int power) {
        }

        public boolean isListening() {
            return false;
        }

        public Couple<RedstoneLinkNetworkHandler.Frequency> getNetworkKey() {
            return (Couple)this.getSecond();
        }
    }
}

