/*
 * Decompiled with CFR 0.152.
 */
package com.finchy.pipeorgans.content.midi;

import com.finchy.pipeorgans.PipeOrgans;
import com.finchy.pipeorgans.content.midi.MidiFileParser;
import com.finchy.pipeorgans.content.midi.trackerBar.TrackerBarBlockEntity;
import com.finchy.pipeorgans.util.MidiLoadException;
import com.finchy.pipeorgans.util.MidiUtils;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.Sequence;
import javax.sound.midi.ShortMessage;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;

public class MidiSequencerBehaviour
extends BlockEntityBehaviour {
    public static final BehaviourType<MidiSequencerBehaviour> TYPE = new BehaviourType();
    private List<Queue<MidiEvent>> currentSequence = null;
    private boolean playing = false;
    private int tickPosition = 0;
    private int ppq;
    private int tickStep = 1;
    private double bpm;
    private int endTick = 1;
    public List<Integer> channelInstruments = new ArrayList<Integer>(defaultChannelInstruments);
    private static final List<Integer> defaultChannelInstruments = new ArrayList<Integer>(Collections.nCopies(16, -1));
    private String currentMidi = "";
    private String currentMidiOwner = "";
    private boolean renderPaper = false;

    public MidiSequencerBehaviour(SmartBlockEntity be) {
        super(be);
    }

    public BehaviourType<?> getType() {
        return TYPE;
    }

    public void write(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        if (clientPacket) {
            tag.putBoolean("RenderPaper", this.renderPaper);
        }
        tag.putString("File", this.currentMidi);
        tag.putString("Owner", this.currentMidiOwner);
        tag.putBoolean("Playing", this.playing);
        tag.putInt("TickPosition", this.tickPosition);
    }

    public void read(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        if (clientPacket) {
            this.renderPaper = tag.getBoolean("RenderPaper");
        }
        String midiRead = tag.getString("File");
        String ownerRead = tag.getString("Owner");
        try {
            if (!midiRead.isEmpty() && !ownerRead.isEmpty()) {
                if (!midiRead.equals(this.currentMidi) || !ownerRead.equals(this.currentMidiOwner)) {
                    this.loadSequence(midiRead, ownerRead);
                }
            } else {
                this.setButtonsEnabled(false);
                return;
            }
            this.setButtonsEnabled(true);
        }
        catch (MidiLoadException e) {
            PipeOrgans.LOGGER.error("Exception when loading from Tracker Bar NBT: {}", (Object)e.getMessage());
            this.setButtonsEnabled(false);
            return;
        }
        this.playing = tag.getBoolean("Playing");
        this.tickPosition = tag.getInt("TickPosition");
    }

    private boolean isClientside() {
        return this.getWorld() != null && this.getWorld().isClientSide;
    }

    public void loadSequence(String file, String owner) throws MidiLoadException {
        if (this.isClientside()) {
            return;
        }
        Sequence sequence = MidiFileParser.getSequenceFromFile(file, owner);
        this.currentSequence = MidiFileParser.parseMidiEvents(sequence);
        this.channelInstruments = new ArrayList<Integer>(defaultChannelInstruments);
        this.ppq = sequence.getResolution();
        MidiFileParser.initialParse(sequence, this::setChannelInstrument, this::setTempo);
        this.endTick = MidiFileParser.endTick(sequence);
        this.currentMidi = file;
        this.currentMidiOwner = owner;
        this.renderPaper = true;
        this.blockEntity.notifyUpdate();
    }

    public void unloadSequence() {
        if (this.isClientside()) {
            this.playing = false;
            this.blockEntity.notifyUpdate();
            return;
        }
        this.currentSequence = null;
        this.currentMidi = "";
        this.currentMidiOwner = "";
        this.channelInstruments = new ArrayList<Integer>(defaultChannelInstruments);
        this.playing = false;
        this.tickPosition = 0;
        this.tickStep = 1;
        this.renderPaper = false;
        ((TrackerBarBlockEntity)this.blockEntity).stopAllNotes();
        this.blockEntity.notifyUpdate();
    }

    public boolean isSequenceLoaded() {
        if (this.isClientside()) {
            return this.renderPaper;
        }
        return this.currentSequence != null && !this.currentMidi.isEmpty() && !this.currentMidiOwner.isEmpty();
    }

    public void setTempo(byte[] data) {
        int microsPerQuarterNote = (data[0] & 0xFF) << 16 | (data[1] & 0xFF) << 8 | data[2] & 0xFF;
        this.bpm = 6.0E7f / (float)microsPerQuarterNote;
        float midiTPS = 1000000.0f / (float)microsPerQuarterNote * (float)this.ppq;
        this.tickStep = Math.round(midiTPS / 20.0f);
        this.blockEntity.notifyUpdate();
    }

    public void setChannelInstrument(int channel, int program) {
        this.channelInstruments.set(channel, program);
    }

    public void tickSequencer() {
        if (this.isClientside()) {
            return;
        }
        for (Queue<MidiEvent> track : this.currentSequence) {
            while (track.peek() != null && track.peek().getTick() <= (long)this.tickPosition) {
                MidiMessage msg = track.poll().getMessage();
                if (this.tickPosition >= this.endTick) {
                    this.restartPlayback();
                    return;
                }
                if (msg instanceof MetaMessage) {
                    MetaMessage mm = (MetaMessage)msg;
                    if (!MidiUtils.isTempoChange(mm)) continue;
                    this.setTempo(mm.getData());
                    continue;
                }
                if (!(msg instanceof ShortMessage)) continue;
                ShortMessage sm = (ShortMessage)msg;
                if (MidiUtils.isNoteOn(sm) || MidiUtils.isNoteOff(sm)) {
                    ((TrackerBarBlockEntity)this.blockEntity).handleNote(sm);
                    continue;
                }
                if (!MidiUtils.isProgramChange(sm)) continue;
                this.channelInstruments.set(sm.getChannel(), sm.getData1());
            }
        }
        this.tickPosition += this.tickStep;
    }

    public void toggleSequencer() {
        boolean bl = this.playing = !this.playing;
        if (!this.playing) {
            ((TrackerBarBlockEntity)this.blockEntity).stopAllNotes();
        }
        this.blockEntity.notifyUpdate();
    }

    public void restartPlayback() {
        this.playing = false;
        ((TrackerBarBlockEntity)this.blockEntity).stopAllNotes();
        this.tickPosition = 0;
        try {
            this.loadSequence(this.currentMidi, this.currentMidiOwner);
        }
        catch (MidiLoadException e) {
            this.setButtonsEnabled(false);
        }
        this.blockEntity.notifyUpdate();
    }

    private void setButtonsEnabled(boolean enabled) {
        ((TrackerBarBlockEntity)this.blockEntity).setButtonsEnabled(enabled);
    }

    public boolean isPlaying() {
        return this.playing;
    }

    public int getTickPosition() {
        return this.tickPosition;
    }

    public int getEndTick() {
        return this.endTick;
    }

    public int get10xBPM() {
        return (int)this.bpm * 10;
    }

    public String getCurrentMidi() {
        return this.currentMidi;
    }

    public double getPlaybackPercentage() {
        return (double)this.tickPosition / (double)this.endTick;
    }
}

