/*
 * Decompiled with CFR 0.152.
 */
package com.finchy.pipeorgans.content.base;

import com.finchy.pipeorgans.content.pipes.generic.GenericPipeBlock;
import com.simibubi.create.content.fluids.tank.FluidTankBlockEntity;
import com.simibubi.create.content.kinetics.steamEngine.SteamJetParticleData;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.lang.ref.WeakReference;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class BaseBlockEntity
extends SmartBlockEntity {
    public WeakReference<FluidTankBlockEntity> source = new WeakReference<Object>(null);

    public BaseBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    protected boolean isPowered() {
        return this.getBlockState().getOptionalValue((Property)GenericPipeBlock.POWERED).orElse(false);
    }

    public void tick() {
        super.tick();
        FluidTankBlockEntity tank = this.getTank();
        if (this.isPowered() && this.level.getGameTime() % 8L == 0L && (tank != null && tank.boiler.isActive() && (tank.boiler.passiveHeat || tank.boiler.activeHeat > 0) || this.isVirtual())) {
            this.createSteamJet();
        }
    }

    public void createSteamJet() {
        Vec3 v = new Vec3(0.0, 0.8125, 0.0).add(Vec3.atBottomCenterOf((Vec3i)this.worldPosition));
        Vec3 m = new Vec3(0.0, 1.0, 0.0);
        this.level.addParticle((ParticleOptions)new SteamJetParticleData(1.0f), v.x, v.y, v.z, m.x, m.y, m.z);
    }

    public FluidTankBlockEntity getTank() {
        FluidTankBlockEntity tank = (FluidTankBlockEntity)this.source.get();
        if (tank == null || tank.isRemoved()) {
            Direction facing;
            BlockEntity be;
            if (tank != null) {
                this.source = new WeakReference<Object>(null);
            }
            if ((be = this.level.getBlockEntity(this.worldPosition.relative(facing = GenericPipeBlock.getAttachedDirection(this.getBlockState())))) instanceof FluidTankBlockEntity) {
                FluidTankBlockEntity tankBe;
                tank = tankBe = (FluidTankBlockEntity)be;
                this.source = new WeakReference<FluidTankBlockEntity>(tank);
            }
        }
        if (tank == null) {
            return null;
        }
        return tank.getControllerBE();
    }
}

