/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.world.level.block.plant.aquatic;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.regions_unexplored.block.RuBlocks;

public class GiantLilyBlock
extends HorizontalDirectionalBlock {
    public static final MapCodec<? extends GiantLilyBlock> CODEC = GiantLilyBlock.simpleCodec(GiantLilyBlock::new);
    protected static final VoxelShape NORTH = Block.box((double)0.0, (double)0.0, (double)2.0, (double)14.0, (double)4.0, (double)16.0);
    protected static final VoxelShape EAST = Block.box((double)0.0, (double)0.0, (double)0.0, (double)14.0, (double)4.0, (double)14.0);
    protected static final VoxelShape SOUTH = Block.box((double)2.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)14.0);
    protected static final VoxelShape WEST = Block.box((double)2.0, (double)0.0, (double)2.0, (double)16.0, (double)4.0, (double)16.0);

    public GiantLilyBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    public ItemStack getCloneItemStack(LevelReader levelReader, BlockPos blockPos, BlockState blockState) {
        return new ItemStack((ItemLike)RuBlocks.FLOWERING_LILY_PAD.get());
    }

    public void fallOn(Level level, BlockState state, BlockPos pos, Entity entity, float f) {
        if (entity.getType() != EntityType.FROG) {
            if (entity.isSuppressingBounce()) {
                super.fallOn(level, state, pos, entity, f);
            } else {
                entity.causeFallDamage(f, 0.0f, level.damageSources().fall());
            }
        }
    }

    public void updateEntityAfterFallOn(BlockGetter blockGetter, Entity entity) {
        Vec3 vec3 = entity.getDeltaMovement();
        if (vec3.y < -0.7) {
            if (entity.getType() != EntityType.FROG) {
                if (entity.isSuppressingBounce()) {
                    super.updateEntityAfterFallOn(blockGetter, entity);
                } else {
                    this.bounceUp(entity);
                }
            }
        } else {
            entity.setDeltaMovement(entity.getDeltaMovement().multiply(1.0, 0.0, 1.0));
            entity.setDeltaMovement(entity.getDeltaMovement().multiply(1.0, 0.0, 1.0));
        }
    }

    private void bounceUp(Entity entity) {
        if (entity.getType() != EntityType.FROG) {
            Vec3 vec3 = entity.getDeltaMovement();
            if (vec3.y < 0.0) {
                double d0 = entity instanceof LivingEntity ? 1.0 : 0.8;
                entity.setDeltaMovement(vec3.x, -vec3.y * d0, vec3.z);
            }
        }
    }

    public VoxelShape getShape(BlockState state, BlockGetter block, BlockPos pos, CollisionContext context) {
        if (state == this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH)) {
            return NORTH;
        }
        if (state == this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.EAST)) {
            return EAST;
        }
        if (state == this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.SOUTH)) {
            return SOUTH;
        }
        return WEST;
    }

    public BlockState updateShape(BlockState p_51032_, Direction p_51033_, BlockState p_51034_, LevelAccessor p_51035_, BlockPos p_51036_, BlockPos p_51037_) {
        return !p_51032_.canSurvive((LevelReader)p_51035_, p_51036_) ? Blocks.AIR.defaultBlockState() : super.updateShape(p_51032_, p_51033_, p_51034_, p_51035_, p_51036_, p_51037_);
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        if (level.getFluidState(pos.below()).is((Fluid)Fluids.WATER)) {
            if (state == this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH)) {
                return level.getBlockState(pos.west()) == RuBlocks.GIANT_LILY_PAD.get().defaultBlockState().setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)Direction.WEST) & level.getBlockState(pos.south().west()) == RuBlocks.GIANT_LILY_PAD.get().defaultBlockState().setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)Direction.SOUTH) & level.getBlockState(pos.south()) == RuBlocks.GIANT_LILY_PAD.get().defaultBlockState().setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)Direction.EAST);
            }
            if (state == this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.EAST)) {
                return level.getBlockState(pos.north()) == RuBlocks.GIANT_LILY_PAD.get().defaultBlockState().setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)Direction.NORTH) & level.getBlockState(pos.west()) == RuBlocks.GIANT_LILY_PAD.get().defaultBlockState().setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)Direction.SOUTH) & level.getBlockState(pos.west().north()) == RuBlocks.GIANT_LILY_PAD.get().defaultBlockState().setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)Direction.WEST);
            }
            if (state == this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.SOUTH)) {
                return level.getBlockState(pos.north().east()) == RuBlocks.GIANT_LILY_PAD.get().defaultBlockState().setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)Direction.NORTH) & level.getBlockState(pos.east()) == RuBlocks.GIANT_LILY_PAD.get().defaultBlockState().setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)Direction.EAST) & level.getBlockState(pos.north()) == RuBlocks.GIANT_LILY_PAD.get().defaultBlockState().setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)Direction.WEST);
            }
            return level.getBlockState(pos.east()) == RuBlocks.GIANT_LILY_PAD.get().defaultBlockState().setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)Direction.NORTH) & level.getBlockState(pos.south().east()) == RuBlocks.GIANT_LILY_PAD.get().defaultBlockState().setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)Direction.EAST) & level.getBlockState(pos.south()) == RuBlocks.GIANT_LILY_PAD.get().defaultBlockState().setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)Direction.SOUTH);
        }
        return false;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Direction direction = context.getHorizontalDirection().getOpposite();
        if (context.getHorizontalDirection().getOpposite() == Direction.NORTH) {
            if (!level.isClientSide()) {
                level.setBlock(pos.west(), (BlockState)this.defaultBlockState().setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)Direction.WEST), 20);
                level.setBlock(pos.south().west(), (BlockState)this.defaultBlockState().setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)Direction.SOUTH), 20);
                level.setBlock(pos.south(), (BlockState)this.defaultBlockState().setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)Direction.EAST), 20);
                level.blockUpdated(pos.west(), Blocks.AIR);
                level.blockUpdated(pos.south().west(), Blocks.AIR);
                level.blockUpdated(pos.south(), Blocks.AIR);
            }
            return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
        }
        if (context.getHorizontalDirection().getOpposite() == Direction.EAST) {
            if (!level.isClientSide()) {
                level.setBlock(pos.north(), (BlockState)this.defaultBlockState().setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)Direction.NORTH), 20);
                level.setBlock(pos.west(), (BlockState)this.defaultBlockState().setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)Direction.SOUTH), 20);
                level.setBlock(pos.west().north(), (BlockState)this.defaultBlockState().setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)Direction.WEST), 20);
            }
            return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
        }
        if (context.getHorizontalDirection().getOpposite() == Direction.SOUTH) {
            if (!level.isClientSide()) {
                level.setBlock(pos.north().east(), (BlockState)this.defaultBlockState().setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)Direction.NORTH), 20);
                level.setBlock(pos.east(), (BlockState)this.defaultBlockState().setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)Direction.EAST), 20);
                level.setBlock(pos.north(), (BlockState)this.defaultBlockState().setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)Direction.WEST), 20);
            }
            return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
        }
        if (!level.isClientSide()) {
            level.setBlock(pos.east(), (BlockState)this.defaultBlockState().setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)Direction.NORTH), 20);
            level.setBlock(pos.south().east(), (BlockState)this.defaultBlockState().setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)Direction.EAST), 20);
            level.setBlock(pos.south(), (BlockState)this.defaultBlockState().setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)Direction.SOUTH), 20);
        }
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_54794_) {
        p_54794_.add(new Property[]{FACING});
    }

    public int getLightBlock(BlockState p_54460_, BlockGetter p_54461_, BlockPos p_54462_) {
        return 0;
    }

    public boolean propagatesSkylightDown(BlockState p_51039_, BlockGetter p_51040_, BlockPos p_51041_) {
        return false;
    }
}

