/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.datagen.provider;

import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.IntrinsicHolderTagsProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.BlockTagsProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.regions_unexplored.block.RuBlocks;
import net.regions_unexplored.block.set.NaturalSet;
import net.regions_unexplored.block.set.WoodSet;
import net.regions_unexplored.data.tags.RuTags;
import org.jetbrains.annotations.Nullable;

public class RuBlockTagProvider
extends BlockTagsProvider {
    public RuBlockTagProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, String modId, @Nullable ExistingFileHelper existingFileHelper) {
        super(output, lookupProvider, modId, existingFileHelper);
    }

    public void addTags(HolderLookup.Provider provider) {
        this.addCommonTags(provider);
        IntrinsicHolderTagsProvider.IntrinsicTagAppender planks = this.tag(BlockTags.PLANKS);
        IntrinsicHolderTagsProvider.IntrinsicTagAppender stairs = this.tag(BlockTags.WOODEN_STAIRS);
        IntrinsicHolderTagsProvider.IntrinsicTagAppender slabs = this.tag(BlockTags.WOODEN_SLABS);
        IntrinsicHolderTagsProvider.IntrinsicTagAppender fences = this.tag(BlockTags.WOODEN_FENCES);
        IntrinsicHolderTagsProvider.IntrinsicTagAppender fenceGates = this.tag(BlockTags.FENCE_GATES);
        IntrinsicHolderTagsProvider.IntrinsicTagAppender doors = this.tag(BlockTags.WOODEN_DOORS);
        IntrinsicHolderTagsProvider.IntrinsicTagAppender trapdoors = this.tag(BlockTags.WOODEN_TRAPDOORS);
        IntrinsicHolderTagsProvider.IntrinsicTagAppender buttons = this.tag(BlockTags.WOODEN_BUTTONS);
        IntrinsicHolderTagsProvider.IntrinsicTagAppender pressurePlates = this.tag(BlockTags.WOODEN_PRESSURE_PLATES);
        IntrinsicHolderTagsProvider.IntrinsicTagAppender signs = this.tag(BlockTags.STANDING_SIGNS);
        IntrinsicHolderTagsProvider.IntrinsicTagAppender wallSigns = this.tag(BlockTags.WALL_SIGNS);
        IntrinsicHolderTagsProvider.IntrinsicTagAppender hangingSigns = this.tag(BlockTags.CEILING_HANGING_SIGNS);
        IntrinsicHolderTagsProvider.IntrinsicTagAppender wallHangingSigns = this.tag(BlockTags.WALL_HANGING_SIGNS);
        for (WoodSet woodSet : RuBlocks.WOOD_SETS) {
            if (woodSet.getPlanks() != null) {
                planks.add((Object)woodSet.getPlanks());
            }
            if (woodSet.getStairs() != null) {
                stairs.add((Object)woodSet.getStairs());
            }
            if (woodSet.getSlab() != null) {
                slabs.add((Object)woodSet.getSlab());
            }
            if (woodSet.getFence() != null) {
                fences.add((Object)woodSet.getFence());
            }
            if (woodSet.getFenceGate() != null) {
                fenceGates.add((Object)woodSet.getFenceGate());
            }
            if (woodSet.getDoor() != null) {
                doors.add((Object)woodSet.getDoor());
            }
            if (woodSet.getTrapdoor() != null) {
                trapdoors.add((Object)woodSet.getTrapdoor());
            }
            if (woodSet.getButton() != null) {
                buttons.add((Object)woodSet.getButton());
            }
            if (woodSet.getPressurePlate() != null) {
                pressurePlates.add((Object)woodSet.getPressurePlate());
            }
            if (woodSet.getSign() != null) {
                signs.add((Object)woodSet.getSign());
            }
            if (woodSet.getWallSign() != null) {
                wallSigns.add((Object)woodSet.getWallSign());
            }
            if (woodSet.getHangingSign() != null) {
                hangingSigns.add((Object)woodSet.getHangingSign());
            }
            if (woodSet.getWallHangingSign() == null) continue;
            wallHangingSigns.add((Object)woodSet.getWallHangingSign());
        }
        RuBlocks.PAINTED_PLANKS.getAll().forEach(arg_0 -> ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)planks).add(arg_0));
        RuBlocks.PAINTED_STAIRS.getAll().forEach(arg_0 -> ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)stairs).add(arg_0));
        RuBlocks.PAINTED_SLABS.getAll().forEach(arg_0 -> ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)slabs).add(arg_0));
        IntrinsicHolderTagsProvider.IntrinsicTagAppender saplings = this.tag(BlockTags.SAPLINGS);
        for (NaturalSet set : RuBlocks.NATURAL_SETS) {
            if (set.getSapling() == null) continue;
            saplings.add((Object)set.getSapling());
        }
        this.tag(BlockTags.ARMADILLO_SPAWNABLE_ON).add((Object)Blocks.SAND).add((Object)RuBlocks.PEAT_COARSE_DIRT.get()).add((Object)RuBlocks.SILT_COARSE_DIRT.get()).add((Object)RuBlocks.SILT_GRASS_BLOCK.get()).add((Object)RuBlocks.SILT_PODZOL.get());
        this.tag(BlockTags.MINEABLE_WITH_AXE).add((Object)RuBlocks.BLUE_BIOSHROOM_BLOCK.get()).add((Object)RuBlocks.GREEN_BIOSHROOM_BLOCK.get()).add((Object)RuBlocks.PINK_BIOSHROOM_BLOCK.get()).add((Object)RuBlocks.YELLOW_BIOSHROOM_BLOCK.get()).add((Object)RuBlocks.GLOWING_BLUE_BIOSHROOM_BLOCK.get()).add((Object)RuBlocks.GLOWING_GREEN_BIOSHROOM_BLOCK.get()).add((Object)RuBlocks.GLOWING_PINK_BIOSHROOM_BLOCK.get()).add((Object)RuBlocks.GLOWING_YELLOW_BIOSHROOM_BLOCK.get()).add((Object)RuBlocks.MEADOW_SAGE.get()).add((Object)RuBlocks.BARLEY.get()).add((Object)RuBlocks.CATTAIL.get()).add((Object)RuBlocks.DEAD_STEPPE_SHRUB.get()).add((Object)RuBlocks.ELEPHANT_EAR.get()).add((Object)RuBlocks.CORPSE_FLOWER.get()).add((Object)RuBlocks.FROZEN_GRASS.get()).add((Object)RuBlocks.MEDIUM_GRASS.get()).add((Object)RuBlocks.BLADED_GRASS.get()).add((Object)RuBlocks.SANDY_GRASS.get()).add((Object)RuBlocks.SANDY_TALL_GRASS.get()).add((Object)RuBlocks.SMALL_DESERT_SHRUB.get()).add((Object)RuBlocks.STEPPE_GRASS.get()).add((Object)RuBlocks.STEPPE_SHRUB.get()).add((Object)RuBlocks.STEPPE_TALL_GRASS.get()).add((Object)RuBlocks.BLADED_TALL_GRASS.get()).add((Object)RuBlocks.STONE_BUD.get()).add((Object)RuBlocks.TASSEL.get()).add((Object)RuBlocks.DAY_LILY.get()).add((Object)RuBlocks.WINDSWEPT_GRASS.get()).add((Object)RuBlocks.PINK_BIOSHROOM.get()).add((Object)RuBlocks.BLUE_BIOSHROOM.get()).add((Object)RuBlocks.GREEN_BIOSHROOM.get()).add((Object)RuBlocks.YELLOW_BIOSHROOM.get()).add((Object)RuBlocks.HANGING_EARLIGHT.get()).add((Object)RuBlocks.HANGING_EARLIGHT_PLANT.get()).add((Object)RuBlocks.DROPLEAF.get()).add((Object)RuBlocks.DROPLEAF_PLANT.get()).add((Object)RuBlocks.GLISTERING_IVY.get()).add((Object)RuBlocks.GLISTERING_IVY_PLANT.get()).add((Object)RuBlocks.SPANISH_MOSS.get()).add((Object)RuBlocks.SPANISH_MOSS_PLANT.get()).add((Object)RuBlocks.KAPOK_VINES.get()).add((Object)RuBlocks.KAPOK_VINES_PLANT.get()).add((Object)RuBlocks.DUCKWEED.get()).add((Object)RuBlocks.BARREL_CACTUS.get()).add((Object)RuBlocks.SAGUARO_CACTUS.get()).add((Object)RuBlocks.SALMONBERRY_BUSH.get()).add((Object)RuBlocks.DUSKMELON.get()).add((Object)RuBlocks.FLOWERING_LILY_PAD.get()).add((Object)RuBlocks.GIANT_LILY_PAD.get()).addTags(new TagKey[]{RuTags.SHRUBS});
        this.tag(BlockTags.MINEABLE_WITH_HOE).add((Object)RuBlocks.ALPHA_NATURAL_SET.getLeaves()).add((Object)RuBlocks.APPLE_OAK_NATURAL_SET.getLeaves()).add((Object)RuBlocks.ASHEN_NATURAL_SET.getLeaves()).add((Object)RuBlocks.BAMBOO_NATURAL_SET.getLeaves()).add((Object)RuBlocks.BAOBAB_NATURAL_SET.getLeaves()).add((Object)RuBlocks.BLACKWOOD_NATURAL_SET.getLeaves()).add((Object)RuBlocks.COBALT_NATURAL_SET.getLeaves()).add((Object)RuBlocks.BRIMWOOD_NATURAL_SET.getLeaves()).add((Object)RuBlocks.CYPRESS_NATURAL_SET.getLeaves()).add((Object)RuBlocks.DEAD_NATURAL_SET.getLeaves()).add((Object)RuBlocks.DEAD_PINE_NATURAL_SET.getLeaves()).add((Object)RuBlocks.EUCALYPTUS_NATURAL_SET.getLeaves()).add((Object)RuBlocks.FLOWERING_NATURAL_SET.getLeaves()).add((Object)RuBlocks.BLUE_BIOSHROOM_BLOCK.get()).add((Object)RuBlocks.GREEN_BIOSHROOM_BLOCK.get()).add((Object)RuBlocks.PINK_BIOSHROOM_BLOCK.get()).add((Object)RuBlocks.YELLOW_BIOSHROOM_BLOCK.get()).add((Object)RuBlocks.GLOWING_BLUE_BIOSHROOM_BLOCK.get()).add((Object)RuBlocks.GLOWING_GREEN_BIOSHROOM_BLOCK.get()).add((Object)RuBlocks.GLOWING_PINK_BIOSHROOM_BLOCK.get()).add((Object)RuBlocks.GLOWING_YELLOW_BIOSHROOM_BLOCK.get()).add((Object)RuBlocks.GOLDEN_LARCH_NATURAL_SET.getLeaves()).add((Object)RuBlocks.JOSHUA_NATURAL_SET.getLeaves()).add((Object)RuBlocks.KAPOK_NATURAL_SET.getLeaves()).add((Object)RuBlocks.LARCH_NATURAL_SET.getLeaves()).add((Object)RuBlocks.MAPLE_NATURAL_SET.getLeaves()).add((Object)RuBlocks.MAUVE_NATURAL_SET.getLeaves()).add((Object)RuBlocks.ORANGE_MAPLE_NATURAL_SET.getLeaves()).add((Object)RuBlocks.PALM_NATURAL_SET.getLeaves()).add((Object)RuBlocks.PINE_NATURAL_SET.getLeaves()).add((Object)RuBlocks.BLUE_MAGNOLIA_NATURAL_SET.getLeaves()).add((Object)RuBlocks.PINK_MAGNOLIA_NATURAL_SET.getLeaves()).add((Object)RuBlocks.REDWOOD_NATURAL_SET.getLeaves()).add((Object)RuBlocks.RED_MAPLE_NATURAL_SET.getLeaves()).add((Object)RuBlocks.MAGNOLIA_NATURAL_SET.getLeaves()).add((Object)RuBlocks.SILVER_BIRCH_NATURAL_SET.getLeaves()).add((Object)RuBlocks.SMALL_OAK_NATURAL_SET.getLeaves()).add((Object)RuBlocks.SOCOTRA_NATURAL_SET.getLeaves()).add((Object)RuBlocks.ENCHANTED_BIRCH_NATURAL_SET.getLeaves()).add((Object)RuBlocks.WHITE_MAGNOLIA_NATURAL_SET.getLeaves()).add((Object)RuBlocks.WILLOW_NATURAL_SET.getLeaves()).add((Object)RuBlocks.PRISMOSS_SPROUT.get()).add((Object)RuBlocks.ORANGE_CONEFLOWER.get()).add((Object)RuBlocks.PURPLE_CONEFLOWER.get()).add((Object)RuBlocks.CLOVER.get()).add((Object)RuBlocks.MYCOTOXIC_MUSHROOMS.get());
        this.tag(BlockTags.MINEABLE_WITH_PICKAXE).add((Object)RuBlocks.ICICLE.get()).add((Object)RuBlocks.ASH_VENT.get()).add((Object)RuBlocks.BLACKSTONE_CLUSTER.get()).add((Object)RuBlocks.BRIMSPROUT_NYLIUM.get()).add((Object)RuBlocks.CHALK.get()).add((Object)RuBlocks.CHALK_GRASS_BLOCK.get()).add((Object)RuBlocks.PRISMARITE_CLUSTER.get()).add((Object)RuBlocks.LARGE_PRISMARITE_CLUSTER.get()).add((Object)RuBlocks.HANGING_PRISMARITE.get()).add((Object)RuBlocks.CHALK_PILLAR.get()).add((Object)RuBlocks.CHALK_SLAB.get()).add((Object)RuBlocks.CHALK_STAIRS.get()).add((Object)RuBlocks.COBALT_NYLIUM.get()).add((Object)RuBlocks.COBALT_OBSIDIAN.get()).add((Object)RuBlocks.DEEPSLATE_GRASS_BLOCK.get()).add((Object)RuBlocks.DEEPSLATE_PRISMOSS.get()).add((Object)RuBlocks.DEEPSLATE_VIRIDESCENT_NYLIUM.get()).add((Object)RuBlocks.GLISTERING_NYLIUM.get()).add((Object)RuBlocks.GLISTERING_WART.get()).add((Object)RuBlocks.OVERGROWN_BONE_BLOCK.get()).add((Object)RuBlocks.MOSSY_STONE.get()).add((Object)RuBlocks.ARGILLITE.get()).add((Object)RuBlocks.MYCOTOXIC_NYLIUM.get()).add((Object)RuBlocks.POINTED_REDSTONE.get()).add((Object)RuBlocks.POLISHED_CHALK.get()).add((Object)RuBlocks.POLISHED_CHALK_SLAB.get()).add((Object)RuBlocks.POLISHED_CHALK_STAIRS.get()).add((Object)RuBlocks.CHALK_BRICKS.get()).add((Object)RuBlocks.CHALK_BRICK_SLAB.get()).add((Object)RuBlocks.CHALK_BRICK_STAIRS.get()).add((Object)RuBlocks.PRISMOSS.get()).add((Object)RuBlocks.RAW_REDSTONE_BLOCK.get()).add((Object)RuBlocks.REDSTONE_BUD.get()).add((Object)RuBlocks.REDSTONE_BULB.get()).add((Object)RuBlocks.STONE_GRASS_BLOCK.get()).add((Object)RuBlocks.ARGILLITE_GRASS_BLOCK.get()).add((Object)RuBlocks.VIRIDESCENT_NYLIUM.get());
        this.tag(BlockTags.MINEABLE_WITH_SHOVEL).add((Object)RuBlocks.ALPHA_GRASS_BLOCK.get()).add((Object)RuBlocks.ASH.get()).add((Object)RuBlocks.ASHEN_DIRT.get()).add((Object)RuBlocks.PEAT_COARSE_DIRT.get()).add((Object)RuBlocks.PEAT_PODZOL.get()).add((Object)RuBlocks.PEAT_DIRT.get()).add((Object)RuBlocks.PEAT_DIRT_PATH.get()).add((Object)RuBlocks.PEAT_FARMLAND.get()).add((Object)RuBlocks.PEAT_GRASS_BLOCK.get()).add((Object)RuBlocks.PEAT_MUD.get()).add((Object)RuBlocks.SILT_COARSE_DIRT.get()).add((Object)RuBlocks.SILT_PODZOL.get()).add((Object)RuBlocks.SILT_DIRT.get()).add((Object)RuBlocks.SILT_DIRT_PATH.get()).add((Object)RuBlocks.SILT_FARMLAND.get()).add((Object)RuBlocks.SILT_GRASS_BLOCK.get()).add((Object)RuBlocks.SILT_MUD.get()).add((Object)RuBlocks.VOLCANIC_ASH.get());
        this.tag(BlockTags.ANIMALS_SPAWNABLE_ON).add((Object)RuBlocks.ALPHA_GRASS_BLOCK.get()).add((Object)RuBlocks.ASHEN_DIRT.get()).add((Object)RuBlocks.CHALK_GRASS_BLOCK.get()).add((Object)RuBlocks.DEEPSLATE_GRASS_BLOCK.get()).add((Object)RuBlocks.DEEPSLATE_PRISMOSS.get()).add((Object)RuBlocks.DEEPSLATE_VIRIDESCENT_NYLIUM.get()).add((Object)RuBlocks.PEAT_COARSE_DIRT.get()).add((Object)RuBlocks.PEAT_PODZOL.get()).add((Object)RuBlocks.PEAT_DIRT.get()).add((Object)RuBlocks.PEAT_FARMLAND.get()).add((Object)RuBlocks.PEAT_GRASS_BLOCK.get()).add((Object)RuBlocks.PEAT_MUD.get()).add((Object)RuBlocks.SILT_COARSE_DIRT.get()).add((Object)RuBlocks.SILT_PODZOL.get()).add((Object)RuBlocks.SILT_DIRT.get()).add((Object)RuBlocks.SILT_FARMLAND.get()).add((Object)RuBlocks.SILT_GRASS_BLOCK.get()).add((Object)RuBlocks.SILT_MUD.get()).add((Object)RuBlocks.PRISMOSS.get()).add((Object)RuBlocks.STONE_GRASS_BLOCK.get()).add((Object)RuBlocks.ARGILLITE_GRASS_BLOCK.get()).add((Object)RuBlocks.VIRIDESCENT_NYLIUM.get()).add(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"podzol"))).add(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"coarse_dirt")));
        this.tag(BlockTags.AXOLOTLS_SPAWNABLE_ON).add(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"calcite")));
        this.tag(BlockTags.AZALEA_GROWS_ON).add((Object)RuBlocks.ALPHA_GRASS_BLOCK.get()).add((Object)RuBlocks.ASHEN_DIRT.get()).add((Object)RuBlocks.CHALK_GRASS_BLOCK.get()).add((Object)RuBlocks.DEEPSLATE_GRASS_BLOCK.get()).add((Object)RuBlocks.DEEPSLATE_PRISMOSS.get()).add((Object)RuBlocks.DEEPSLATE_VIRIDESCENT_NYLIUM.get()).add((Object)RuBlocks.PEAT_COARSE_DIRT.get()).add((Object)RuBlocks.PEAT_PODZOL.get()).add((Object)RuBlocks.PEAT_DIRT.get()).add((Object)RuBlocks.PEAT_FARMLAND.get()).add((Object)RuBlocks.PEAT_GRASS_BLOCK.get()).add((Object)RuBlocks.PEAT_MUD.get()).add((Object)RuBlocks.SILT_COARSE_DIRT.get()).add((Object)RuBlocks.SILT_PODZOL.get()).add((Object)RuBlocks.SILT_DIRT.get()).add((Object)RuBlocks.SILT_FARMLAND.get()).add((Object)RuBlocks.SILT_GRASS_BLOCK.get()).add((Object)RuBlocks.SILT_MUD.get()).add((Object)RuBlocks.PRISMOSS.get()).add((Object)RuBlocks.STONE_GRASS_BLOCK.get()).add((Object)RuBlocks.ARGILLITE_GRASS_BLOCK.get()).add((Object)RuBlocks.VIRIDESCENT_NYLIUM.get()).add(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"podzol"))).add(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"coarse_dirt")));
        this.tag(BlockTags.BAMBOO_BLOCKS).addTags(new TagKey[]{RuTags.BAMBOO_LOGS});
        this.tag(BlockTags.BASE_STONE_NETHER).add((Object)RuBlocks.OVERGROWN_BONE_BLOCK.get());
        this.tag(BlockTags.BASE_STONE_OVERWORLD).add((Object)RuBlocks.CHALK.get());
        this.tag(BlockTags.BEE_GROWABLES).add((Object)RuBlocks.SALMONBERRY_BUSH.get()).add((Object)RuBlocks.DUSKMELON.get());
        this.tag(BlockTags.BIRCH_LOGS).add((Object)RuBlocks.SILVER_BIRCH_WOOD_SET.getLog()).add((Object)RuBlocks.SILVER_BIRCH_WOOD_SET.getWood());
        this.tag(BlockTags.CLIMBABLE).add((Object)RuBlocks.GLISTERING_IVY.get()).add((Object)RuBlocks.GLISTERING_IVY_PLANT.get()).add((Object)RuBlocks.HANGING_EARLIGHT.get()).add((Object)RuBlocks.HANGING_EARLIGHT_PLANT.get()).add((Object)RuBlocks.DROPLEAF.get()).add((Object)RuBlocks.DROPLEAF_PLANT.get()).add((Object)RuBlocks.JOSHUA_NATURAL_SET.getLeaves()).add((Object)RuBlocks.SPANISH_MOSS.get()).add((Object)RuBlocks.SPANISH_MOSS_PLANT.get()).add((Object)RuBlocks.KAPOK_VINES.get()).add((Object)RuBlocks.KAPOK_VINES_PLANT.get());
        this.tag(BlockTags.CONVERTABLE_TO_MUD).add((Object)RuBlocks.ASHEN_DIRT.get());
        this.tag(BlockTags.CRYSTAL_SOUND_BLOCKS).add((Object)RuBlocks.HANGING_PRISMARITE.get()).add((Object)RuBlocks.LARGE_PRISMARITE_CLUSTER.get()).add((Object)RuBlocks.PRISMARITE_CLUSTER.get());
        this.tag(BlockTags.DIRT).add((Object)RuBlocks.ALPHA_GRASS_BLOCK.get()).add((Object)RuBlocks.ASHEN_DIRT.get()).add((Object)RuBlocks.CHALK_GRASS_BLOCK.get()).add((Object)RuBlocks.DEEPSLATE_GRASS_BLOCK.get()).add((Object)RuBlocks.DEEPSLATE_PRISMOSS.get()).add((Object)RuBlocks.DEEPSLATE_VIRIDESCENT_NYLIUM.get()).add((Object)RuBlocks.PEAT_COARSE_DIRT.get()).add((Object)RuBlocks.PEAT_PODZOL.get()).add((Object)RuBlocks.PEAT_DIRT.get()).add((Object)RuBlocks.PEAT_FARMLAND.get()).add((Object)RuBlocks.PEAT_GRASS_BLOCK.get()).add((Object)RuBlocks.PEAT_MUD.get()).add((Object)RuBlocks.SILT_COARSE_DIRT.get()).add((Object)RuBlocks.SILT_PODZOL.get()).add((Object)RuBlocks.SILT_DIRT.get()).add((Object)RuBlocks.SILT_FARMLAND.get()).add((Object)RuBlocks.SILT_GRASS_BLOCK.get()).add((Object)RuBlocks.SILT_MUD.get()).add((Object)RuBlocks.PRISMOSS.get()).add((Object)RuBlocks.STONE_GRASS_BLOCK.get()).add((Object)RuBlocks.ARGILLITE_GRASS_BLOCK.get()).add((Object)RuBlocks.VIRIDESCENT_NYLIUM.get());
        this.tag(BlockTags.DRAGON_IMMUNE).add((Object)RuBlocks.COBALT_OBSIDIAN.get());
        this.tag(BlockTags.DRIPSTONE_REPLACEABLE).add((Object)RuBlocks.RAW_REDSTONE_BLOCK.get()).add((Object)RuBlocks.OVERGROWN_BONE_BLOCK.get()).add(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"netherrack")));
        this.tag(BlockTags.ENDERMAN_HOLDABLE).add((Object)RuBlocks.BRIMSPROUT_NYLIUM.get()).add((Object)RuBlocks.COBALT_NYLIUM.get()).add((Object)RuBlocks.BRIMSPROUT.get()).add((Object)RuBlocks.COBALT_ROOTS.get()).add((Object)RuBlocks.GLISTERING_SPROUT.get()).add((Object)RuBlocks.GLISTERING_FERN.get()).add((Object)RuBlocks.GLISTERING_BLOOM.get()).add((Object)RuBlocks.MYCOTOXIC_GRASS.get()).add((Object)RuBlocks.GLISTERING_NYLIUM.get()).add((Object)RuBlocks.OVERGROWN_BONE_BLOCK.get()).add((Object)RuBlocks.MYCOTOXIC_NYLIUM.get());
        this.tag(BlockTags.FALL_DAMAGE_RESETTING).add((Object)RuBlocks.SALMONBERRY_BUSH.get());
        IntrinsicHolderTagsProvider.IntrinsicTagAppender intrinsicTagAppender = this.tag(BlockTags.FLOWER_POTS).add((Object)RuBlocks.POTTED_ALPHA_DANDELION.get()).add((Object)RuBlocks.POTTED_ALPHA_ROSE.get()).add((Object)RuBlocks.POTTED_ASTER.get()).add((Object)RuBlocks.POTTED_BLEEDING_HEART.get()).add((Object)RuBlocks.POTTED_DAISY.get()).add((Object)RuBlocks.POTTED_FELICIA_DAISY.get()).add((Object)RuBlocks.POTTED_DORCEL.get()).add((Object)RuBlocks.POTTED_FIREWEED.get()).add((Object)RuBlocks.POTTED_GLISTERING_BLOOM.get()).add((Object)RuBlocks.POTTED_HIBISCUS.get()).add((Object)RuBlocks.POTTED_HYSSOP.get()).add((Object)RuBlocks.POTTED_MALLOW.get()).add((Object)RuBlocks.POTTED_POPPY_BUSH.get()).add((Object)RuBlocks.POTTED_SALMON_POPPY_BUSH.get()).add((Object)RuBlocks.POTTED_TSUBAKI.get()).add((Object)RuBlocks.POTTED_WARATAH.get()).add((Object)RuBlocks.POTTED_WHITE_TRILLIUM.get()).add((Object)RuBlocks.POTTED_WILTING_TRILLIUM.get()).add((Object)RuBlocks.POTTED_BLUE_LUPINE.get()).add((Object)RuBlocks.POTTED_PINK_LUPINE.get()).add((Object)RuBlocks.POTTED_PURPLE_LUPINE.get()).add((Object)RuBlocks.POTTED_RED_LUPINE.get()).add((Object)RuBlocks.POTTED_YELLOW_LUPINE.get()).add((Object)RuBlocks.POTTED_ORANGE_CONEFLOWER.get()).add((Object)RuBlocks.POTTED_PURPLE_CONEFLOWER.get()).add((Object)RuBlocks.POTTED_DAY_LILY.get()).add((Object)RuBlocks.POTTED_MEADOW_SAGE.get()).add((Object)RuBlocks.POTTED_CAVE_HYSSOP.get()).add((Object)RuBlocks.POTTED_BARREL_CACTUS.get()).add((Object)RuBlocks.POTTED_DUSKTRAP.get()).add((Object)RuBlocks.POTTED_CORPSE_FLOWER.get()).add((Object)RuBlocks.POTTED_COBALT_EARLIGHT.get()).add((Object)RuBlocks.POTTED_TALL_COBALT_EARLIGHT.get()).add((Object)RuBlocks.POTTED_MYCOTOXIC_DAISY.get()).add((Object)RuBlocks.POTTED_GLISTER_SPIRE.get()).add((Object)RuBlocks.POTTED_BLUE_BIOSHROOM.get()).add((Object)RuBlocks.POTTED_GREEN_BIOSHROOM.get()).add((Object)RuBlocks.POTTED_PINK_BIOSHROOM.get()).add((Object)RuBlocks.POTTED_YELLOW_BIOSHROOM.get()).add((Object)RuBlocks.POTTED_TALL_BLUE_BIOSHROOM.get()).add((Object)RuBlocks.POTTED_TALL_GREEN_BIOSHROOM.get()).add((Object)RuBlocks.POTTED_TALL_PINK_BIOSHROOM.get()).add((Object)RuBlocks.POTTED_TALL_YELLOW_BIOSHROOM.get());
        IntrinsicHolderTagsProvider.IntrinsicTagAppender leaves = this.tag(BlockTags.LEAVES);
        for (Block block : RuBlocks.POTTED_SNOWBELLES.getAll()) {
            intrinsicTagAppender.add((Object)block);
        }
        for (NaturalSet set : RuBlocks.NATURAL_SETS) {
            if (set.getPottedSapling() != null) {
                intrinsicTagAppender.add((Object)set.getPottedSapling());
            }
            if (set.getLeaves() == null) continue;
            leaves.add((Object)set.getLeaves());
        }
        this.tag(BlockTags.FLOWERS).add((Object)RuBlocks.HYACINTH_FLOWERS.get()).add((Object)RuBlocks.ORANGE_CONEFLOWER.get()).add((Object)RuBlocks.PURPLE_CONEFLOWER.get()).add((Object)RuBlocks.BLUE_MAGNOLIA_FLOWERS.get()).add((Object)RuBlocks.PINK_MAGNOLIA_FLOWERS.get()).add((Object)RuBlocks.WHITE_MAGNOLIA_FLOWERS.get()).add((Object)RuBlocks.FLOWERING_NATURAL_SET.getLeaves());
        this.tag(BlockTags.FOXES_SPAWNABLE_ON).add((Object)RuBlocks.PEAT_COARSE_DIRT.get()).add((Object)RuBlocks.PEAT_PODZOL.get()).add((Object)RuBlocks.PEAT_GRASS_BLOCK.get()).add((Object)RuBlocks.PEAT_MUD.get()).add((Object)RuBlocks.SILT_COARSE_DIRT.get()).add((Object)RuBlocks.SILT_PODZOL.get()).add((Object)RuBlocks.SILT_GRASS_BLOCK.get()).add((Object)RuBlocks.SILT_MUD.get());
        this.tag(BlockTags.FROG_PREFER_JUMP_TO).add((Object)RuBlocks.FLOWERING_LILY_PAD.get()).add((Object)RuBlocks.GIANT_LILY_PAD.get());
        this.tag(BlockTags.FROGS_SPAWNABLE_ON).add((Object)RuBlocks.PEAT_COARSE_DIRT.get()).add((Object)RuBlocks.PEAT_GRASS_BLOCK.get()).add((Object)RuBlocks.PEAT_MUD.get()).add((Object)RuBlocks.SILT_COARSE_DIRT.get()).add((Object)RuBlocks.SILT_GRASS_BLOCK.get()).add((Object)RuBlocks.SILT_MUD.get());
        this.tag(BlockTags.GOATS_SPAWNABLE_ON).add((Object)RuBlocks.CHALK.get());
        this.tag(BlockTags.HOGLIN_REPELLENTS).add((Object)RuBlocks.COBALT_EARLIGHT.get()).add((Object)RuBlocks.TALL_COBALT_EARLIGHT.get());
        this.tag(BlockTags.IMPERMEABLE).add((Object)RuBlocks.PRISMAGLASS.get());
        this.tag(BlockTags.INFINIBURN_END).add((Object)RuBlocks.OVERGROWN_BONE_BLOCK.get()).add((Object)RuBlocks.VOLCANIC_ASH.get()).add((Object)RuBlocks.ASHEN_DIRT.get());
        this.tag(BlockTags.INFINIBURN_NETHER).add((Object)RuBlocks.OVERGROWN_BONE_BLOCK.get()).add((Object)RuBlocks.VOLCANIC_ASH.get()).add((Object)RuBlocks.ASHEN_DIRT.get());
        this.tag(BlockTags.INFINIBURN_OVERWORLD).add((Object)RuBlocks.OVERGROWN_BONE_BLOCK.get()).add((Object)RuBlocks.VOLCANIC_ASH.get()).add((Object)RuBlocks.ASHEN_DIRT.get());
        this.tag(BlockTags.INSIDE_STEP_SOUND_BLOCKS).add((Object)RuBlocks.DUCKWEED.get()).add((Object)RuBlocks.MYCOTOXIC_GRASS.get()).add((Object)RuBlocks.GLISTERING_SPROUT.get()).add((Object)RuBlocks.GLISTERING_FERN.get()).add((Object)RuBlocks.GLISTERING_BLOOM.get()).add((Object)RuBlocks.BRIMSPROUT.get()).add((Object)RuBlocks.COBALT_ROOTS.get()).add((Object)RuBlocks.JOSHUA_NATURAL_SET.getLeaves()).add((Object)RuBlocks.PRISMARITE_CLUSTER.get()).add((Object)RuBlocks.LARGE_PRISMARITE_CLUSTER.get()).add((Object)RuBlocks.FLOWERING_LILY_PAD.get()).add((Object)RuBlocks.GIANT_LILY_PAD.get()).add((Object)RuBlocks.MYCOTOXIC_MUSHROOMS.get()).add((Object)RuBlocks.ENCHANTED_BIRCH_LEAF_PILE.get()).add((Object)RuBlocks.SILVER_BIRCH_LEAF_PILE.get()).add((Object)RuBlocks.MAPLE_LEAF_PILE.get()).add((Object)RuBlocks.RED_MAPLE_LEAF_PILE.get()).add((Object)RuBlocks.ORANGE_MAPLE_LEAF_PILE.get());
        this.tag(BlockTags.LOGS).addTags(new TagKey[]{RuTags.BRIMWOOD_LOGS}).addTags(new TagKey[]{RuTags.COBALT_LOGS}).addTags(new TagKey[]{RuTags.DEAD_LOGS}).addTags(new TagKey[]{RuTags.YELLOW_BIOSHROOM_LOGS});
        this.tag(BlockTags.LOGS_THAT_BURN).addTags(new TagKey[]{RuTags.BRANCHES}).addTags(new TagKey[]{RuTags.BAMBOO_LOGS}).addTags(new TagKey[]{RuTags.BAOBAB_LOGS}).addTags(new TagKey[]{RuTags.BLACKWOOD_LOGS}).addTags(new TagKey[]{RuTags.BLUE_BIOSHROOM_LOGS}).addTags(new TagKey[]{RuTags.CYPRESS_LOGS}).addTags(new TagKey[]{RuTags.EUCALYPTUS_LOGS}).addTags(new TagKey[]{RuTags.GREEN_BIOSHROOM_LOGS}).addTags(new TagKey[]{RuTags.JOSHUA_LOGS}).addTags(new TagKey[]{RuTags.KAPOK_LOGS}).addTags(new TagKey[]{RuTags.LARCH_LOGS}).addTags(new TagKey[]{RuTags.MAGNOLIA_LOGS}).addTags(new TagKey[]{RuTags.MAPLE_LOGS}).addTags(new TagKey[]{RuTags.MAUVE_LOGS}).addTags(new TagKey[]{RuTags.PALM_LOGS}).addTags(new TagKey[]{RuTags.PINE_LOGS}).addTags(new TagKey[]{RuTags.PINK_BIOSHROOM_LOGS}).addTags(new TagKey[]{RuTags.REDWOOD_LOGS}).addTags(new TagKey[]{RuTags.SOCOTRA_LOGS}).addTags(new TagKey[]{RuTags.WILLOW_LOGS}).add((Object)RuBlocks.ALPHA_WOOD_SET.getLog());
        this.tag(BlockTags.MANGROVE_LOGS_CAN_GROW_THROUGH).add((Object)RuBlocks.PEAT_MUD.get()).add((Object)RuBlocks.SILT_MUD.get()).add((Object)RuBlocks.SPANISH_MOSS.get()).add((Object)RuBlocks.SPANISH_MOSS_PLANT.get()).add((Object)RuBlocks.KAPOK_VINES.get()).add((Object)RuBlocks.KAPOK_VINES_PLANT.get());
        this.tag(BlockTags.MANGROVE_ROOTS_CAN_GROW_THROUGH).add((Object)RuBlocks.PEAT_MUD.get()).add((Object)RuBlocks.SILT_MUD.get()).add((Object)RuBlocks.SPANISH_MOSS.get()).add((Object)RuBlocks.SPANISH_MOSS_PLANT.get()).add((Object)RuBlocks.KAPOK_VINES.get()).add((Object)RuBlocks.KAPOK_VINES_PLANT.get());
        this.tag(BlockTags.MOOSHROOMS_SPAWNABLE_ON).add((Object)RuBlocks.VIRIDESCENT_NYLIUM.get()).add((Object)RuBlocks.DEEPSLATE_VIRIDESCENT_NYLIUM.get());
        this.tag(BlockTags.MUSHROOM_GROW_BLOCK).add((Object)RuBlocks.BRIMSPROUT_NYLIUM.get()).add((Object)RuBlocks.PEAT_PODZOL.get()).add((Object)RuBlocks.SILT_PODZOL.get()).add((Object)RuBlocks.COBALT_NYLIUM.get()).add((Object)RuBlocks.GLISTERING_NYLIUM.get()).add((Object)RuBlocks.OVERGROWN_BONE_BLOCK.get()).add((Object)RuBlocks.MYCOTOXIC_NYLIUM.get());
        this.tag(BlockTags.NEEDS_DIAMOND_TOOL).add((Object)RuBlocks.COBALT_OBSIDIAN.get());
        this.tag(BlockTags.NYLIUM).add((Object)RuBlocks.BRIMSPROUT_NYLIUM.get()).add((Object)RuBlocks.COBALT_NYLIUM.get()).add((Object)RuBlocks.GLISTERING_NYLIUM.get()).add((Object)RuBlocks.OVERGROWN_BONE_BLOCK.get()).add((Object)RuBlocks.MYCOTOXIC_NYLIUM.get());
        this.tag(BlockTags.OAK_LOGS).add((Object)RuBlocks.SMALL_OAK_LOG.get()).add((Object)RuBlocks.STRIPPED_SMALL_OAK_LOG.get());
        this.tag(BlockTags.OVERWORLD_CARVER_REPLACEABLES).addTags(new TagKey[]{RuTags.ASH}).add((Object)RuBlocks.MOSSY_STONE.get()).add((Object)RuBlocks.ARGILLITE.get());
        this.tag(BlockTags.OVERWORLD_NATURAL_LOGS).add((Object)RuBlocks.ASHEN_WOOD_SET.getLog()).add((Object)RuBlocks.ALPHA_WOOD_SET.getLog()).add((Object)RuBlocks.SMALL_OAK_LOG.get()).add((Object)RuBlocks.BAMBOO_LOG.get()).add((Object)RuBlocks.BAOBAB_WOOD_SET.getLog()).add((Object)RuBlocks.BLACKWOOD_WOOD_SET.getLog()).add((Object)RuBlocks.CYPRESS_WOOD_SET.getLog()).add((Object)RuBlocks.DEAD_WOOD_SET.getLog()).add((Object)RuBlocks.EUCALYPTUS_WOOD_SET.getLog()).add((Object)RuBlocks.JOSHUA_WOOD_SET.getLog()).add((Object)RuBlocks.KAPOK_WOOD_SET.getLog()).add((Object)RuBlocks.LARCH_WOOD_SET.getLog()).add((Object)RuBlocks.MAPLE_WOOD_SET.getLog()).add((Object)RuBlocks.MAUVE_WOOD_SET.getLog()).add((Object)RuBlocks.PALM_WOOD_SET.getLog()).add((Object)RuBlocks.PINE_WOOD_SET.getLog()).add((Object)RuBlocks.REDWOOD_WOOD_SET.getLog()).add((Object)RuBlocks.MAGNOLIA_WOOD_SET.getLog()).add((Object)RuBlocks.SILVER_BIRCH_WOOD_SET.getLog()).add((Object)RuBlocks.SOCOTRA_WOOD_SET.getLog()).add((Object)RuBlocks.WILLOW_WOOD_SET.getLog());
        this.tag(BlockTags.PARROTS_SPAWNABLE_ON).add((Object)RuBlocks.PEAT_GRASS_BLOCK.get()).add((Object)RuBlocks.SILT_GRASS_BLOCK.get());
        this.tag(BlockTags.RABBITS_SPAWNABLE_ON).add((Object)RuBlocks.ALPHA_GRASS_BLOCK.get()).add((Object)RuBlocks.PEAT_COARSE_DIRT.get()).add((Object)RuBlocks.PEAT_PODZOL.get()).add((Object)RuBlocks.PEAT_DIRT.get()).add((Object)RuBlocks.PEAT_GRASS_BLOCK.get()).add((Object)RuBlocks.PEAT_MUD.get()).add((Object)RuBlocks.SILT_COARSE_DIRT.get()).add((Object)RuBlocks.SILT_PODZOL.get()).add((Object)RuBlocks.SILT_DIRT.get()).add((Object)RuBlocks.SILT_GRASS_BLOCK.get()).add((Object)RuBlocks.SILT_MUD.get()).add(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"podzol"))).add(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"coarse_dirt")));
        this.tag(BlockTags.REPLACEABLE).add((Object)RuBlocks.DEAD_STEPPE_SHRUB.get()).add((Object)RuBlocks.FROZEN_GRASS.get()).add((Object)RuBlocks.MEDIUM_GRASS.get()).add((Object)RuBlocks.BLADED_GRASS.get()).add((Object)RuBlocks.SANDY_GRASS.get()).add((Object)RuBlocks.SANDY_TALL_GRASS.get()).add((Object)RuBlocks.SMALL_DESERT_SHRUB.get()).add((Object)RuBlocks.STEPPE_GRASS.get()).add((Object)RuBlocks.STEPPE_SHRUB.get()).add((Object)RuBlocks.STEPPE_TALL_GRASS.get()).add((Object)RuBlocks.BLADED_TALL_GRASS.get()).add((Object)RuBlocks.CLOVER.get()).add((Object)RuBlocks.MAPLE_LEAF_PILE.get()).add((Object)RuBlocks.ORANGE_MAPLE_LEAF_PILE.get()).add((Object)RuBlocks.RED_MAPLE_LEAF_PILE.get()).add((Object)RuBlocks.SILVER_BIRCH_LEAF_PILE.get()).add((Object)RuBlocks.ENCHANTED_BIRCH_LEAF_PILE.get()).add((Object)RuBlocks.STONE_BUD.get()).add((Object)RuBlocks.WINDSWEPT_GRASS.get()).add((Object)RuBlocks.PRISMOSS_SPROUT.get()).add((Object)RuBlocks.REDSTONE_BUD.get()).add((Object)RuBlocks.ELEPHANT_EAR.get());
        this.tag(BlockTags.REPLACEABLE_BY_TREES).add((Object)RuBlocks.MEADOW_SAGE.get()).add((Object)RuBlocks.BARLEY.get()).add((Object)RuBlocks.CATTAIL.get()).add((Object)RuBlocks.DEAD_STEPPE_SHRUB.get()).add((Object)RuBlocks.CLOVER.get()).add((Object)RuBlocks.MAPLE_LEAF_PILE.get()).add((Object)RuBlocks.ORANGE_MAPLE_LEAF_PILE.get()).add((Object)RuBlocks.RED_MAPLE_LEAF_PILE.get()).add((Object)RuBlocks.SILVER_BIRCH_LEAF_PILE.get()).add((Object)RuBlocks.ENCHANTED_BIRCH_LEAF_PILE.get()).add((Object)RuBlocks.ELEPHANT_EAR.get()).add((Object)RuBlocks.CORPSE_FLOWER.get()).add((Object)RuBlocks.FROZEN_GRASS.get()).add((Object)RuBlocks.MEDIUM_GRASS.get()).add((Object)RuBlocks.BLADED_GRASS.get()).add((Object)RuBlocks.SANDY_GRASS.get()).add((Object)RuBlocks.SANDY_TALL_GRASS.get()).add((Object)RuBlocks.SMALL_DESERT_SHRUB.get()).add((Object)RuBlocks.STEPPE_GRASS.get()).add((Object)RuBlocks.STEPPE_SHRUB.get()).add((Object)RuBlocks.STEPPE_TALL_GRASS.get()).add((Object)RuBlocks.BLADED_TALL_GRASS.get()).add((Object)RuBlocks.KAPOK_VINES.get()).add((Object)RuBlocks.KAPOK_VINES_PLANT.get()).add((Object)RuBlocks.SPANISH_MOSS.get()).add((Object)RuBlocks.SPANISH_MOSS_PLANT.get()).add((Object)RuBlocks.STONE_BUD.get()).add((Object)RuBlocks.TASSEL.get()).add((Object)RuBlocks.DAY_LILY.get()).add((Object)RuBlocks.WINDSWEPT_GRASS.get()).add((Object)RuBlocks.PINK_BIOSHROOM.get()).add((Object)RuBlocks.BLUE_BIOSHROOM.get()).add((Object)RuBlocks.GREEN_BIOSHROOM.get()).add((Object)RuBlocks.YELLOW_BIOSHROOM.get()).add((Object)RuBlocks.PRISMOSS_SPROUT.get()).add((Object)RuBlocks.REDSTONE_BUD.get());
        this.tag(BlockTags.SLABS).add((Object)RuBlocks.CHALK_SLAB.get()).add((Object)RuBlocks.CHALK_BRICK_SLAB.get()).add((Object)RuBlocks.POLISHED_CHALK_SLAB.get());
        this.tag(BlockTags.SMALL_DRIPLEAF_PLACEABLE).add((Object)RuBlocks.ASH.get()).add((Object)RuBlocks.VOLCANIC_ASH.get());
        IntrinsicHolderTagsProvider.IntrinsicTagAppender smallFlowers = this.tag(BlockTags.SMALL_FLOWERS).add((Object)RuBlocks.ALPHA_DANDELION.get()).add((Object)RuBlocks.ALPHA_ROSE.get()).add((Object)RuBlocks.ASTER.get()).add((Object)RuBlocks.BLEEDING_HEART.get()).add((Object)RuBlocks.BLUE_LUPINE.get()).add((Object)RuBlocks.DAISY.get()).add((Object)RuBlocks.DORCEL.get()).add((Object)RuBlocks.FELICIA_DAISY.get()).add((Object)RuBlocks.FIREWEED.get()).add((Object)RuBlocks.GLISTERING_BLOOM.get()).add((Object)RuBlocks.HIBISCUS.get()).add((Object)RuBlocks.MALLOW.get()).add((Object)RuBlocks.HYSSOP.get()).add((Object)RuBlocks.PINK_LUPINE.get()).add((Object)RuBlocks.POPPY_BUSH.get()).add((Object)RuBlocks.SALMON_POPPY_BUSH.get()).add((Object)RuBlocks.PURPLE_LUPINE.get()).add((Object)RuBlocks.RED_LUPINE.get()).add((Object)RuBlocks.WARATAH.get()).add((Object)RuBlocks.TSUBAKI.get()).add((Object)RuBlocks.WHITE_TRILLIUM.get()).add((Object)RuBlocks.WILTING_TRILLIUM.get()).add((Object)RuBlocks.YELLOW_LUPINE.get());
        for (Block block : RuBlocks.SNOWBELLES.getAll()) {
            smallFlowers.add((Object)block);
        }
        this.tag(BlockTags.SNAPS_GOAT_HORN).add((Object)RuBlocks.CHALK.get());
        this.tag(BlockTags.SNOW_LAYER_CAN_SURVIVE_ON).add((Object)RuBlocks.PEAT_MUD.get()).add((Object)RuBlocks.SILT_MUD.get());
        this.tag(BlockTags.STAIRS).add((Object)RuBlocks.CHALK_STAIRS.get()).add((Object)RuBlocks.CHALK_BRICK_STAIRS.get()).add((Object)RuBlocks.POLISHED_CHALK_STAIRS.get());
        this.tag(BlockTags.STRIDER_WARM_BLOCKS).add((Object)RuBlocks.BRIMWOOD_WOOD_SET.getPlanks()).addTags(new TagKey[]{RuTags.BRIMWOOD_LOGS});
        this.tag(BlockTags.TALL_FLOWERS).add((Object)RuBlocks.TASSEL.get()).add((Object)RuBlocks.DAY_LILY.get()).add((Object)RuBlocks.MEADOW_SAGE.get());
        this.tag(BlockTags.VALID_SPAWN).add((Object)RuBlocks.PEAT_GRASS_BLOCK.get()).add((Object)RuBlocks.PEAT_PODZOL.get()).add((Object)RuBlocks.SILT_GRASS_BLOCK.get()).add((Object)RuBlocks.SILT_PODZOL.get());
        this.tag(BlockTags.WALL_POST_OVERRIDE).add((Object)RuBlocks.GREEN_BIOSHROOM_BLOCK.get());
        this.tag(BlockTags.WART_BLOCKS).add((Object)RuBlocks.GREEN_BIOSHROOM_BLOCK.get()).add((Object)RuBlocks.BLUE_BIOSHROOM_BLOCK.get()).add((Object)RuBlocks.PINK_BIOSHROOM_BLOCK.get()).add((Object)RuBlocks.YELLOW_BIOSHROOM_BLOCK.get()).add((Object)RuBlocks.GLOWING_GREEN_BIOSHROOM_BLOCK.get()).add((Object)RuBlocks.GLOWING_BLUE_BIOSHROOM_BLOCK.get()).add((Object)RuBlocks.GLOWING_PINK_BIOSHROOM_BLOCK.get()).add((Object)RuBlocks.GLOWING_YELLOW_BIOSHROOM_BLOCK.get());
        this.tag(BlockTags.WOLVES_SPAWNABLE_ON).add((Object)RuBlocks.PEAT_GRASS_BLOCK.get()).add((Object)RuBlocks.SILT_GRASS_BLOCK.get()).add((Object)RuBlocks.PEAT_COARSE_DIRT.get()).add((Object)RuBlocks.SILT_COARSE_DIRT.get()).add((Object)RuBlocks.PEAT_PODZOL.get()).add((Object)RuBlocks.SILT_PODZOL.get());
        this.tag(RuTags.CROP_PLANTABLE_BLOCKS).add((Object)RuBlocks.PEAT_FARMLAND.get()).add((Object)RuBlocks.SILT_FARMLAND.get());
        this.tag(RuTags.HYACINTH_BLOOMS).add((Object)RuBlocks.HYACINTH_BLOOM.get()).add((Object)RuBlocks.TALL_HYACINTH_STOCK.get());
        this.tag(RuTags.GREEN_BIOSHROOM_LOGS).add((Object)RuBlocks.GREEN_BIOSHROOM_WOOD_SET.getLog()).add((Object)RuBlocks.GREEN_BIOSHROOM_WOOD_SET.getStrippedLog()).add((Object)RuBlocks.GREEN_BIOSHROOM_WOOD_SET.getWood()).add((Object)RuBlocks.GREEN_BIOSHROOM_WOOD_SET.getStrippedWood());
        this.tag(RuTags.ASH).add((Object)RuBlocks.ASH.get()).add((Object)RuBlocks.VOLCANIC_ASH.get());
        this.tag(RuTags.BRANCHES).add((Object)RuBlocks.ACACIA_NATURAL_SET.getBranch()).add((Object)RuBlocks.BAOBAB_NATURAL_SET.getBranch()).add((Object)RuBlocks.BIRCH_NATURAL_SET.getBranch()).add((Object)RuBlocks.BLACKWOOD_NATURAL_SET.getBranch()).add((Object)RuBlocks.CYPRESS_NATURAL_SET.getBranch()).add((Object)RuBlocks.CHERRY_NATURAL_SET.getBranch()).add((Object)RuBlocks.DARK_OAK_NATURAL_SET.getBranch()).add((Object)RuBlocks.DEAD_NATURAL_SET.getBranch()).add((Object)RuBlocks.EUCALYPTUS_NATURAL_SET.getBranch()).add((Object)RuBlocks.JOSHUA_NATURAL_SET.getBranch()).add((Object)RuBlocks.JUNGLE_NATURAL_SET.getBranch()).add((Object)RuBlocks.KAPOK_NATURAL_SET.getBranch()).add((Object)RuBlocks.LARCH_NATURAL_SET.getBranch()).add((Object)RuBlocks.MANGROVE_NATURAL_SET.getBranch()).add((Object)RuBlocks.MAPLE_NATURAL_SET.getBranch()).add((Object)RuBlocks.MAUVE_NATURAL_SET.getBranch()).add((Object)RuBlocks.OAK_NATURAL_SET.getBranch()).add((Object)RuBlocks.PALM_NATURAL_SET.getBranch()).add((Object)RuBlocks.PINE_NATURAL_SET.getBranch()).add((Object)RuBlocks.REDWOOD_NATURAL_SET.getBranch()).add((Object)RuBlocks.MAGNOLIA_NATURAL_SET.getBranch()).add((Object)RuBlocks.SILVER_BIRCH_NATURAL_SET.getBranch()).add((Object)RuBlocks.SOCOTRA_NATURAL_SET.getBranch()).add((Object)RuBlocks.SPRUCE_NATURAL_SET.getBranch()).add((Object)RuBlocks.WILLOW_NATURAL_SET.getBranch());
        this.tag(RuTags.SHRUBS).add((Object)RuBlocks.ACACIA_NATURAL_SET.getShrub()).add((Object)RuBlocks.BAOBAB_NATURAL_SET.getShrub()).add((Object)RuBlocks.BIRCH_NATURAL_SET.getShrub()).add((Object)RuBlocks.BLACKWOOD_NATURAL_SET.getShrub()).add((Object)RuBlocks.BRIMWOOD_NATURAL_SET.getShrub()).add((Object)RuBlocks.CHERRY_NATURAL_SET.getShrub()).add((Object)RuBlocks.MAGNOLIA_NATURAL_SET.getShrub()).add((Object)RuBlocks.BLUE_MAGNOLIA_NATURAL_SET.getShrub()).add((Object)RuBlocks.PINK_MAGNOLIA_NATURAL_SET.getShrub()).add((Object)RuBlocks.WHITE_MAGNOLIA_NATURAL_SET.getShrub()).add((Object)RuBlocks.CYPRESS_NATURAL_SET.getShrub()).add((Object)RuBlocks.DARK_OAK_NATURAL_SET.getShrub()).add((Object)RuBlocks.DEAD_NATURAL_SET.getShrub()).add((Object)RuBlocks.DEAD_PINE_NATURAL_SET.getShrub()).add((Object)RuBlocks.EUCALYPTUS_NATURAL_SET.getShrub()).add((Object)RuBlocks.FLOWERING_NATURAL_SET.getShrub()).add((Object)RuBlocks.JOSHUA_NATURAL_SET.getShrub()).add((Object)RuBlocks.KAPOK_NATURAL_SET.getShrub()).add((Object)RuBlocks.JUNGLE_NATURAL_SET.getShrub()).add((Object)RuBlocks.GOLDEN_LARCH_NATURAL_SET.getShrub()).add((Object)RuBlocks.LARCH_NATURAL_SET.getShrub()).add((Object)RuBlocks.MANGROVE_NATURAL_SET.getShrub()).add((Object)RuBlocks.MAPLE_NATURAL_SET.getShrub()).add((Object)RuBlocks.RED_MAPLE_NATURAL_SET.getShrub()).add((Object)RuBlocks.ORANGE_MAPLE_NATURAL_SET.getShrub()).add((Object)RuBlocks.MAUVE_NATURAL_SET.getShrub()).add((Object)RuBlocks.OAK_NATURAL_SET.getShrub()).add((Object)RuBlocks.PALM_NATURAL_SET.getShrub()).add((Object)RuBlocks.PINE_NATURAL_SET.getShrub()).add((Object)RuBlocks.REDWOOD_NATURAL_SET.getShrub()).add((Object)RuBlocks.ENCHANTED_BIRCH_NATURAL_SET.getShrub()).add((Object)RuBlocks.SILVER_BIRCH_NATURAL_SET.getShrub()).add((Object)RuBlocks.SOCOTRA_NATURAL_SET.getShrub()).add((Object)RuBlocks.SPRUCE_NATURAL_SET.getShrub()).add((Object)RuBlocks.WILLOW_NATURAL_SET.getShrub());
        this.tag(RuTags.BAMBOO_LOGS).add((Object)RuBlocks.BAMBOO_LOG.get()).add((Object)RuBlocks.STRIPPED_BAMBOO_LOG.get());
        this.tag(RuTags.BAOBAB_LOGS).add((Object)RuBlocks.BAOBAB_WOOD_SET.getLog()).add((Object)RuBlocks.BAOBAB_WOOD_SET.getStrippedLog()).add((Object)RuBlocks.BAOBAB_WOOD_SET.getWood()).add((Object)RuBlocks.BAOBAB_WOOD_SET.getStrippedWood());
        this.tag(RuTags.BLACKWOOD_LOGS).add((Object)RuBlocks.BLACKWOOD_WOOD_SET.getLog()).add((Object)RuBlocks.BLACKWOOD_WOOD_SET.getStrippedLog()).add((Object)RuBlocks.BLACKWOOD_WOOD_SET.getWood()).add((Object)RuBlocks.BLACKWOOD_WOOD_SET.getStrippedWood());
        this.tag(RuTags.BLUE_BIOSHROOM_LOGS).add((Object)RuBlocks.BLUE_BIOSHROOM_WOOD_SET.getLog()).add((Object)RuBlocks.BLUE_BIOSHROOM_WOOD_SET.getStrippedLog()).add((Object)RuBlocks.BLUE_BIOSHROOM_WOOD_SET.getWood()).add((Object)RuBlocks.BLUE_BIOSHROOM_WOOD_SET.getStrippedWood());
        this.tag(RuTags.BRIMWOOD_LOGS).add((Object)RuBlocks.BRIMWOOD_WOOD_SET.getLog()).add((Object)RuBlocks.BRIMWOOD_WOOD_SET.getLogMagma()).add((Object)RuBlocks.BRIMWOOD_WOOD_SET.getWood()).add((Object)RuBlocks.BRIMWOOD_WOOD_SET.getStrippedLog()).add((Object)RuBlocks.BRIMWOOD_WOOD_SET.getStrippedWood());
        this.tag(RuTags.COBALT_LOGS).add((Object)RuBlocks.COBALT_WOOD_SET.getLog()).add((Object)RuBlocks.COBALT_WOOD_SET.getStrippedLog()).add((Object)RuBlocks.COBALT_WOOD_SET.getWood()).add((Object)RuBlocks.COBALT_WOOD_SET.getStrippedWood());
        this.tag(RuTags.CYPRESS_LOGS).add((Object)RuBlocks.CYPRESS_WOOD_SET.getLog()).add((Object)RuBlocks.CYPRESS_WOOD_SET.getStrippedLog()).add((Object)RuBlocks.CYPRESS_WOOD_SET.getWood()).add((Object)RuBlocks.CYPRESS_WOOD_SET.getStrippedWood());
        this.tag(RuTags.DEAD_LOGS).add((Object)RuBlocks.ASHEN_WOOD_SET.getLog()).add((Object)RuBlocks.DEAD_WOOD_SET.getLog()).add((Object)RuBlocks.DEAD_WOOD_SET.getStrippedLog()).add((Object)RuBlocks.ASHEN_WOOD_SET.getWood()).add((Object)RuBlocks.DEAD_WOOD_SET.getWood()).add((Object)RuBlocks.DEAD_WOOD_SET.getStrippedWood());
        this.tag(RuTags.EUCALYPTUS_LOGS).add((Object)RuBlocks.EUCALYPTUS_WOOD_SET.getLog()).add((Object)RuBlocks.EUCALYPTUS_WOOD_SET.getStrippedLog()).add((Object)RuBlocks.EUCALYPTUS_WOOD_SET.getWood()).add((Object)RuBlocks.EUCALYPTUS_WOOD_SET.getStrippedWood());
        this.tag(RuTags.GREEN_BIOSHROOM_LOGS).add((Object)RuBlocks.GREEN_BIOSHROOM_WOOD_SET.getLog()).add((Object)RuBlocks.GREEN_BIOSHROOM_WOOD_SET.getStrippedLog()).add((Object)RuBlocks.GREEN_BIOSHROOM_WOOD_SET.getWood()).add((Object)RuBlocks.GREEN_BIOSHROOM_WOOD_SET.getStrippedWood());
        this.tag(RuTags.JOSHUA_LOGS).add((Object)RuBlocks.JOSHUA_WOOD_SET.getLog()).add((Object)RuBlocks.JOSHUA_WOOD_SET.getStrippedLog()).add((Object)RuBlocks.JOSHUA_WOOD_SET.getWood()).add((Object)RuBlocks.JOSHUA_WOOD_SET.getStrippedWood());
        this.tag(RuTags.KAPOK_LOGS).add((Object)RuBlocks.KAPOK_WOOD_SET.getLog()).add((Object)RuBlocks.KAPOK_WOOD_SET.getStrippedLog()).add((Object)RuBlocks.KAPOK_WOOD_SET.getWood()).add((Object)RuBlocks.KAPOK_WOOD_SET.getStrippedWood());
        this.tag(RuTags.LARCH_LOGS).add((Object)RuBlocks.LARCH_WOOD_SET.getLog()).add((Object)RuBlocks.LARCH_WOOD_SET.getStrippedLog()).add((Object)RuBlocks.LARCH_WOOD_SET.getWood()).add((Object)RuBlocks.LARCH_WOOD_SET.getStrippedWood());
        this.tag(RuTags.MAGNOLIA_LOGS).add((Object)RuBlocks.MAGNOLIA_WOOD_SET.getLog()).add((Object)RuBlocks.MAGNOLIA_WOOD_SET.getStrippedLog()).add((Object)RuBlocks.MAGNOLIA_WOOD_SET.getWood()).add((Object)RuBlocks.MAGNOLIA_WOOD_SET.getStrippedWood());
        this.tag(RuTags.MAPLE_LOGS).add((Object)RuBlocks.MAPLE_WOOD_SET.getLog()).add((Object)RuBlocks.MAPLE_WOOD_SET.getStrippedLog()).add((Object)RuBlocks.MAPLE_WOOD_SET.getWood()).add((Object)RuBlocks.MAPLE_WOOD_SET.getStrippedWood());
        this.tag(RuTags.MAUVE_LOGS).add((Object)RuBlocks.MAUVE_WOOD_SET.getLog()).add((Object)RuBlocks.MAUVE_WOOD_SET.getStrippedLog()).add((Object)RuBlocks.MAUVE_WOOD_SET.getWood()).add((Object)RuBlocks.MAUVE_WOOD_SET.getStrippedWood());
        this.tag(RuTags.PALM_LOGS).add((Object)RuBlocks.PALM_WOOD_SET.getLog()).add((Object)RuBlocks.PALM_WOOD_SET.getStrippedLog()).add((Object)RuBlocks.PALM_WOOD_SET.getWood()).add((Object)RuBlocks.PALM_WOOD_SET.getStrippedWood());
        this.tag(RuTags.PINE_LOGS).add((Object)RuBlocks.PINE_WOOD_SET.getLog()).add((Object)RuBlocks.PINE_WOOD_SET.getStrippedLog()).add((Object)RuBlocks.PINE_WOOD_SET.getWood()).add((Object)RuBlocks.PINE_WOOD_SET.getStrippedWood());
        this.tag(RuTags.PINK_BIOSHROOM_LOGS).add((Object)RuBlocks.PINK_BIOSHROOM_WOOD_SET.getLog()).add((Object)RuBlocks.PINK_BIOSHROOM_WOOD_SET.getStrippedLog()).add((Object)RuBlocks.PINK_BIOSHROOM_WOOD_SET.getWood()).add((Object)RuBlocks.PINK_BIOSHROOM_WOOD_SET.getStrippedWood());
        this.tag(RuTags.REDWOOD_LOGS).add((Object)RuBlocks.REDWOOD_WOOD_SET.getLog()).add((Object)RuBlocks.REDWOOD_WOOD_SET.getStrippedLog()).add((Object)RuBlocks.REDWOOD_WOOD_SET.getWood()).add((Object)RuBlocks.REDWOOD_WOOD_SET.getStrippedWood());
        this.tag(RuTags.SOCOTRA_LOGS).add((Object)RuBlocks.SOCOTRA_WOOD_SET.getLog()).add((Object)RuBlocks.SOCOTRA_WOOD_SET.getStrippedLog()).add((Object)RuBlocks.SOCOTRA_WOOD_SET.getWood()).add((Object)RuBlocks.SOCOTRA_WOOD_SET.getStrippedWood());
        this.tag(RuTags.WILLOW_LOGS).add((Object)RuBlocks.WILLOW_WOOD_SET.getLog()).add((Object)RuBlocks.WILLOW_WOOD_SET.getStrippedLog()).add((Object)RuBlocks.WILLOW_WOOD_SET.getWood()).add((Object)RuBlocks.WILLOW_WOOD_SET.getStrippedWood());
        this.tag(RuTags.YELLOW_BIOSHROOM_LOGS).add((Object)RuBlocks.YELLOW_BIOSHROOM_WOOD_SET.getLog()).add((Object)RuBlocks.YELLOW_BIOSHROOM_WOOD_SET.getStrippedLog()).add((Object)RuBlocks.YELLOW_BIOSHROOM_WOOD_SET.getWood()).add((Object)RuBlocks.YELLOW_BIOSHROOM_WOOD_SET.getStrippedWood());
        this.tag(RuTags.BRANCHES_CAN_SURVIVE_ON).addTag(BlockTags.OVERWORLD_NATURAL_LOGS);
        this.tag(RuTags.BRIM_PLANT_CAN_SURVIVE_ON).addTag(BlockTags.DIRT).addTag(BlockTags.NYLIUM);
        this.tag(RuTags.CATTAIL_CAN_SURVIVE_ON).addTag(BlockTags.DIRT).addTag(BlockTags.SAND).add(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"clay"))).add(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"gravel")));
        this.tag(RuTags.SANDY_PLANT_CAN_SURVIVE_ON).addTag(BlockTags.SAND).addOptionalTag(TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"sandstone"))).addOptionalTag(TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"sand"))).addOptionalTag(TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"red_sand"))).addOptionalTag(TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"sand/red"))).addOptionalTag(TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"red_sandstone"))).addOptionalTag(TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"sandstone/red")));
        this.tag(RuTags.SHRUB_CAN_SURVIVE_ON).addTag(BlockTags.DIRT);
        this.tag(RuTags.SNOW_PLANT_CAN_SURVIVE_ON).addTag(BlockTags.SNOW);
        this.tag(RuTags.STONE_PLANT_CAN_SURVIVE_ON).addTag(BlockTags.TERRACOTTA).addTag(BlockTags.BASE_STONE_OVERWORLD).addTag(BlockTags.BASE_STONE_NETHER).addOptionalTag(TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"ores"))).add(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"calcite"))).add(RuBlocks.CHALK.get().builtInRegistryHolder().key()).add(RuBlocks.CHALK_GRASS_BLOCK.get().builtInRegistryHolder().key()).add(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"dripstone_block"))).addOptionalTag(TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"gravel"))).addOptionalTag(TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"stone"))).add(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"gilded_blackstone"))).add(RuBlocks.MOSSY_STONE.get().builtInRegistryHolder().key()).add(RuBlocks.ARGILLITE.get().builtInRegistryHolder().key()).add(RuBlocks.VIRIDESCENT_NYLIUM.get().builtInRegistryHolder().key()).add(RuBlocks.DEEPSLATE_VIRIDESCENT_NYLIUM.get().builtInRegistryHolder().key()).add(RuBlocks.DEEPSLATE_GRASS_BLOCK.get().builtInRegistryHolder().key()).add(RuBlocks.STONE_GRASS_BLOCK.get().builtInRegistryHolder().key()).add(RuBlocks.ARGILLITE_GRASS_BLOCK.get().builtInRegistryHolder().key());
        this.tag(RuTags.BIOSHROOM_GROW_BLOCK).addTag(BlockTags.DIRT).addTag(BlockTags.NYLIUM);
        this.tag(RuTags.PRISMARITE_CRYSTALS).add((Object)RuBlocks.PRISMARITE_CLUSTER.get()).add((Object)RuBlocks.LARGE_PRISMARITE_CLUSTER.get()).add((Object)RuBlocks.HANGING_PRISMARITE.get());
        this.tag(RuTags.GRASS).add((Object)RuBlocks.FROZEN_GRASS.get()).add((Object)RuBlocks.MEDIUM_GRASS.get()).add((Object)RuBlocks.BLADED_GRASS.get()).add((Object)RuBlocks.SANDY_GRASS.get()).add((Object)RuBlocks.STEPPE_GRASS.get()).add((Object)RuBlocks.STEPPE_SHRUB.get()).add((Object)RuBlocks.STONE_BUD.get()).add(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"short_grass"))).add(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"fern")));
        this.tag(RuTags.REPLACEABLE_BLOCKS).add(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"air"))).add(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"amethyst_cluster"))).add(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"azalea"))).add(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"big_dripleaf"))).add(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"big_dripleaf_stem"))).add(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"brown_mushroom"))).add(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"bubble_column"))).add(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"cave_air"))).add(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"cave_vines"))).add(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"cave_vines_plant"))).add(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"crimson_fungus"))).add(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"dead_bush"))).add(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"fern"))).add(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"flowering_azalea"))).add(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"glow_lichen"))).add(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"kelp"))).add(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"kelp_plant"))).add(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"large_amethyst_bud"))).add(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"lilac"))).add(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"lily_pad"))).add(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"mangrove_propagule"))).add(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"mangrove_roots"))).add(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"medium_amethyst_bud"))).add(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"nether_sprouts"))).add(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"red_mushroom"))).add(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"sculk_vein"))).add(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"sea_pickle"))).add(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"seagrass"))).add(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"small_amethyst_bud"))).add(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"small_dripleaf"))).add(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"sugar_cane"))).add(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"sunflower"))).add(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"sweet_berry_bush"))).add(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"tall_seagrass"))).add(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"vine"))).add(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"void_air"))).add(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"warped_fungus"))).add(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"warped_roots"))).add(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"water"))).add(RuBlocks.MEADOW_SAGE.get().builtInRegistryHolder().key()).add(RuBlocks.BARLEY.get().builtInRegistryHolder().key()).add(RuBlocks.BARREL_CACTUS.get().builtInRegistryHolder().key()).add(RuBlocks.BLUE_BIOSHROOM.get().builtInRegistryHolder().key()).add(RuBlocks.CATTAIL.get().builtInRegistryHolder().key()).add(RuBlocks.DUCKWEED.get().builtInRegistryHolder().key()).add(RuBlocks.ELEPHANT_EAR.get().builtInRegistryHolder().key()).add(RuBlocks.CORPSE_FLOWER.get().builtInRegistryHolder().key()).add(RuBlocks.GREEN_BIOSHROOM.get().builtInRegistryHolder().key()).add(RuBlocks.MYCOTOXIC_DAISY.get().builtInRegistryHolder().key()).add(RuBlocks.PINK_BIOSHROOM.get().builtInRegistryHolder().key()).add(RuBlocks.SMALL_DESERT_SHRUB.get().builtInRegistryHolder().key()).add(RuBlocks.SPANISH_MOSS.get().builtInRegistryHolder().key()).add(RuBlocks.SPANISH_MOSS_PLANT.get().builtInRegistryHolder().key()).add(RuBlocks.KAPOK_VINES.get().builtInRegistryHolder().key()).add(RuBlocks.KAPOK_VINES_PLANT.get().builtInRegistryHolder().key()).add(RuBlocks.STONE_BUD.get().builtInRegistryHolder().key()).add(RuBlocks.TALL_BLUE_BIOSHROOM.get().builtInRegistryHolder().key()).add(RuBlocks.TALL_GREEN_BIOSHROOM.get().builtInRegistryHolder().key()).add(RuBlocks.TALL_PINK_BIOSHROOM.get().builtInRegistryHolder().key()).add(RuBlocks.TALL_YELLOW_BIOSHROOM.get().builtInRegistryHolder().key()).add(RuBlocks.TASSEL.get().builtInRegistryHolder().key()).add(RuBlocks.DAY_LILY.get().builtInRegistryHolder().key()).add(RuBlocks.YELLOW_BIOSHROOM.get().builtInRegistryHolder().key()).add(RuBlocks.SALMONBERRY_BUSH.get().builtInRegistryHolder().key()).add(RuBlocks.DUSKMELON.get().builtInRegistryHolder().key()).add(RuBlocks.ORANGE_CONEFLOWER.get().builtInRegistryHolder().key()).add(RuBlocks.PURPLE_CONEFLOWER.get().builtInRegistryHolder().key()).add(RuBlocks.CLOVER.get().builtInRegistryHolder().key()).add(RuBlocks.MYCOTOXIC_MUSHROOMS.get().builtInRegistryHolder().key()).add(RuBlocks.FLOWERING_LILY_PAD.get().builtInRegistryHolder().key()).add(RuBlocks.GIANT_LILY_PAD.get().builtInRegistryHolder().key()).addTags(new TagKey[]{BlockTags.FLOWERS}).addTags(new TagKey[]{BlockTags.LEAVES}).addTags(new TagKey[]{BlockTags.REPLACEABLE_BY_TREES}).addTags(new TagKey[]{BlockTags.SAPLINGS}).add(RuBlocks.BRIMSPROUT.get().builtInRegistryHolder().key()).add(RuBlocks.COBALT_ROOTS.get().builtInRegistryHolder().key()).add(RuBlocks.GLISTERING_SPROUT.get().builtInRegistryHolder().key()).add(RuBlocks.GLISTERING_FERN.get().builtInRegistryHolder().key()).add(RuBlocks.GLISTERING_BLOOM.get().builtInRegistryHolder().key()).add(RuBlocks.GLISTER_BULB.get().builtInRegistryHolder().key()).add(RuBlocks.GLISTER_SPIRE.get().builtInRegistryHolder().key()).add(RuBlocks.MYCOTOXIC_GRASS.get().builtInRegistryHolder().key()).addTags(new TagKey[]{RuTags.BRANCHES}).addTags(new TagKey[]{RuTags.SHRUBS});
    }

    public void addCommonTags(HolderLookup.Provider provider) {
        this.tag(Tags.Blocks.STORAGE_BLOCKS_BONE_MEAL).add((Object)RuBlocks.OVERGROWN_BONE_BLOCK.get());
        IntrinsicHolderTagsProvider.IntrinsicTagAppender fenceGates = this.tag(Tags.Blocks.FENCE_GATES_WOODEN);
        IntrinsicHolderTagsProvider.IntrinsicTagAppender fences = this.tag(Tags.Blocks.FENCES_WOODEN);
        for (WoodSet set : RuBlocks.WOOD_SETS) {
            if (set.getFenceGate() != null) {
                fenceGates.add((Object)set.getFenceGate());
            }
            if (set.getFence() == null) continue;
            fences.add((Object)set.getFence());
        }
        this.tag(Tags.Blocks.GLASS_BLOCKS).add((Object)RuBlocks.PRISMAGLASS.get());
        this.tag(Tags.Blocks.STONES).add((Object)RuBlocks.MOSSY_STONE.get()).add((Object)RuBlocks.ARGILLITE.get()).add((Object)RuBlocks.CHALK.get());
        this.tag(Tags.Blocks.GRAVELS).add((Object)RuBlocks.ASH.get()).add((Object)RuBlocks.VOLCANIC_ASH.get());
        this.tag(Tags.Blocks.OBSIDIANS_CRYING).add((Object)RuBlocks.COBALT_OBSIDIAN.get());
        this.tag(Tags.Blocks.STRIPPED_LOGS).add((Object)RuBlocks.BAOBAB_WOOD_SET.getStrippedLog()).add((Object)RuBlocks.BLACKWOOD_WOOD_SET.getStrippedLog()).add((Object)RuBlocks.BLUE_BIOSHROOM_WOOD_SET.getStrippedLog()).add((Object)RuBlocks.BRIMWOOD_WOOD_SET.getStrippedLog()).add((Object)RuBlocks.COBALT_WOOD_SET.getStrippedLog()).add((Object)RuBlocks.CYPRESS_WOOD_SET.getStrippedLog()).add((Object)RuBlocks.DEAD_WOOD_SET.getStrippedLog()).add((Object)RuBlocks.EUCALYPTUS_WOOD_SET.getStrippedLog()).add((Object)RuBlocks.GREEN_BIOSHROOM_WOOD_SET.getStrippedLog()).add((Object)RuBlocks.JOSHUA_WOOD_SET.getStrippedLog()).add((Object)RuBlocks.KAPOK_WOOD_SET.getStrippedLog()).add((Object)RuBlocks.LARCH_WOOD_SET.getStrippedLog()).add((Object)RuBlocks.MAGNOLIA_WOOD_SET.getStrippedLog()).add((Object)RuBlocks.MAPLE_WOOD_SET.getStrippedLog()).add((Object)RuBlocks.MAUVE_WOOD_SET.getStrippedLog()).add((Object)RuBlocks.PALM_WOOD_SET.getStrippedLog()).add((Object)RuBlocks.PINE_WOOD_SET.getStrippedLog()).add((Object)RuBlocks.PINK_BIOSHROOM_WOOD_SET.getStrippedLog()).add((Object)RuBlocks.REDWOOD_WOOD_SET.getStrippedLog()).add((Object)RuBlocks.SOCOTRA_WOOD_SET.getStrippedLog()).add((Object)RuBlocks.WILLOW_WOOD_SET.getStrippedLog()).add((Object)RuBlocks.YELLOW_BIOSHROOM_WOOD_SET.getStrippedLog());
        this.tag(Tags.Blocks.STRIPPED_WOODS).add((Object)RuBlocks.BAOBAB_WOOD_SET.getStrippedWood()).add((Object)RuBlocks.BLACKWOOD_WOOD_SET.getStrippedWood()).add((Object)RuBlocks.BLUE_BIOSHROOM_WOOD_SET.getStrippedWood()).add((Object)RuBlocks.BRIMWOOD_WOOD_SET.getStrippedWood()).add((Object)RuBlocks.COBALT_WOOD_SET.getStrippedWood()).add((Object)RuBlocks.CYPRESS_WOOD_SET.getStrippedWood()).add((Object)RuBlocks.DEAD_WOOD_SET.getStrippedWood()).add((Object)RuBlocks.EUCALYPTUS_WOOD_SET.getStrippedWood()).add((Object)RuBlocks.GREEN_BIOSHROOM_WOOD_SET.getStrippedWood()).add((Object)RuBlocks.JOSHUA_WOOD_SET.getStrippedWood()).add((Object)RuBlocks.KAPOK_WOOD_SET.getStrippedWood()).add((Object)RuBlocks.LARCH_WOOD_SET.getStrippedWood()).add((Object)RuBlocks.MAGNOLIA_WOOD_SET.getStrippedWood()).add((Object)RuBlocks.MAPLE_WOOD_SET.getStrippedWood()).add((Object)RuBlocks.MAUVE_WOOD_SET.getStrippedWood()).add((Object)RuBlocks.PALM_WOOD_SET.getStrippedWood()).add((Object)RuBlocks.PINE_WOOD_SET.getStrippedWood()).add((Object)RuBlocks.PINK_BIOSHROOM_WOOD_SET.getStrippedWood()).add((Object)RuBlocks.REDWOOD_WOOD_SET.getStrippedWood()).add((Object)RuBlocks.SOCOTRA_WOOD_SET.getStrippedWood()).add((Object)RuBlocks.WILLOW_WOOD_SET.getStrippedWood()).add((Object)RuBlocks.YELLOW_BIOSHROOM_WOOD_SET.getStrippedWood());
    }
}

