/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.datagen.provider;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementType;
import net.minecraft.advancements.critereon.ConsumeItemTrigger;
import net.minecraft.advancements.critereon.EnterBlockTrigger;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.data.AdvancementProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.regions_unexplored.Constants;
import net.regions_unexplored.block.RuBlocks;
import net.regions_unexplored.data.worldgen.biome.RuBiomes;
import net.regions_unexplored.item.RuItems;

public class RuAdvancementProvider
extends AdvancementProvider {
    public RuAdvancementProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries, ExistingFileHelper existingFileHelper) {
        super(output, registries, existingFileHelper, List.of(new AdvancementBuilder()));
    }

    private static class AdvancementBuilder
    implements AdvancementProvider.AdvancementGenerator {
        private AdvancementBuilder() {
        }

        public void generate(HolderLookup.Provider registries, Consumer<AdvancementHolder> saver, ExistingFileHelper existingFileHelper) {
            HolderLookup.RegistryLookup holdergetter = registries.lookupOrThrow(Registries.BIOME);
            AdvancementHolder PARENT = Advancement.Builder.advancement().display((ItemLike)RuBlocks.EUCALYPTUS_NATURAL_SET.getSapling(), (Component)Component.translatable((String)"advancements.regions_unexplored.title"), (Component)Component.translatable((String)"advancements.regions_unexplored.description"), Constants.id("textures/gui/advancements/backgrounds/argillite.png"), AdvancementType.TASK, true, false, false).addCriterion("load_in_world", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inDimension((ResourceKey)Level.OVERWORLD))).save(saver, this.getAdvancementName("regions_unexplored", "parent"));
            AdvancementHolder PIONEER = Advancement.Builder.advancement().parent(PARENT).display((ItemLike)RuBlocks.HIBISCUS.get(), (Component)Component.translatable((String)"advancements.regions_unexplored.pioneer.title"), (Component)Component.translatable((String)"advancements.regions_unexplored.pioneer.description"), Constants.id("textures/gui/advancements/backgrounds/argillite.png"), AdvancementType.TASK, true, true, false).addCriterion("alpha_grove", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.ALPHA_GROVE)))).addCriterion("arid_mountains", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.ARID_MOUNTAINS)))).addCriterion("ashen_woodland", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.ASHEN_WOODLAND)))).addCriterion("autumnal_maple_forest", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.AUTUMNAL_MAPLE_FOREST)))).addCriterion("bayou", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.BAYOU)))).addCriterion("bamboo_forest", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.BAMBOO_FOREST)))).addCriterion("baobab_savanna", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.BAOBAB_SAVANNA)))).addCriterion("barley_fields", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.BARLEY_FIELDS)))).addCriterion("blackwood_taiga", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.BLACKWOOD_TAIGA)))).addCriterion("boreal_forest", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.BOREAL_TAIGA)))).addCriterion("chalk_cliffs", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.CHALK_CLIFFS)))).addCriterion("cold_boreal_taiga", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.COLD_BOREAL_TAIGA)))).addCriterion("cold_deciduous_forest", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.COLD_DECIDUOUS_FOREST)))).addCriterion("cold_river", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.COLD_RIVER)))).addCriterion("deciduous_forest", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.DECIDUOUS_FOREST)))).addCriterion("dry_bushland", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.DRY_BUSHLAND)))).addCriterion("eucalyptus_forest", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.EUCALYPTUS_FOREST)))).addCriterion("fen", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.FEN)))).addCriterion("flower_fields", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.FLOWER_FIELDS)))).addCriterion("frozen_pine_taiga", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.FROZEN_PINE_TAIGA)))).addCriterion("frozen_tundra", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.FROZEN_TUNDRA)))).addCriterion("fungal_fen", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.FUNGAL_FEN)))).addCriterion("golden_boreal_taiga", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.GOLDEN_BOREAL_TAIGA)))).addCriterion("grassland", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.GRASSLAND)))).addCriterion("grassy_beach", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.GRASSY_BEACH)))).addCriterion("gravel_beach", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.GRAVEL_BEACH)))).addCriterion("highland_fields", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.HIGHLAND_FIELDS)))).addCriterion("hyacinth_deeps", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.HYACINTH_DEEPS)))).addCriterion("icy_heights", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.ICY_HEIGHTS)))).addCriterion("joshua_desert", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.JOSHUA_DESERT)))).addCriterion("lupine_plains", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.CLOVER_PLAINS)))).addCriterion("magnolia_highlands", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.MAGNOLIA_WOODLAND)))).addCriterion("maple_forest", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.MAPLE_FOREST)))).addCriterion("marsh", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.MARSH)))).addCriterion("mauve_hills", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.MAUVE_HILLS)))).addCriterion("mountains", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.MOUNTAINS)))).addCriterion("muddy_river", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.MUDDY_RIVER)))).addCriterion("old_growth_bayou", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.OLD_GROWTH_BAYOU)))).addCriterion("ochard", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.ORCHARD)))).addCriterion("outback", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.OUTBACK)))).addCriterion("pine_slopes", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.PINE_SLOPES)))).addCriterion("pine_taiga", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.PINE_TAIGA)))).addCriterion("poppy_fields", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.POPPY_FIELDS)))).addCriterion("prairie", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.PRAIRIE)))).addCriterion("pumpkin_fields", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.PUMPKIN_FIELDS)))).addCriterion("rainforest", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.RAINFOREST)))).addCriterion("redwoods", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.REDWOODS)))).addCriterion("rocky_meadow", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.ROCKY_MEADOW)))).addCriterion("rocky_reef", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.ROCKY_REEF)))).addCriterion("saguaro_desert", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.SAGUARO_DESERT)))).addCriterion("shrubland", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.SHRUBLAND)))).addCriterion("silver_birch_forest", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.SILVER_BIRCH_FOREST)))).addCriterion("sparse_rainforest", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.SPARSE_RAINFOREST)))).addCriterion("sparse_redwoods", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.SPARSE_REDWOODS)))).addCriterion("spires", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.SPIRES)))).addCriterion("steppe", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.STEPPE)))).addCriterion("temperate_grove", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.TEMPERATE_GROVE)))).addCriterion("towering_cliffs", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.TOWERING_CLIFFS)))).addCriterion("tropical_river", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.TROPICAL_RIVER)))).addCriterion("tropics", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.TROPICS)))).addCriterion("willow_forest", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.WILLOW_FOREST)))).save(saver, this.getAdvancementName("regions_unexplored", "pioneer"));
            AdvancementHolder REGIONS_EXPLORED = Advancement.Builder.advancement().parent(PIONEER).display((ItemLike)Items.LEATHER_BOOTS, (Component)Component.translatable((String)"advancements.regions_unexplored.regions_explored.title"), (Component)Component.translatable((String)"advancements.regions_unexplored.regions_explored.description"), ResourceLocation.tryBuild((String)"regions_unexplored", (String)"textures/gui/advancements/backgrounds/argillite.png"), AdvancementType.CHALLENGE, true, true, true).addCriterion("alpha_grove", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.ALPHA_GROVE)))).addCriterion("ancient_delta", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.ANCIENT_DELTA)))).addCriterion("arid_mountains", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.ARID_MOUNTAINS)))).addCriterion("ashen_woodland", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.ASHEN_WOODLAND)))).addCriterion("autumnal_maple_forest", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.AUTUMNAL_MAPLE_FOREST)))).addCriterion("bayou", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.BAYOU)))).addCriterion("bamboo_forest", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.BAMBOO_FOREST)))).addCriterion("baobab_savanna", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.BAOBAB_SAVANNA)))).addCriterion("barley_fields", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.BARLEY_FIELDS)))).addCriterion("bioshroom_caves", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.BIOSHROOM_CAVES)))).addCriterion("blackstone_basin", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.BLACKSTONE_BASIN)))).addCriterion("blackwood_taiga", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.BLACKWOOD_TAIGA)))).addCriterion("boreal_forest", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.BOREAL_TAIGA)))).addCriterion("chalk_cliffs", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.CHALK_CLIFFS)))).addCriterion("cold_boreal_taiga", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.COLD_BOREAL_TAIGA)))).addCriterion("cold_deciduous_forest", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.COLD_DECIDUOUS_FOREST)))).addCriterion("cold_river", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.COLD_RIVER)))).addCriterion("deciduous_forest", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.DECIDUOUS_FOREST)))).addCriterion("dry_bushland", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.DRY_BUSHLAND)))).addCriterion("eucalyptus_forest", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.EUCALYPTUS_FOREST)))).addCriterion("fen", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.FEN)))).addCriterion("flower_fields", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.FLOWER_FIELDS)))).addCriterion("frozen_pine_taiga", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.FROZEN_PINE_TAIGA)))).addCriterion("frozen_tundra", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.FROZEN_TUNDRA)))).addCriterion("fungal_fen", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.FUNGAL_FEN)))).addCriterion("glistering_meadow", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.GLISTERING_MEADOW)))).addCriterion("golden_boreal_taiga", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.GOLDEN_BOREAL_TAIGA)))).addCriterion("grassland", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.GRASSLAND)))).addCriterion("grassy_beach", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.GRASSY_BEACH)))).addCriterion("gravel_beach", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.GRAVEL_BEACH)))).addCriterion("highland_fields", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.HIGHLAND_FIELDS)))).addCriterion("hyacinth_deeps", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.HYACINTH_DEEPS)))).addCriterion("icy_heights", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.ICY_HEIGHTS)))).addCriterion("infernal_holt", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.INFERNAL_HOLT)))).addCriterion("joshua_desert", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.JOSHUA_DESERT)))).addCriterion("lupine_plains", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.CLOVER_PLAINS)))).addCriterion("magnolia_highlands", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.MAGNOLIA_WOODLAND)))).addCriterion("maple_forest", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.MAPLE_FOREST)))).addCriterion("marsh", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.MARSH)))).addCriterion("mauve_hills", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.MAUVE_HILLS)))).addCriterion("mountains", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.MOUNTAINS)))).addCriterion("muddy_river", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.MUDDY_RIVER)))).addCriterion("mycotoxic_undergrowth", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.MYCOTOXIC_UNDERGROWTH)))).addCriterion("old_growth_bayou", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.OLD_GROWTH_BAYOU)))).addCriterion("ochard", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.ORCHARD)))).addCriterion("outback", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.OUTBACK)))).addCriterion("pine_slopes", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.PINE_SLOPES)))).addCriterion("pine_taiga", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.PINE_TAIGA)))).addCriterion("poppy_fields", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.POPPY_FIELDS)))).addCriterion("prairie", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.PRAIRIE)))).addCriterion("prismachasm", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.PRISMACHASM)))).addCriterion("pumpkin_fields", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.PUMPKIN_FIELDS)))).addCriterion("rainforest", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.RAINFOREST)))).addCriterion("redstone_abyss", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.REDSTONE_ABYSS)))).addCriterion("redstone_caves", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.REDSTONE_CAVES)))).addCriterion("redwoods", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.REDWOODS)))).addCriterion("rocky_meadow", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.ROCKY_MEADOW)))).addCriterion("rocky_reef", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.ROCKY_REEF)))).addCriterion("saguaro_desert", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.SAGUARO_DESERT)))).addCriterion("scorching_caves", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.SCORCHING_CAVES)))).addCriterion("shrubland", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.SHRUBLAND)))).addCriterion("silver_birch_forest", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.SILVER_BIRCH_FOREST)))).addCriterion("sparse_rainforest", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.SPARSE_RAINFOREST)))).addCriterion("sparse_redwoods", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.SPARSE_REDWOODS)))).addCriterion("spires", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.SPIRES)))).addCriterion("steppe", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.STEPPE)))).addCriterion("temperate_grove", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.TEMPERATE_GROVE)))).addCriterion("towering_cliffs", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.TOWERING_CLIFFS)))).addCriterion("tropical_river", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.TROPICAL_RIVER)))).addCriterion("tropics", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.TROPICS)))).addCriterion("willow_forest", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.WILLOW_FOREST)))).save(saver, this.getAdvancementName("regions_unexplored", "regions_explored"));
            AdvancementHolder EVERY_BIT_OF_THE_RAINBOW = Advancement.Builder.advancement().parent(PIONEER).display((ItemLike)RuBlocks.SNOWBELLES.get(DyeColor.WHITE), (Component)Component.translatable((String)"advancements.regions_unexplored.every_bit_of_the_rainbow.title"), (Component)Component.translatable((String)"advancements.regions_unexplored.every_bit_of_the_rainbow.description"), Constants.id("textures/gui/advancements/backgrounds/argillite.png"), AdvancementType.TASK, true, true, false).addCriterion("white_snowbelle", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{RuBlocks.SNOWBELLES.get(DyeColor.WHITE).asItem()})).addCriterion("black_snowbelle", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{RuBlocks.SNOWBELLES.get(DyeColor.BLACK).asItem()})).addCriterion("blue_snowbelle", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{RuBlocks.SNOWBELLES.get(DyeColor.BLUE).asItem()})).addCriterion("green_snowbelle", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{RuBlocks.SNOWBELLES.get(DyeColor.GREEN).asItem()})).addCriterion("pink_snowbelle", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{RuBlocks.SNOWBELLES.get(DyeColor.PINK).asItem()})).addCriterion("brown_snowbelle", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{RuBlocks.SNOWBELLES.get(DyeColor.BROWN).asItem()})).addCriterion("cyan_snowbelle", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{RuBlocks.SNOWBELLES.get(DyeColor.CYAN).asItem()})).addCriterion("gray_snowbelle", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{RuBlocks.SNOWBELLES.get(DyeColor.GRAY).asItem()})).addCriterion("magenta_snowbelle", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{RuBlocks.SNOWBELLES.get(DyeColor.MAGENTA).asItem()})).addCriterion("red_snowbelle", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{RuBlocks.SNOWBELLES.get(DyeColor.RED).asItem()})).addCriterion("orange_snowbelle", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{RuBlocks.SNOWBELLES.get(DyeColor.ORANGE).asItem()})).addCriterion("yellow_snowbelle", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{RuBlocks.SNOWBELLES.get(DyeColor.YELLOW).asItem()})).addCriterion("purple_snowbelle", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{RuBlocks.SNOWBELLES.get(DyeColor.PURPLE).asItem()})).addCriterion("lime_snowbelle", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{RuBlocks.SNOWBELLES.get(DyeColor.LIME).asItem()})).addCriterion("light_gray_snowbelle", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{RuBlocks.SNOWBELLES.get(DyeColor.LIGHT_GRAY).asItem()})).addCriterion("light_blue_snowbelle", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{RuBlocks.SNOWBELLES.get(DyeColor.LIGHT_BLUE).asItem()})).save(saver, this.getAdvancementName("regions_unexplored", "every_bit_of_the_rainbow"));
            AdvancementHolder FROM_THE_TREE_TOPS = Advancement.Builder.advancement().parent(PIONEER).display((ItemLike)RuBlocks.KAPOK_VINES.get(), (Component)Component.translatable((String)"advancements.regions_unexplored.from_the_tree_tops.title"), (Component)Component.translatable((String)"advancements.regions_unexplored.from_the_tree_tops.description"), Constants.id("textures/gui/advancements/backgrounds/argillite.png"), AdvancementType.TASK, true, true, false).addCriterion("kapok_vines", EnterBlockTrigger.TriggerInstance.entersBlock((Block)RuBlocks.KAPOK_VINES_PLANT.get())).save(saver, this.getAdvancementName("regions_unexplored", "from_the_tree_tops"));
            AdvancementHolder LIGHT_AS_A_FROG = Advancement.Builder.advancement().parent(PIONEER).display((ItemLike)RuBlocks.FLOWERING_LILY_PAD.get(), (Component)Component.translatable((String)"advancements.regions_unexplored.light_as_a_frog.title"), (Component)Component.translatable((String)"advancements.regions_unexplored.light_as_a_frog.description"), Constants.id("textures/gui/advancements/backgrounds/argillite.png"), AdvancementType.TASK, true, true, false).addCriterion("lily_pad", EnterBlockTrigger.TriggerInstance.entersBlock((Block)RuBlocks.GIANT_LILY_PAD.get())).save(saver, this.getAdvancementName("regions_unexplored", "light_as_a_frog"));
            AdvancementHolder ETERNAL_EXPEDITION = Advancement.Builder.advancement().parent(PARENT).display((ItemLike)RuBlocks.BRIMWOOD_NATURAL_SET.getSapling(), (Component)Component.translatable((String)"advancements.regions_unexplored.eternal_expedition.title"), (Component)Component.translatable((String)"advancements.regions_unexplored.eternal_expedition.description"), Constants.id("textures/gui/advancements/backgrounds/argillite.png"), AdvancementType.TASK, true, true, false).addCriterion("blackstone_basin", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.BLACKSTONE_BASIN)))).addCriterion("mycotoxic_undergrowth", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.MYCOTOXIC_UNDERGROWTH)))).addCriterion("glistering_meadow", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.GLISTERING_MEADOW)))).addCriterion("infernal_holt", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.INFERNAL_HOLT)))).addCriterion("redstone_abyss", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.REDSTONE_ABYSS)))).save(saver, this.getAdvancementName("regions_unexplored", "eternal_expedition"));
            AdvancementHolder DOWNER = Advancement.Builder.advancement().parent(ETERNAL_EXPEDITION).display((ItemLike)RuBlocks.DORCEL.get(), (Component)Component.translatable((String)"advancements.regions_unexplored.downer.title"), (Component)Component.translatable((String)"advancements.regions_unexplored.downer.description"), Constants.id("textures/gui/advancements/backgrounds/argillite.png"), AdvancementType.TASK, true, true, false).addCriterion("dorcel", EnterBlockTrigger.TriggerInstance.entersBlock((Block)RuBlocks.DORCEL.get())).save(saver, this.getAdvancementName("regions_unexplored", "downer"));
            AdvancementHolder LIGHT_SNACK = Advancement.Builder.advancement().parent(ETERNAL_EXPEDITION).display((ItemLike)RuBlocks.HANGING_EARLIGHT.get(), (Component)Component.translatable((String)"advancements.regions_unexplored.light_snack.title"), (Component)Component.translatable((String)"advancements.regions_unexplored.light_snack.description"), Constants.id("textures/gui/advancements/backgrounds/argillite.png"), AdvancementType.TASK, true, true, false).addCriterion("earlight", ConsumeItemTrigger.TriggerInstance.usedItem((ItemLike)((ItemLike)RuItems.HANGING_EARLIGHT_FRUIT.get()))).save(saver, this.getAdvancementName("regions_unexplored", "light_snack"));
            AdvancementHolder SPELUNKER = Advancement.Builder.advancement().parent(PARENT).display((ItemLike)RuBlocks.DROPLEAF.get(), (Component)Component.translatable((String)"advancements.regions_unexplored.spelunker.title"), (Component)Component.translatable((String)"advancements.regions_unexplored.spelunker.description"), Constants.id("textures/gui/advancements/backgrounds/argillite.png"), AdvancementType.TASK, true, true, false).addCriterion("bioshroom_caves", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.BIOSHROOM_CAVES)))).addCriterion("ancient_delta", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.ANCIENT_DELTA)))).addCriterion("prismachasm", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.PRISMACHASM)))).addCriterion("redstone_caves", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.REDSTONE_CAVES)))).addCriterion("scorching_caves", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)holdergetter.getOrThrow(RuBiomes.SCORCHING_CAVES)))).save(saver, this.getAdvancementName("regions_unexplored", "spelunker"));
            AdvancementHolder BLIND_AS_A_BAT = Advancement.Builder.advancement().parent(SPELUNKER).display((ItemLike)RuBlocks.DUSKMELON.get(), (Component)Component.translatable((String)"advancements.regions_unexplored.blind_as_a_bat.title"), (Component)Component.translatable((String)"advancements.regions_unexplored.blind_as_a_bat.description"), Constants.id("textures/gui/advancements/backgrounds/argillite.png"), AdvancementType.TASK, true, true, false).addCriterion("duskmelon", ConsumeItemTrigger.TriggerInstance.usedItem((ItemLike)((ItemLike)RuItems.DUSKMELON_SLICE.get()))).save(saver, this.getAdvancementName("regions_unexplored", "blind_as_a_bat"));
            AdvancementHolder THIS_TREE_BLEEDS_RED = Advancement.Builder.advancement().parent(PARENT).display((ItemLike)RuBlocks.SOCOTRA_WOOD_SET.getLog(), (Component)Component.translatable((String)"advancements.regions_unexplored.this_tree_bleeds_red.title"), (Component)Component.translatable((String)"advancements.regions_unexplored.this_tree_bleeds_red.description"), Constants.id("textures/gui/advancements/backgrounds/argillite.png"), AdvancementType.TASK, true, true, false).addCriterion("socotra_log", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{RuBlocks.SOCOTRA_WOOD_SET.getLog()})).save(saver, this.getAdvancementName("regions_unexplored", "this_tree_bleeds_red"));
            AdvancementHolder GOT_WOOD = Advancement.Builder.advancement().parent(THIS_TREE_BLEEDS_RED).display((ItemLike)RuBlocks.REDWOOD_WOOD_SET.getLog(), (Component)Component.translatable((String)"advancements.regions_unexplored.got_wood.title"), (Component)Component.translatable((String)"advancements.regions_unexplored.got_wood.description"), Constants.id("textures/gui/advancements/backgrounds/argillite.png"), AdvancementType.CHALLENGE, true, true, false).addCriterion("bamboo_log", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{RuBlocks.BAMBOO_LOG.get().asItem()})).addCriterion("small_oak_log", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{RuBlocks.SMALL_OAK_LOG.get().asItem()})).addCriterion("ashen_log", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{RuBlocks.ASHEN_WOOD_SET.getLog().asItem()})).addCriterion("silver_birch_log", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{RuBlocks.SILVER_BIRCH_WOOD_SET.getLog().asItem()})).addCriterion("alpha_log", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{RuBlocks.ALPHA_WOOD_SET.getLog().asItem()})).addCriterion("baobab_log", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{RuBlocks.BAOBAB_WOOD_SET.getLog().asItem()})).addCriterion("blackwood_log", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{RuBlocks.BLACKWOOD_WOOD_SET.getLog().asItem()})).addCriterion("brimwood_log", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{RuBlocks.BRIMWOOD_WOOD_SET.getLog().asItem()})).addCriterion("cobalt_log", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{RuBlocks.COBALT_WOOD_SET.getLog().asItem()})).addCriterion("cypress_log", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{RuBlocks.CYPRESS_WOOD_SET.getLog().asItem()})).addCriterion("dead_log", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{RuBlocks.DEAD_WOOD_SET.getLog().asItem()})).addCriterion("eucalyptus_log", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{RuBlocks.EUCALYPTUS_WOOD_SET.getLog().asItem()})).addCriterion("joshua_log", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{RuBlocks.JOSHUA_WOOD_SET.getLog().asItem()})).addCriterion("kapok_log", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{RuBlocks.KAPOK_WOOD_SET.getLog().asItem()})).addCriterion("larch_log", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{RuBlocks.LARCH_WOOD_SET.getLog().asItem()})).addCriterion("magnolia_log", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{RuBlocks.MAGNOLIA_WOOD_SET.getLog().asItem()})).addCriterion("maple_log", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{RuBlocks.MAPLE_WOOD_SET.getLog().asItem()})).addCriterion("mauve_log", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{RuBlocks.MAUVE_WOOD_SET.getLog().asItem()})).addCriterion("palm_log", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{RuBlocks.PALM_WOOD_SET.getLog().asItem()})).addCriterion("pine_log", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{RuBlocks.PINE_WOOD_SET.getLog().asItem()})).addCriterion("redwood_log", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{RuBlocks.REDWOOD_WOOD_SET.getLog().asItem()})).addCriterion("socotra_log", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{RuBlocks.SOCOTRA_WOOD_SET.getLog().asItem()})).addCriterion("willow_log", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{RuBlocks.WILLOW_WOOD_SET.getLog().asItem()})).addCriterion("blue_bioshroom_stem", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{RuBlocks.BLUE_BIOSHROOM_WOOD_SET.getLog().asItem()})).addCriterion("green_bioshroom_stem", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{RuBlocks.GREEN_BIOSHROOM_WOOD_SET.getLog().asItem()})).addCriterion("pink_bioshroom_stem", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{RuBlocks.PINK_BIOSHROOM_WOOD_SET.getLog().asItem()})).addCriterion("yellow_bioshroom_stem", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{RuBlocks.YELLOW_BIOSHROOM_WOOD_SET.getLog().asItem()})).save(saver, this.getAdvancementName("regions_unexplored", "got_wood"));
            AdvancementHolder MYCOLOGIST = Advancement.Builder.advancement().parent(PARENT).display((ItemLike)RuBlocks.BLUE_BIOSHROOM.get(), (Component)Component.translatable((String)"advancements.regions_unexplored.mycologist.title"), (Component)Component.translatable((String)"advancements.regions_unexplored.mycologist.description"), Constants.id("textures/gui/advancements/backgrounds/argillite.png"), AdvancementType.TASK, true, true, false).addCriterion("blue_bioshroom", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{RuBlocks.BLUE_BIOSHROOM.get().asItem()})).addCriterion("pink_bioshroom", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{RuBlocks.PINK_BIOSHROOM.get().asItem()})).addCriterion("yellow_bioshroom", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{RuBlocks.YELLOW_BIOSHROOM.get().asItem()})).addCriterion("green_bioshroom", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{RuBlocks.GREEN_BIOSHROOM.get().asItem()})).save(saver, this.getAdvancementName("regions_unexplored", "mycologist"));
            AdvancementHolder ANCIENT_SPECIMENS = Advancement.Builder.advancement().parent(MYCOLOGIST).display((ItemLike)RuBlocks.BLUE_BIOSHROOM_WOOD_SET.getLog(), (Component)Component.translatable((String)"advancements.regions_unexplored.ancient_specimens.title"), (Component)Component.translatable((String)"advancements.regions_unexplored.ancient_specimens.description"), Constants.id("textures/gui/advancements/backgrounds/argillite.png"), AdvancementType.CHALLENGE, true, true, false).addCriterion("blue_bioshroom_stem", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{RuBlocks.BLUE_BIOSHROOM_WOOD_SET.getLog().asItem()})).addCriterion("pink_bioshroom_stem", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{RuBlocks.PINK_BIOSHROOM_WOOD_SET.getLog().asItem()})).addCriterion("yellow_bioshroom_stem", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{RuBlocks.YELLOW_BIOSHROOM_WOOD_SET.getLog().asItem()})).addCriterion("green_bioshroom_stem", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{RuBlocks.GREEN_BIOSHROOM_WOOD_SET.getLog().asItem()})).save(saver, this.getAdvancementName("regions_unexplored", "ancient_specimens"));
        }

        private String getAdvancementName(String modid, String id) {
            return modid + ":" + id;
        }
    }
}

