/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.datagen;

import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.TagsProvider;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.regions_unexplored.data.noise.RuNoises;
import net.regions_unexplored.datagen.provider.RuAdvancementProvider;
import net.regions_unexplored.datagen.provider.RuBiomeTagProvider;
import net.regions_unexplored.datagen.provider.RuBlockModelProvider;
import net.regions_unexplored.datagen.provider.RuBlockTagProvider;
import net.regions_unexplored.datagen.provider.RuDataMapGenerator;
import net.regions_unexplored.datagen.provider.RuItemTagProvider;
import net.regions_unexplored.datagen.provider.RuLanguageProvider;
import net.regions_unexplored.datagen.provider.RuLootTableProvider;
import net.regions_unexplored.datagen.provider.RuRecipeProvider;
import net.regions_unexplored.entity.RuDamageTypes;
import net.regions_unexplored.registry.BiomeRegistry;
import net.regions_unexplored.registry.ConfiguredFeatureRegistry;
import net.regions_unexplored.registry.PlacedFeatureRegistry;

@EventBusSubscriber(modid="regions_unexplored", bus=EventBusSubscriber.Bus.MOD)
public class DataGeneration {
    private static final RegistrySetBuilder BOOTSTRAPS = new RegistrySetBuilder().add(Registries.CONFIGURED_FEATURE, ConfiguredFeatureRegistry::bootstrap).add(Registries.PLACED_FEATURE, PlacedFeatureRegistry::bootstrap).add(Registries.BIOME, BiomeRegistry::bootstrap).add(Registries.NOISE, RuNoises::bootstrap).add(Registries.DAMAGE_TYPE, RuDamageTypes::bootstrap);

    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture holder = event.getLookupProvider();
        DatapackBuiltinEntriesProvider datapackRegistries = new DatapackBuiltinEntriesProvider(packOutput, event.getLookupProvider(), BOOTSTRAPS, Set.of("regions_unexplored"));
        DatapackBuiltinEntriesProvider dataProvider = (DatapackBuiltinEntriesProvider)generator.addProvider(event.includeServer(), (DataProvider)datapackRegistries);
        generator.addProvider(true, (DataProvider)new RuAdvancementProvider(packOutput, datapackRegistries.getRegistryProvider(), existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new RuBlockModelProvider(packOutput, "regions_unexplored", existingFileHelper));
        generator.addProvider(true, (DataProvider)new RuRecipeProvider(packOutput, holder));
        generator.addProvider(true, (DataProvider)RuLootTableProvider.create(packOutput, holder));
        generator.addProvider(true, (DataProvider)new RuLanguageProvider(packOutput));
        TagsProvider blockTagsProvider = (TagsProvider)generator.addProvider(event.includeServer(), (DataProvider)new RuBlockTagProvider(packOutput, datapackRegistries.getRegistryProvider(), "regions_unexplored", existingFileHelper));
        TagsProvider itemTagsProvider = (TagsProvider)generator.addProvider(event.includeServer(), (DataProvider)new RuItemTagProvider(packOutput, datapackRegistries.getRegistryProvider(), blockTagsProvider.contentsGetter(), "regions_unexplored", existingFileHelper));
        TagsProvider biomeTagsProvider = (TagsProvider)generator.addProvider(event.includeServer(), (DataProvider)new RuBiomeTagProvider(packOutput, datapackRegistries.getRegistryProvider(), "regions_unexplored", existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new RuDataMapGenerator(packOutput, holder));
    }
}

