/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;

public class LeafParticle
extends TextureSheetParticle {
    private static final float ACCELERATION_SCALE = 1.0f;
    private static final int INITIAL_LIFETIME = 300;
    private static final int CURVE_ENDPOINT_TIME = 300;
    private static final float FALL_ACC = 1.0f;
    private static final float WIND_BIG = 2.0f;
    private float rotSpeed;
    private final float particleRandom;
    private final float spinAcceleration;

    public LeafParticle(ClientLevel clientLevel, double p_278010_, double p_277614_, double p_277673_, SpriteSet spriteSet) {
        super(clientLevel, p_278010_, p_277614_, p_277673_);
        float f;
        this.setSprite(spriteSet.get(this.random.nextInt(4), 4));
        this.rotSpeed = (float)Math.toRadians(this.random.nextBoolean() ? -30.0 : 30.0);
        this.particleRandom = this.random.nextFloat();
        this.spinAcceleration = (float)Math.toRadians(this.random.nextBoolean() ? -5.0 : 5.0);
        this.lifetime = 300;
        this.gravity = -0.04f;
        this.quadSize = f = this.random.nextBoolean() ? 0.06f : 0.085f;
        this.setSize(f, f);
        this.friction = 1.0f;
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.lifetime-- <= 0) {
            this.remove();
        }
        if (!this.removed) {
            float f = 300 - this.lifetime;
            float f1 = Math.min(f / 300.0f, 1.0f);
            double d0 = Math.cos(Math.toRadians(this.particleRandom * 60.0f)) * 2.0 * Math.pow(f1, 1.25);
            double d1 = Math.sin(Math.toRadians(this.particleRandom * 60.0f)) * 2.0 * Math.pow(f1, 1.25);
            this.xd += d0 * (double)0.0025f;
            this.zd += d1 * (double)0.0025f;
            this.yd = this.gravity;
            this.rotSpeed += this.spinAcceleration / 20.0f;
            this.oRoll = this.roll;
            this.roll += this.rotSpeed / 20.0f;
            this.move(this.xd, this.yd, this.zd);
            if (this.onGround || this.lifetime < 299 && (this.xd == 0.0 || this.zd == 0.0)) {
                this.remove();
            }
            if (!this.removed) {
                this.xd *= (double)this.friction;
                this.zd *= (double)this.friction;
            }
        }
    }
}

