/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.replication.client.gui.button;

import com.buuz135.replication.ReplicationRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;

public class ReplicationTerminalTexturedButton
extends Button {
    private final ResourceLocation textureRL;
    private final String tooltip;
    private final int textureX;
    private final int textureY;
    private final int hoveredTextureX;
    private final int hoveredTextureY;

    public ReplicationTerminalTexturedButton(int pX, int pY, int pWidth, int pHeight, Component component, ResourceLocation textureRL, String tooltip, int textureX, int textureY, int hoveredTextureX, int hoveredTextureY, Button.OnPress onPress) {
        super(pX, pY, pWidth, pHeight, component, onPress, supplier -> Component.empty());
        this.textureRL = textureRL;
        this.tooltip = tooltip;
        this.textureX = textureX;
        this.textureY = textureY;
        this.hoveredTextureX = hoveredTextureX;
        this.hoveredTextureY = hoveredTextureY;
    }

    protected void renderWidget(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.isHovered = pMouseX >= this.getX() && pMouseY >= this.getY() && pMouseX < this.getX() + this.width && pMouseY < this.getY() + this.height;
        guiGraphics.blit(this.textureRL, this.getX(), this.getY(), this.textureX, this.textureY, this.width, this.height);
        if (this.isHovered) {
            guiGraphics.blit(this.textureRL, this.getX(), this.getY(), this.hoveredTextureX, this.hoveredTextureY, this.width, this.height);
            guiGraphics.renderTooltip(Minecraft.getInstance().font, (Component)Component.translatable((String)this.tooltip), pMouseX, pMouseY);
        } else {
            guiGraphics.blit(this.textureRL, this.getX(), this.getY(), this.textureX, this.textureY, this.width, this.height);
        }
        int i = this.getFGColor();
        this.renderString(guiGraphics, Minecraft.getInstance().font, i | Mth.ceil((float)(this.alpha * 255.0f)) << 24);
    }

    public void playDownSound(SoundManager pHandler) {
        pHandler.play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)((SoundEvent)ReplicationRegistry.Sounds.TERMINAL_BUTTON.get()), (float)1.0f));
    }
}

