/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbessentials.util;

import dev.architectury.event.CompoundEventResult;
import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.ftb.mods.ftbessentials.api.event.TeleportEvent;
import dev.ftb.mods.ftbessentials.config.FTBEConfig;
import dev.ftb.mods.ftbessentials.util.FTBEPlayerData;
import dev.ftb.mods.ftbessentials.util.TeleportPos;
import dev.ftb.mods.ftbessentials.util.neoforge.WarmupCooldownTeleporterImpl;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class WarmupCooldownTeleporter {
    private final FTBEPlayerData playerData;
    private final ToIntFunction<ServerPlayer> cooldownConfig;
    private final ToIntFunction<ServerPlayer> warmupConfig;
    private final boolean popHistoryOnTeleport;
    private long lastRun;
    private static final Map<UUID, Warmup> WARMUPS = new HashMap<UUID, Warmup>();
    private static final Map<UUID, Warmup> pendingAdditions = new HashMap<UUID, Warmup>();
    private static final Set<UUID> pendingRemovals = new HashSet<UUID>();

    public WarmupCooldownTeleporter(FTBEPlayerData playerData, ToIntFunction<ServerPlayer> cooldownConfig, ToIntFunction<ServerPlayer> warmupConfig) {
        this(playerData, cooldownConfig, warmupConfig, false);
    }

    public WarmupCooldownTeleporter(FTBEPlayerData playerData, ToIntFunction<ServerPlayer> cooldownConfig, ToIntFunction<ServerPlayer> warmupConfig, boolean popHistoryOnTeleport) {
        this.playerData = playerData;
        this.cooldownConfig = cooldownConfig;
        this.warmupConfig = warmupConfig;
        this.popHistoryOnTeleport = popHistoryOnTeleport;
        this.lastRun = 0L;
    }

    public TeleportPos.TeleportResult checkCooldown(ServerPlayer player) {
        long nextRun;
        long now = System.currentTimeMillis();
        if (now < (nextRun = this.lastRun + Math.max(0L, (long)this.cooldownConfig.applyAsInt(player) * 1000L))) {
            return () -> nextRun - now;
        }
        return TeleportPos.TeleportResult.SUCCESS;
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static boolean firePlatformTeleportEvent(ServerPlayer player, Vec3 pos) {
        void var1_1;
        return WarmupCooldownTeleporterImpl.firePlatformTeleportEvent(player, (Vec3)var1_1);
    }

    public TeleportPos.TeleportResult teleport(ServerPlayer player, Function<ServerPlayer, TeleportPos> positionGetter) {
        TeleportPos.TeleportResult blacklistedResult;
        TeleportPos.TeleportResult cooldownResult = this.checkCooldown(player);
        if (!cooldownResult.isSuccess()) {
            return cooldownResult;
        }
        TeleportPos pos = positionGetter.apply(player);
        if (!(player.hasPermissions(2) && ((Boolean)FTBEConfig.ADMINS_EXEMPT_DIMENSION_BLACKLISTS.get()).booleanValue() || (blacklistedResult = pos.checkDimensionBlacklist((Player)player)).isSuccess())) {
            return blacklistedResult;
        }
        CompoundEventResult<Component> result = ((TeleportEvent.Teleport)TeleportEvent.TELEPORT.invoker()).teleport(player);
        if (result.isFalse()) {
            return TeleportPos.TeleportResult.failed((Component)result.object());
        }
        if (!WarmupCooldownTeleporter.firePlatformTeleportEvent(player, Vec3.atBottomCenterOf((Vec3i)pos.getPos()))) {
            return TeleportPos.TeleportResult.failed((Component)Component.translatable((String)"ftbessentials.teleport_prevented"));
        }
        int warmupTime = this.warmupConfig.applyAsInt(player);
        if (warmupTime == 0) {
            return this.teleportNow(player, pos);
        }
        pendingAdditions.put(player.getUUID(), new Warmup(System.currentTimeMillis() + (long)warmupTime * 1000L, this, player.position(), pos));
        return TeleportPos.TeleportResult.SUCCESS;
    }

    private TeleportPos.TeleportResult teleportNow(ServerPlayer player, TeleportPos teleportPos) {
        this.lastRun = System.currentTimeMillis();
        TeleportPos currentPos = new TeleportPos((Entity)player);
        TeleportPos.TeleportResult res = teleportPos.teleport(player);
        if (res.isSuccess()) {
            if (this.popHistoryOnTeleport) {
                this.playerData.popTeleportHistory();
            } else if (!((Boolean)FTBEConfig.BACK_ON_DEATH_ONLY.get()).booleanValue()) {
                this.playerData.addTeleportHistory(player, currentPos);
            }
        }
        return res;
    }

    public static void tickWarmups(MinecraftServer server) {
        WARMUPS.putAll(pendingAdditions);
        pendingAdditions.clear();
        pendingRemovals.forEach(WARMUPS::remove);
        pendingRemovals.clear();
        if (WARMUPS.isEmpty()) {
            return;
        }
        HashSet<UUID> toRemove = new HashSet<UUID>();
        long now = System.currentTimeMillis();
        for (Map.Entry<UUID, Warmup> entry : WARMUPS.entrySet()) {
            UUID playerId = entry.getKey();
            ServerPlayer player = server.getPlayerList().getPlayer(playerId);
            if (player != null) {
                Warmup warmup = entry.getValue();
                if (warmup.when() <= now) {
                    TeleportPos.TeleportResult res = warmup.teleporter().teleportNow(player, warmup.teleportPos());
                    toRemove.add(playerId);
                    res.runCommand(player);
                    continue;
                }
                if (player.position().distanceToSqr(warmup.initialPos) > 0.25) {
                    toRemove.add(playerId);
                    player.displayClientMessage((Component)Component.translatable((String)"ftbessentials.teleport.interrupted").withStyle(ChatFormatting.RED), true);
                    continue;
                }
                long seconds = (warmup.when() - now) / 1000L;
                player.displayClientMessage((Component)Component.translatable((String)"ftbessentials.teleport.notify", (Object[])new Object[]{seconds}).withStyle(ChatFormatting.YELLOW), true);
                continue;
            }
            toRemove.add(playerId);
        }
        toRemove.forEach(WARMUPS::remove);
    }

    public static void cancelWarmup(ServerPlayer player) {
        if (WARMUPS.containsKey(player.getUUID())) {
            pendingRemovals.add(player.getUUID());
            player.displayClientMessage((Component)Component.translatable((String)"ftbessentials.teleport.interrupted").withStyle(ChatFormatting.RED), true);
        }
    }

    private record Warmup(long when, WarmupCooldownTeleporter teleporter, Vec3 initialPos, TeleportPos teleportPos) {
    }
}

