/*
 * Decompiled with CFR 0.152.
 */
package com.ofekn.crafting_on_a_stick.api;

import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.function.Supplier;

public interface Ref<V> {
    public V get();

    public void set(V var1);

    public static <V> Ref<V> of(final Supplier<V> getter, final Consumer<V> setter) {
        return new Ref<V>(){

            @Override
            public V get() {
                return getter.get();
            }

            @Override
            public void set(V value) {
                setter.accept(value);
            }
        };
    }

    public static <V> Ref<V> ofArrayIndex(final V[] arr, final int index) {
        return new Ref<V>(){

            @Override
            public V get() {
                return arr[index];
            }

            @Override
            public void set(V value) {
                arr[index] = value;
            }
        };
    }

    public static <V> void forEveryIndex(final IntFunction<V> getter, final BiConsumer<Integer, V> setter, int size, List<Ref<V>> result) {
        int i = 0;
        while (i < size) {
            final int finalI = i++;
            result.add(new Ref<V>(){

                @Override
                public V get() {
                    return getter.apply(finalI);
                }

                @Override
                public void set(V value) {
                    setter.accept(finalI, value);
                }
            });
        }
    }
}

