/*
 * Decompiled with CFR 0.152.
 */
package curiousarmorstands;

import curiousarmorstands.ArmorStandCuriosDisplayLayer;
import java.util.Optional;
import java.util.Set;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;
import top.theillusivec4.curios.client.render.CuriosLayer;

@Mod(value="curious_armor_stands")
public class CuriousArmorStands {
    public static final String MOD_ID = "curious_armor_stands";
    public static final String SLOT = "curio";
    public static final ResourceLocation ATTRIBUTE_MODIFIER_ID = ResourceLocation.fromNamespaceAndPath((String)"curious_armor_stands", (String)"slots");

    @EventBusSubscriber(modid="curious_armor_stands")
    public static class Events {
        private static void createAttributeModifier(ArmorStand armorStand) {
            CuriosApi.getCuriosInventory((LivingEntity)armorStand).flatMap(inv -> inv.getStacksHandler(CuriousArmorStands.SLOT)).filter(stacks -> !stacks.getModifiers().containsKey(ATTRIBUTE_MODIFIER_ID)).ifPresent(stacks -> stacks.addPermanentModifier(new AttributeModifier(ATTRIBUTE_MODIFIER_ID, 7.0, AttributeModifier.Operation.ADD_VALUE)));
        }

        @SubscribeEvent
        public static void onEntityInteract(PlayerInteractEvent.EntityInteractSpecific event) {
            Entity entity = event.getTarget();
            if (entity instanceof ArmorStand) {
                ArmorStand armorStand = (ArmorStand)entity;
                Events.createAttributeModifier(armorStand);
                ItemStack stack = event.getItemStack();
                if (!stack.isEmpty()) {
                    Events.equipItem(armorStand, stack, event);
                } else if (Events.canUnequipCurio(event.getLocalPos(), armorStand)) {
                    Events.unequipItem(armorStand, event);
                }
            }
        }

        public static void equipItem(ArmorStand armorStand, ItemStack stack, PlayerInteractEvent.EntityInteractSpecific event) {
            if (CuriosApi.getItemStackSlots((ItemStack)stack, (Level)armorStand.level()).isEmpty()) {
                return;
            }
            if (armorStand.level().isClientSide()) {
                event.setCancellationResult(InteractionResult.SUCCESS);
                event.setCanceled(true);
                return;
            }
            CuriosApi.getCuriosInventory((LivingEntity)armorStand).flatMap(inv -> inv.getStacksHandler(CuriousArmorStands.SLOT)).map(ICurioStacksHandler::getCosmeticStacks).ifPresent(cosmetics -> {
                Optional curio = CuriosApi.getCurio((ItemStack)stack);
                for (int slot = 0; slot < cosmetics.getSlots(); ++slot) {
                    SlotContext slotContext = new SlotContext(CuriousArmorStands.SLOT, (LivingEntity)armorStand, slot, true, true);
                    if (!cosmetics.getStackInSlot(slot).isEmpty() || !curio.isEmpty() && !((ICurio)curio.get()).canEquip(slotContext)) continue;
                    cosmetics.setStackInSlot(slot, stack.copy());
                    Events.playEquipSound(curio, slotContext);
                    Events.enableArmorStandArms(armorStand, stack);
                    if (!event.getEntity().isCreative()) {
                        int count = stack.getCount();
                        stack.shrink(count);
                    }
                    event.setCancellationResult(InteractionResult.SUCCESS);
                    event.setCanceled(true);
                    return;
                }
            });
        }

        private static void playEquipSound(Optional<ICurio> curio, SlotContext slotContext) {
            if (curio.isPresent()) {
                ICurio.SoundInfo soundInfo = curio.get().getEquipSound(slotContext);
                slotContext.entity().level().playSound(null, slotContext.entity().blockPosition(), soundInfo.soundEvent(), slotContext.entity().getSoundSource(), soundInfo.volume(), soundInfo.pitch());
            } else {
                slotContext.entity().level().playSound(null, slotContext.entity().blockPosition(), (SoundEvent)SoundEvents.ARMOR_EQUIP_GENERIC.value(), slotContext.entity().getSoundSource(), 1.0f, 1.0f);
            }
        }

        public static void unequipItem(ArmorStand armorStand, PlayerInteractEvent.EntityInteractSpecific event) {
            CuriosApi.getCuriosInventory((LivingEntity)armorStand).flatMap(handler -> handler.getStacksHandler(CuriousArmorStands.SLOT)).ifPresent(stacksHandler -> {
                IDynamicStackHandler cosmetics = stacksHandler.getCosmeticStacks();
                for (int slot = cosmetics.getSlots() - 1; slot >= 0; --slot) {
                    ItemStack stackInSlot = cosmetics.getStackInSlot(slot);
                    if (stackInSlot.isEmpty()) continue;
                    if (!armorStand.level().isClientSide()) {
                        event.getEntity().setItemInHand(event.getHand(), stackInSlot);
                        cosmetics.setStackInSlot(slot, ItemStack.EMPTY);
                    }
                    event.setCancellationResult(InteractionResult.SUCCESS);
                    event.setCanceled(true);
                    return;
                }
            });
        }

        private static void enableArmorStandArms(ArmorStand entity, ItemStack stack) {
            Set slots = CuriosApi.getItemStackSlots((ItemStack)stack, (Level)entity.level()).keySet();
            if (slots.contains("hands") || slots.contains("ring") || slots.contains("bracelet")) {
                entity.setShowArms(true);
            }
        }

        private static boolean canUnequipCurio(Vec3 localPos, ArmorStand entity) {
            double y;
            boolean isSmall = entity.isSmall();
            double d = y = isSmall ? localPos.y * 2.0 : localPos.y;
            return !(entity.hasItemInSlot(EquipmentSlot.FEET) && y >= 0.1 && y < 0.1 + (isSmall ? 0.8 : 0.45) || entity.hasItemInSlot(EquipmentSlot.CHEST) && y >= 0.9 + (isSmall ? 0.3 : 0.0) && y < 0.9 + (isSmall ? 1.0 : 0.7) || entity.hasItemInSlot(EquipmentSlot.LEGS) && y >= 0.4 && y < 0.4 + (isSmall ? 1.0 : 0.8) || entity.hasItemInSlot(EquipmentSlot.HEAD) && y >= 1.6 || entity.hasItemInSlot(EquipmentSlot.MAINHAND) || entity.hasItemInSlot(EquipmentSlot.OFFHAND));
        }
    }

    @EventBusSubscriber(value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD)
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onAddLayers(EntityRenderersEvent.AddLayers event) {
            ResourceLocation strawStatueId = ResourceLocation.fromNamespaceAndPath((String)"strawstatues", (String)"straw_statue");
            if (BuiltInRegistries.ENTITY_TYPE.containsKey(strawStatueId)) {
                ClientModEvents.addLayer(event, (EntityType)BuiltInRegistries.ENTITY_TYPE.get(strawStatueId));
            }
            ClientModEvents.addLayer(event, EntityType.ARMOR_STAND);
        }

        private static void addLayer(EntityRenderersEvent.AddLayers event, EntityType<?> type) {
            EntityRenderer renderer = event.getRenderer(type);
            try {
                if (renderer != null) {
                    ClientModEvents.addLayers((LivingEntityRenderer)ClientModEvents.cast(renderer));
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }

        private static <E extends LivingEntity, M extends HumanoidModel<E>> void addLayers(LivingEntityRenderer<E, M> renderer) {
            renderer.addLayer((RenderLayer)new CuriosLayer(renderer));
            renderer.addLayer(new ArmorStandCuriosDisplayLayer<E, M>(renderer));
        }

        private static <T> T cast(Object object) {
            return (T)object;
        }
    }
}

