/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class PolyBlock
extends Block {
    protected boolean canProvidePower = false;
    private boolean isLightTransparent = false;

    public PolyBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public PolyBlock setLightTransparent() {
        this.isLightTransparent = true;
        return this;
    }

    public float getShadeBrightness(BlockState state, BlockGetter getter, BlockPos pos) {
        return this.isLightTransparent ? 1.0f : super.getShadeBrightness(state, getter, pos);
    }

    public boolean isSignalSource(BlockState state) {
        return this.canProvidePower;
    }

    public static int getRedstonePower(LevelReader world, BlockPos pos, Direction facing) {
        BlockState state = world.getBlockState(pos);
        return state.isRedstoneConductor((BlockGetter)world, pos) ? PolyBlock.getStrongPower(world, pos) : state.getSignal((BlockGetter)world, pos, facing);
    }

    public static int getStrongPower(LevelReader level, BlockPos pos) {
        Direction dir;
        int power = 0;
        Direction[] directionArray = Direction.values();
        int n = directionArray.length;
        for (int i = 0; i < n && (power = Math.max(power, level.getDirectSignal(pos.relative(dir = directionArray[i]), Direction.DOWN))) < 15; ++i) {
        }
        return power;
    }

    public static boolean isBlockPowered(LevelReader world, BlockPos pos) {
        for (Direction dir : Direction.values()) {
            if (PolyBlock.getRedstonePower(world, pos.relative(dir), dir) <= 0) continue;
            return true;
        }
        return false;
    }
}

