/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.client.screen.addon;

import com.hrznstudio.titanium.api.client.AssetTypes;
import com.hrznstudio.titanium.api.client.IAsset;
import com.hrznstudio.titanium.client.screen.addon.BasicScreenAddon;
import com.hrznstudio.titanium.client.screen.asset.IAssetProvider;
import com.hrznstudio.titanium.util.AssetUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class TextFieldScreenAddon
extends BasicScreenAddon {
    private EditBox textFieldWidget;

    public TextFieldScreenAddon(int posX, int posY) {
        super(posX, posY);
        this.textFieldWidget = new EditBox(Minecraft.getInstance().font, posX, posY, 110, 16, (Component)Component.literal((String)""));
    }

    @Override
    public void drawBackgroundLayer(GuiGraphics guiGraphics, Screen screen, IAssetProvider provider, int guiX, int guiY, int mouseX, int mouseY, float partialTicks) {
        AssetUtil.drawAsset(guiGraphics, screen, this.getAsset(provider), this.getPosX() + guiX, this.getPosY() + guiY);
        this.textFieldWidget.renderWidget(guiGraphics, mouseX, mouseY, partialTicks);
    }

    @Override
    public void drawForegroundLayer(GuiGraphics guiGraphics, Screen screen, IAssetProvider provider, int guiX, int guiY, int mouseX, int mouseY, float partialTicks) {
    }

    @Override
    public void init(int guiX, int guiY) {
        String storage = this.textFieldWidget.getValue();
        this.textFieldWidget = new EditBox(Minecraft.getInstance().font, guiX + this.getPosX() + 3, guiY + this.getPosY() + 4, 100, 16, (Component)Component.literal((String)""));
        this.textFieldWidget.setBordered(false);
        this.textFieldWidget.setValue(storage);
    }

    @Override
    public boolean isMouseOver(double mouseX, double mouseY) {
        return false;
    }

    @Override
    public int getXSize() {
        return this.textFieldWidget.getInnerWidth();
    }

    @Override
    public int getYSize() {
        return this.textFieldWidget.getHeight();
    }

    public void setActive(boolean active) {
        this.textFieldWidget.setEditable(active);
    }

    @Override
    public boolean keyPressed(int key, int scan, int modifiers) {
        return this.textFieldWidget.keyPressed(key, scan, modifiers) || this.textFieldWidget.canConsumeInput();
    }

    private IAsset getAsset(IAssetProvider assetProvider) {
        return this.textFieldWidget.isEditable() ? assetProvider.getAsset(AssetTypes.TEXT_FIELD_ACTIVE) : assetProvider.getAsset(AssetTypes.TEXT_FIELD_INACTIVE);
    }

    public GuiEventListener getGuiListener() {
        return this.textFieldWidget;
    }

    public String getText() {
        return this.textFieldWidget.getValue();
    }
}

