/*
 * Decompiled with CFR 0.152.
 */
package mrbysco.constructionstick.stick.supplier;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import mrbysco.constructionstick.ConstructionStick;
import mrbysco.constructionstick.api.IStickSupplier;
import mrbysco.constructionstick.basics.ReplacementRegistry;
import mrbysco.constructionstick.basics.StickUtil;
import mrbysco.constructionstick.basics.option.StickOptions;
import mrbysco.constructionstick.basics.pool.IPool;
import mrbysco.constructionstick.basics.pool.OrderedPool;
import mrbysco.constructionstick.containers.ContainerManager;
import mrbysco.constructionstick.stick.undo.PlaceSnapshot;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class SupplierInventory
implements IStickSupplier {
    protected final Player player;
    protected final StickOptions options;
    protected HashMap<BlockItem, Integer> itemCounts;
    protected IPool<BlockItem> itemPool;

    public SupplierInventory(Player player, StickOptions options) {
        this.player = player;
        this.options = options;
    }

    @Override
    public void getSupply(@Nullable BlockItem target) {
        this.itemCounts = new LinkedHashMap<BlockItem, Integer>();
        ItemStack offhandStack = this.player.getItemInHand(InteractionHand.OFF_HAND);
        this.itemPool = new OrderedPool<BlockItem>();
        if (!offhandStack.isEmpty() && offhandStack.getItem() instanceof BlockItem) {
            this.addBlockItem((BlockItem)offhandStack.getItem());
        } else if (target != null && target != Items.AIR) {
            this.addBlockItem(target);
            if (this.options.match.get() != StickOptions.MATCH.EXACT) {
                for (Item it : ReplacementRegistry.getMatchingSet((Item)target)) {
                    if (!(it instanceof BlockItem)) continue;
                    this.addBlockItem((BlockItem)it);
                }
            }
        }
    }

    protected void addBlockItem(BlockItem item) {
        int count = StickUtil.countItem(this.player, (Item)item);
        if (count > 0) {
            this.itemCounts.put(item, count);
            this.itemPool.add(item);
        }
    }

    @Override
    @Nullable
    public PlaceSnapshot getPlaceSnapshot(Level level, BlockPos pos, BlockHitResult blockHitResult, @Nullable BlockState supportingBlock) {
        PlaceSnapshot placeSnapshot;
        BlockItem item;
        int count;
        if (!StickUtil.isPositionPlaceable(level, this.player, pos, this.options.replace.get())) {
            return null;
        }
        this.itemPool.reset();
        do {
            if ((item = this.itemPool.draw()) != null) continue;
            return null;
        } while ((count = this.itemCounts.get(item).intValue()) == 0 || (placeSnapshot = PlaceSnapshot.get(level, this.player, blockHitResult, pos, item, supportingBlock, this.options)) == null);
        int ncount = count - 1;
        this.itemCounts.put(item, ncount);
        if (ncount == 0) {
            this.itemPool.remove(item);
        }
        return placeSnapshot;
    }

    @Override
    public int takeItemStack(ItemStack stack) {
        int count = stack.getCount();
        Item item = stack.getItem();
        if (this.player.getInventory().items == null) {
            return count;
        }
        if (this.player.isCreative()) {
            return 0;
        }
        List<ItemStack> hotbar = StickUtil.getHotbarWithOffhand(this.player);
        List<ItemStack> mainInv = StickUtil.getMainInv(this.player);
        count = this.takeItemsInvList(count, item, mainInv, false);
        count = this.takeItemsInvList(count, item, mainInv, true);
        count = this.takeItemsInvList(count, item, hotbar, true);
        count = this.takeItemsInvList(count, item, hotbar, false);
        return count;
    }

    private int takeItemsInvList(int count, Item item, List<ItemStack> inv, boolean container) {
        ContainerManager containerManager = ConstructionStick.containerManager;
        for (ItemStack stack : inv) {
            if (count == 0) break;
            if (container) {
                count = containerManager.useItems(this.player, new ItemStack((ItemLike)item), stack, count);
            }
            if (container || !StickUtil.stackEquals(stack, item)) continue;
            int toTake = Math.min(count, stack.getCount());
            stack.shrink(toTake);
            count -= toTake;
            this.player.getInventory().setChanged();
        }
        return count;
    }
}

