/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.modules.neoforge.tropicraft;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.function.Consumer;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceGenTask;
import net.mehvahdjukaar.moonlight.api.set.wood.VanillaWoodTypes;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.tropicraft.core.common.block.BoardwalkBlock;

public class TropicraftModule
extends SimpleModule {
    public final SimpleEntrySet<WoodType, Block> boardwalks = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "boardwalk", this.getModBlock("mangrove_boardwalk"), () -> VanillaWoodTypes.MANGROVE, w -> new BoardwalkBlock(BlockBehaviour.Properties.of().noOcclusion())).requiresChildren(new String[]{"slab"})).addModelTransform(m -> m.replaceWithTextureFromChild("tropicraft:block/mangrove_planks", "planks"))).addTag(BlockTags.MINEABLE_WITH_AXE, Registries.BLOCK)).setTabKey(this.modRes("tropicraft"))).build();

    public TropicraftModule(String modId) {
        super(modId, "tc");
        this.addEntry(this.boardwalks);
    }

    @Override
    public void addDynamicServerResources(Consumer<ResourceGenTask> executor) {
        ResourceLocation recipePath = this.modRes("mangrove_boardwalk");
        executor.accept((manager, sink) -> this.boardwalks.blocks.forEach((wood, block) -> {
            try (InputStream recipeStream = ((Resource)manager.getResource(ResType.RECIPES.getPath(recipePath)).orElseThrow(() -> new FileNotFoundException("Failed to open the recipe @ " + String.valueOf(recipePath)))).open();){
                JsonObject recipe = RPUtils.deserializeJson((InputStream)recipeStream);
                JsonObject underKey = recipe.getAsJsonObject("key").getAsJsonObject("X");
                underKey.addProperty("item", Utils.getID((Block)Objects.requireNonNull(wood.getBlockOfThis("slab"))).toString());
                recipe.getAsJsonObject("result").addProperty("id", Utils.getID((Block)block).toString());
                String newPath = this.shortenedId() + "/" + wood.getAppendableId() + "_boardwalk";
                sink.addJson(EveryCompat.res(newPath), (JsonElement)recipe, ResType.RECIPES);
            }
            catch (IOException e) {
                EveryCompat.LOGGER.error("Failed to generate the boardwalk recipe for {}: {}", (Object)wood.getId(), (Object)e);
            }
        }));
    }
}

