/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.modules.lieonlion;

import java.util.function.Consumer;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.every_compat.common_classes.CompatChestBlock;
import net.mehvahdjukaar.every_compat.common_classes.CompatChestBlockEntity;
import net.mehvahdjukaar.every_compat.common_classes.CompatChestBlockRenderer;
import net.mehvahdjukaar.every_compat.common_classes.CompatChestTexture;
import net.mehvahdjukaar.every_compat.common_classes.CompatTrappedChestBlock;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceGenTask;
import net.mehvahdjukaar.moonlight.api.set.wood.VanillaWoodTypes;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class MoreChestVariantsModule
extends SimpleModule {
    public final SimpleEntrySet<WoodType, Block> chests;
    public final SimpleEntrySet<WoodType, Block> trappedChests;

    public MoreChestVariantsModule(String modID) {
        super(modID, "mcv", "everycomp");
        ResourceKey functionalTab = CreativeModeTabs.FUNCTIONAL_BLOCKS;
        ResourceKey redstoneTab = CreativeModeTabs.REDSTONE_BLOCKS;
        this.chests = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "chest", this.getModBlock("oak_chest"), () -> VanillaWoodTypes.OAK, w -> new CompatChestBlock(this::getChestTile, Utils.copyPropertySafe((Block)Blocks.CHEST).mapColor(MapColor.WOOD))).addModelTransform(m -> m.addModifier((s, blockId, woodType) -> s.replace("\"lolmcv:entity/chest/oak\"", "\"" + woodType.createFullIdWith("everycomp", "entity/chest", this.shortenedId(), "", "chest") + "\"")))).addTile((x$0, x$1) -> new MoreChestBlockEntity(this, (BlockPos)x$0, (BlockState)x$1)).addTag(BlockTags.MINEABLE_WITH_AXE, Registries.BLOCK)).addTag(BlockTags.GUARDED_BY_PIGLINS, Registries.BLOCK)).addTag(ResourceLocation.parse((String)"lieonstudio:chests/wooden"), new ResourceKey[]{Registries.BLOCK, Registries.ITEM})).addTag(ResourceLocation.parse((String)"lieonstudio:chests/normal"), new ResourceKey[]{Registries.BLOCK, Registries.ITEM})).addTag(ResourceLocation.parse((String)"quad:cats_on_blocks/sit"), Registries.BLOCK)).addTag(ResourceLocation.parse((String)"quad:fuel/wood"), Registries.ITEM)).setTabKey(functionalTab)).defaultRecipe().build();
        this.addEntry(this.chests);
        this.trappedChests = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "trapped_chest", this.getModBlock("oak_trapped_chest"), () -> VanillaWoodTypes.OAK, w -> new CompatTrappedChestBlock(this::getTrappedTile, Utils.copyPropertySafe((Block)Blocks.TRAPPED_CHEST).mapColor(MapColor.WOOD))).addModelTransform(m -> m.addModifier((s, blockId, woodType) -> s.replace("\"lolmcv:entity/chest/trapped/oak\"", "\"" + woodType.createFullIdWith("everycomp", "entity/chest", this.shortenedId(), "", "trapped_chest") + "\"")))).addTile((x$0, x$1) -> new MoreTrappedBlockEntity(this, (BlockPos)x$0, (BlockState)x$1)).addTag(BlockTags.MINEABLE_WITH_AXE, Registries.BLOCK)).addTag(BlockTags.GUARDED_BY_PIGLINS, Registries.BLOCK)).addTag(ResourceLocation.parse((String)"lieonstudio:chests/wooden"), new ResourceKey[]{Registries.BLOCK, Registries.ITEM})).addTag(ResourceLocation.parse((String)"lieonstudio:chests/trapped"), new ResourceKey[]{Registries.BLOCK, Registries.ITEM})).addTag(ResourceLocation.parse((String)"quad:fuel/wood"), Registries.ITEM)).setTabKey(redstoneTab)).defaultRecipe().build();
        this.addEntry(this.trappedChests);
    }

    private BlockEntityType<? extends ChestBlockEntity> getChestTile() {
        return this.chests.getTile(CompatChestBlockEntity.class);
    }

    private BlockEntityType<? extends ChestBlockEntity> getTrappedTile() {
        return this.trappedChests.getTile(CompatChestBlockEntity.class);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void registerBlockEntityRenderers(ClientHelper.BlockEntityRendererEvent event) {
        super.registerBlockEntityRenderers(event);
        CompatChestBlockRenderer.register(event, this.chests.getTile(CompatChestBlockEntity.class), this.shortenedId());
        CompatChestBlockRenderer.register(event, this.trappedChests.getTile(CompatChestBlockEntity.class), this.shortenedId());
    }

    @Override
    public void addDynamicClientResources(Consumer<ResourceGenTask> executor) {
        super.addDynamicClientResources(executor);
        executor.accept((manager, sink) -> this.trappedChests.blocks.forEach((wood, block) -> {
            CompatChestTexture.generateChestTexture(sink, manager, this.shortenedId(), wood, block, this.modRes("entity/chest/oak"), EveryCompat.res("entity/mcv_chest_normal_m"), EveryCompat.res("entity/mcv_chest_normal_o"), EveryCompat.res("entity/mcv_trapped_normal_o"), 0);
            CompatChestTexture.generateChestTexture(sink, manager, this.shortenedId(), wood, block, this.modRes("entity/chest/oak_left"), EveryCompat.res("entity/mcv_chest_left_m"), EveryCompat.res("entity/mcv_chest_left_o"), EveryCompat.res("entity/mcv_trapped_left_o"), 0);
            CompatChestTexture.generateChestTexture(sink, manager, this.shortenedId(), wood, block, this.modRes("entity/chest/oak_right"), EveryCompat.res("entity/mcv_chest_right_m"), EveryCompat.res("entity/mcv_chest_right_o"), EveryCompat.res("entity/mcv_trapped_right_o"), 0);
        }));
    }

    private class MoreTrappedBlockEntity
    extends CompatChestBlockEntity {
        public MoreTrappedBlockEntity(MoreChestVariantsModule moreChestVariantsModule, BlockPos pos, BlockState state) {
            super(moreChestVariantsModule.trappedChests.getTile(), pos, state);
        }
    }

    private class MoreChestBlockEntity
    extends CompatChestBlockEntity {
        public MoreChestBlockEntity(MoreChestVariantsModule moreChestVariantsModule, BlockPos pos, BlockState state) {
            super(moreChestVariantsModule.chests.getTile(), pos, state);
        }
    }
}

