/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.misc;

import java.util.Map;
import java.util.Objects;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class UtilityMisc {
    public static boolean doChildrenExistFor(BlockType blockType, String ... blockTypes) {
        for (String type : blockTypes) {
            if (!Objects.isNull(blockType.getBlockOfThis(type))) continue;
            return false;
        }
        return true;
    }

    public static boolean doChildrenExistFor(BlockType blockType, SimpleEntrySet<?, ?> entrySet) {
        return Objects.nonNull(entrySet.blocks.get(blockType));
    }

    public static Block getChildrenBlockSafe(String childkey, BlockType blockType) {
        Block block = blockType.getBlockOfThis(childkey);
        Block blockAlt = null;
        if (childkey.contains("_")) {
            String[] split = childkey.split("_");
            blockAlt = blockType.getBlockOfThis(split[split.length - 1]);
        }
        if (Objects.nonNull(block)) {
            return block;
        }
        if (Objects.nonNull(blockAlt)) {
            return blockAlt;
        }
        return (Block)blockType.mainChild();
    }

    public static BlockBehaviour.Properties copyChildrenPropertySafe(String childKey, BlockType blockType) {
        return Utils.copyPropertySafe((Block)UtilityMisc.getChildrenBlockSafe(childKey, blockType));
    }

    public static BlockState copyBlockStateSafe(String childkey, BlockType blockType) {
        return UtilityMisc.getChildrenBlockSafe(childkey, blockType).defaultBlockState();
    }

    public static BlockState copyBlockStateSafe(Map<?, Block> blocks, BlockType blockType) {
        if (Objects.nonNull(blocks.get(blockType))) {
            return blocks.get(blockType).defaultBlockState();
        }
        return ((Block)blockType.mainChild()).defaultBlockState();
    }
}

