/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.dynamicpack;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.api.PaletteStrategies;
import net.mehvahdjukaar.every_compat.configs.ECConfigs;
import net.mehvahdjukaar.every_compat.misc.CompatSpritesHelper;
import net.mehvahdjukaar.moonlight.api.events.AfterLanguageLoadEvent;
import net.mehvahdjukaar.moonlight.api.misc.IProgressTracker;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicClientResourceProvider;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceGenTask;
import net.minecraft.server.packs.resources.ResourceManager;

public class ClientDynamicResourcesHandler
extends DynamicClientResourceProvider {
    private static ClientDynamicResourcesHandler INSTANCE;
    private boolean firstInit = false;

    public static ClientDynamicResourcesHandler getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ClientDynamicResourcesHandler();
        }
        return INSTANCE;
    }

    public ClientDynamicResourcesHandler() {
        super(EveryCompat.res("dynamic_resources"), ECConfigs.CLIENT_GENERATION_MODE.get().pickStrategy());
    }

    public void addDynamicTranslations(AfterLanguageLoadEvent lang) {
        EveryCompat.forAllModules(m -> m.addTranslations(this, lang));
    }

    protected Collection<String> gatherSupportedNamespaces() {
        return List.of("minecraft", "quark");
    }

    public void reload(ResourceManager manager, IProgressTracker reporter) {
        if (!this.firstInit) {
            CompatSpritesHelper.addHardcodedSprites();
            this.firstInit = true;
        }
        super.reload(manager, reporter);
    }

    public boolean canUseExternalResourcePacks() {
        return ECConfigs.SPEC != null && ECConfigs.USE_EXTERNAL_RESOURCE_PACK.get() != false;
    }

    public void regenerateDynamicAssets(Consumer<ResourceGenTask> executor) {
        PaletteStrategies.clearCache();
        ArrayList tasks = new ArrayList();
        EveryCompat.forAllModules(m -> m.addDynamicClientResources(tasks::add));
        int minBatches = Runtime.getRuntime().availableProcessors();
        int maxBatches = tasks.size() / Runtime.getRuntime().availableProcessors();
        int batchSize = Math.max(minBatches, maxBatches);
        EveryCompat.LOGGER.info("Starting dynamic resources generation tasks: {} in batches of {}", (Object)tasks.size(), (Object)batchSize);
        for (int i = 0; i < tasks.size(); i += batchSize) {
            int end = Math.min(i + batchSize, tasks.size());
            List subList = tasks.subList(i, end);
            executor.accept((resourceManager, resourceSink) -> {
                for (ResourceGenTask subtask : subList) {
                    subtask.accept(resourceManager, resourceSink);
                }
            });
        }
    }
}

