/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.configs;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.moonlight.api.platform.configs.ConfigBuilder;
import net.mehvahdjukaar.moonlight.api.platform.configs.ConfigType;
import net.mehvahdjukaar.moonlight.api.platform.configs.ModConfigHolder;
import net.mehvahdjukaar.moonlight.api.set.BlockSetAPI;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.BlockTypeRegistry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class ModEntriesConfigs {
    private static final Map<Class<? extends BlockType>, Map<String, Supplier<Boolean>>> BLOCK_TYPE_CONFIGS = new HashMap<Class<? extends BlockType>, Map<String, Supplier<Boolean>>>();
    private static final Map<Class<? extends BlockType>, Map<String, Supplier<Boolean>>> CHILD_CONFIGS = new HashMap<Class<? extends BlockType>, Map<String, Supplier<Boolean>>>();
    public static ModConfigHolder SPEC;
    private static boolean wasInit;

    public static void initEarlyButNotSuperEarly() {
        Map map;
        Supplier config;
        String key;
        if (wasInit) {
            return;
        }
        wasInit = true;
        ConfigBuilder builder = ConfigBuilder.create((ResourceLocation)EveryCompat.res("entries"), (ConfigType)ConfigType.COMMON);
        builder.comment("Disables certain types. Note that all these configs, like in any other mod, only hide stuff from tabs and disable their recipes").push("types");
        for (BlockTypeRegistry reg : BlockSetAPI.getRegistries()) {
            builder.push(reg.typeName().replace(" ", "_"));
            for (BlockType w : reg.getValues()) {
                if (w.isVanilla()) continue;
                key = w.toString().replace(":", ".");
                config = builder.define(key, true);
                map = BLOCK_TYPE_CONFIGS.computeIfAbsent(reg.getType(), s -> new HashMap());
                map.put(w.toString(), config);
            }
            builder.pop();
        }
        builder.pop();
        builder.comment("Disables specific entries").push("entries");
        for (BlockTypeRegistry reg : BlockSetAPI.getRegistries()) {
            builder.push(reg.typeName().replace(" ", "_"));
            for (String c : EveryCompat.getChildKeys(reg.getType())) {
                key = c.replace(":", ".");
                config = builder.define(key, true);
                map = CHILD_CONFIGS.computeIfAbsent(reg.getType(), s -> new HashMap());
                map.put(c, config);
            }
            builder.pop();
        }
        builder.pop();
        SPEC = builder.build();
        SPEC.forceLoad();
    }

    public static <T extends BlockType> boolean isEntryEnabled(T blockType, Object o) {
        if (o instanceof BlockItem) {
            BlockItem bi = (BlockItem)o;
            o = bi.getBlock();
        }
        return ModEntriesConfigs.isTypeEnabled(blockType, blockType.getChildKey(o));
    }

    public static <T extends BlockType> boolean isEntryEnabled(Class<T> typeClass, Object o) {
        if (o instanceof BlockItem) {
            BlockItem bi = (BlockItem)o;
            o = bi.getBlock();
        }
        BlockType blockType = BlockSetAPI.getBlockTypeOf((ItemLike)((ItemLike)o), typeClass);
        return ModEntriesConfigs.isTypeEnabled(blockType, blockType.getChildKey(o));
    }

    public static <T extends BlockType> boolean isTypeEnabled(T w) {
        return ModEntriesConfigs.isTypeEnabled(w, null);
    }

    public static <T extends BlockType> boolean isTypeEnabled(T blockType, @Nullable String childType) {
        Class<?> typeClass;
        Map<String, Supplier<Boolean>> childConfigs;
        if (!wasInit) {
            ModEntriesConfigs.initEarlyButNotSuperEarly();
        }
        if ((childConfigs = CHILD_CONFIGS.get(typeClass = blockType.getClass())) == null) {
            EveryCompat.LOGGER.warn("No config map found for block type: {}", (Object)typeClass.getName());
            return true;
        }
        if (childType != null && !childConfigs.getOrDefault(childType, () -> true).get().booleanValue()) {
            return false;
        }
        Map<String, Supplier<Boolean>> blocktypeConfigs = BLOCK_TYPE_CONFIGS.get(typeClass);
        if (blocktypeConfigs == null) {
            EveryCompat.LOGGER.warn("No config map found for block type: {}", (Object)typeClass.getName());
            return true;
        }
        Supplier<Boolean> booleanSupplier = blocktypeConfigs.get(blockType.getId().toString());
        if (booleanSupplier != null) {
            return booleanSupplier.get();
        }
        return true;
    }

    static {
        wasInit = false;
    }
}

