/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.common_classes;

import net.mehvahdjukaar.every_compat.common_classes.CompatTrappedChestBlock;
import net.mehvahdjukaar.moonlight.api.set.wood.VanillaWoodTypes;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class CompatChestBlockEntity
extends ChestBlockEntity {
    private final WoodType woodType;
    private final boolean trapped;

    public CompatChestBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state) {
        super(blockEntityType, pos, state);
        WoodType w = (WoodType)WoodTypeRegistry.INSTANCE.getBlockTypeOf((ItemLike)state.getBlock());
        this.woodType = w == null ? VanillaWoodTypes.OAK : w;
        this.trapped = state.getBlock() instanceof CompatTrappedChestBlock;
    }

    public WoodType getWoodType() {
        return this.woodType;
    }

    protected void signalOpenCount(Level level, BlockPos pos, BlockState state, int eventId, int eventParam) {
        super.signalOpenCount(level, pos, state, eventId, eventParam);
        if (this.trapped && eventId != eventParam) {
            Block block = state.getBlock();
            level.updateNeighborsAt(pos, block);
            level.updateNeighborsAt(pos.below(), block);
        }
    }

    public boolean isTrapped() {
        return this.trapped;
    }

    @NotNull
    protected Component getDefaultName() {
        return Component.translatable((String)"container.everycomp.chest.name", (Object[])new Object[]{Component.translatable((String)this.woodType.getTranslationKey()).getString()});
    }
}

