/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.api;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.mehvahdjukaar.every_compat.api.AbstractSimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.PaletteStrategy;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.every_compat.api.TabAddMode;
import net.mehvahdjukaar.every_compat.misc.ModelConfiguration;
import net.mehvahdjukaar.every_compat.misc.ResourcesUtils;
import net.mehvahdjukaar.moonlight.api.events.AfterLanguageLoadEvent;
import net.mehvahdjukaar.moonlight.api.misc.Registrator;
import net.mehvahdjukaar.moonlight.api.resources.BlockTypeResTransformer;
import net.mehvahdjukaar.moonlight.api.resources.assets.LangBuilder;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceSink;
import net.mehvahdjukaar.moonlight.api.set.BlockSetAPI;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.BlockTypeRegistry;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import org.jetbrains.annotations.Nullable;

public class ItemOnlyEntrySet<T extends BlockType, I extends Item>
extends AbstractSimpleEntrySet<T, Block, I> {
    protected final Supplier<@Nullable I> baseItem;
    protected final Function<T, @Nullable I> itemFactory;
    protected ModelConfiguration modelConfig;

    @Deprecated(forRemoval=true)
    public ItemOnlyEntrySet(Class<T> type, String name, @Nullable String prefix, Function<T, I> itemFactory, Supplier<@Nullable I> baseItem, Supplier<T> baseType, @Nullable Supplier<ResourceKey<CreativeModeTab>> tab, TabAddMode tabMode, @Nullable BiFunction<T, ResourceManager, PaletteStrategy.PaletteAndAnimation> paletteSupplier, @Nullable Consumer<BlockTypeResTransformer<T>> extraTransform, boolean mergedPalette, boolean copyTint, Predicate<T> condition) {
        this(type, name, prefix, itemFactory, baseItem, baseType, tab, tabMode, paletteSupplier, extraTransform, mergedPalette, copyTint, condition, ModelConfiguration.EMPTY);
    }

    public ItemOnlyEntrySet(Class<T> type, String name, @Nullable String prefix, Function<T, I> itemFactory, Supplier<@Nullable I> baseItem, Supplier<T> baseType, @Nullable Supplier<ResourceKey<CreativeModeTab>> tab, TabAddMode tabMode, @Nullable BiFunction<T, ResourceManager, PaletteStrategy.PaletteAndAnimation> paletteSupplier, @Nullable Consumer<BlockTypeResTransformer<T>> extraTransform, boolean mergedPalette, boolean copyTint, Predicate<T> condition, ModelConfiguration modelConfig) {
        super(type, name, prefix, baseType, tab, tabMode, paletteSupplier, extraTransform, mergedPalette, copyTint, condition);
        this.itemFactory = itemFactory;
        this.baseItem = baseItem;
        this.modelConfig = modelConfig;
    }

    public I getBaseItem() {
        return (I)((Item)this.baseItem.get());
    }

    @Override
    public void addTranslations(SimpleModule module, AfterLanguageLoadEvent lang) {
        this.items.forEach((blockType, item) -> LangBuilder.addDynamicEntry((AfterLanguageLoadEvent)lang, (String)("item_type." + module.getModId() + "." + this.typeName), (BlockType)blockType, (Item)item));
    }

    @Override
    public void registerBlocks(SimpleModule module, Registrator<Block> registry, Collection<T> woodTypes) {
    }

    @Deprecated(forRemoval=true)
    public String getItemName(T w) {
        return this.makeEntryName(w);
    }

    @Override
    public void registerItems(SimpleModule module, Registrator<Item> registry) {
        BlockTypeRegistry typeRegistry = BlockSetAPI.getTypeRegistry((Class)this.type);
        for (BlockType blockType : Objects.requireNonNull(typeRegistry).getValues()) {
            Item item;
            ResourceLocation id;
            String childKey = this.makeChildKey(module);
            if (childKey.contains("minecraft")) {
                childKey = childKey.replace("minecraft:", "");
            }
            if (module.isEntryAlreadyRegistered(childKey, id = this.makeFullEntryID(module, blockType), blockType, (Registry<?>)BuiltInRegistries.ITEM) || !this.condition.test(blockType) || (item = (Item)this.itemFactory.apply(blockType)) == null) continue;
            try {
                Preconditions.checkArgument((item != Items.AIR ? 1 : 0) != 0, (Object)"Item factory returned AIR item instance");
                registry.register(id, (Object)item);
                this.items.put(blockType, item);
                blockType.addChild(childKey, (Object)item);
            }
            catch (Exception e) {
                throw new UnsupportedOperationException("Failed to create or register item of " + blockType.getTranslationKey() + " with an EntrySetId: " + childKey + ". ERROR: " + String.valueOf(e));
            }
        }
    }

    @Override
    public void registerTiles(SimpleModule module, Registrator<BlockEntityType<?>> registry) {
        I base = this.getBaseItem();
        if (base == null || base == Items.AIR) {
            throw new UnsupportedOperationException("Base Item cant be null (" + this.typeName + " for " + module.modId + " module)");
        }
        String childKey = this.makeChildKey(module);
        if (childKey.contains("minecraft")) {
            childKey = childKey.replace("minecraft:", "");
        }
        ((BlockType)this.baseType.get()).addChild(childKey, base);
        HashSet<String> alreadySupportedMods = new HashSet<String>(module.getAlreadySupportedMods());
        alreadySupportedMods.add(module.modId);
        String[] possibleNamespaces = (String[])alreadySupportedMods.toArray(String[]::new);
        for (BlockType w : Objects.requireNonNull(BlockSetAPI.getTypeRegistry(this.getTypeClass())).getValues()) {
            if (this.items.containsKey(w)) continue;
            String path = this.getItemName(w);
            Item item = ItemOnlyEntrySet.getOptionalItem(path, w.getNamespace());
            if (item == null) {
                item = ItemOnlyEntrySet.getOptionalItem(path, possibleNamespaces);
            }
            if (item == null) continue;
            w.addChild(childKey, (Object)item);
        }
    }

    @Nullable
    private static Item getOptionalItem(String path, String ... namespaces) {
        for (String n : namespaces) {
            ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)n, (String)path);
            Optional i = BuiltInRegistries.ITEM.getOptional(id);
            if (!i.isPresent()) continue;
            return (Item)i.get();
        }
        return null;
    }

    @Override
    public void setRenderLayer() {
    }

    @Override
    public void generateLootTables(SimpleModule module, ResourceManager manager, ResourceSink sink) {
    }

    @Override
    public void generateModels(SimpleModule module, ResourceManager manager, ResourceSink handler) {
        ResourcesUtils.generateStandardItemModels(manager, handler, this.items, (BlockType)this.baseType.get(), this.makeModelTransformer(module, manager), this.modelConfig);
    }

    protected BlockTypeResTransformer<T> makeModelTransformer(SimpleModule module, ResourceManager manager) {
        BlockTypeResTransformer modelTransformer = BlockTypeResTransformer.create((String)module.modId, (ResourceManager)manager);
        if (this.extraModelTransform != null) {
            this.extraModelTransform.accept(modelTransformer);
        }
        ResourcesUtils.addBuiltinModelTransformer(modelTransformer, (BlockType)this.baseType.get());
        return modelTransformer;
    }

    @Override
    public Map<T, ?> getDefaultEntries() {
        return this.items;
    }

    public static <T extends BlockType, I extends Item> Builder<T, I> builder(Class<T> type, String name, Supplier<I> baseItem, Supplier<T> baseType, Function<T, I> itemSupplier) {
        return new Builder<T, I>(type, name, null, baseType, baseItem, itemSupplier);
    }

    public static <T extends BlockType, I extends Item> Builder<T, I> builder(Class<T> type, String name, String prefix, Supplier<I> baseItem, Supplier<T> baseType, Function<T, I> itemSupplier) {
        return new Builder<T, I>(type, name, prefix, baseType, baseItem, itemSupplier);
    }

    public static class Builder<T extends BlockType, I extends Item>
    extends AbstractSimpleEntrySet.Builder<Builder<T, I>, T, Block, I> {
        protected final Supplier<@Nullable I> baseItem;
        protected final Function<T, I> itemFactory;
        protected ModelConfiguration modelConfig = ModelConfiguration.EMPTY;

        protected Builder(Class<T> type, String name, @Nullable String prefix, Supplier<T> baseType, Supplier<I> baseItem, Function<T, I> itemFactory) {
            super(type, name, prefix, baseType);
            this.baseItem = baseItem;
            this.itemFactory = itemFactory;
        }

        public ItemOnlyEntrySet<T, I> build() {
            ItemOnlyEntrySet<T, I> e = new ItemOnlyEntrySet<T, I>(this.type, this.name, this.prefix, this.itemFactory, this.baseItem, this.baseType, this.tab, this.tabMode, this.palette, this.extraModelTransform, this.useMergedPalette, this.copyTint, this.condition, this.modelConfig);
            e.recipeLocations.addAll(this.recipes);
            e.tags.putAll(this.tags);
            e.textures.addAll(this.textures);
            return e;
        }

        public Builder<T, I> defaultRecipe() {
            this.recipes.add(() -> Utils.getID((Item)Objects.requireNonNull((Item)this.baseItem.get())));
            return this;
        }

        public Builder<T, I> generateBlockModels(ResourceLocation ... blockModels) {
            if (this.modelConfig == ModelConfiguration.EMPTY) {
                this.modelConfig = ModelConfiguration.createNew();
            }
            this.modelConfig.addBlockModel(blockModels);
            return this;
        }

        public Builder<T, I> generateItemModels(ResourceLocation ... itemModels) {
            if (this.modelConfig == ModelConfiguration.EMPTY) {
                this.modelConfig = ModelConfiguration.createNew();
            }
            this.modelConfig.addItemModel(itemModels);
            return this;
        }
    }
}

