/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.api;

import com.google.common.base.Suppliers;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.mehvahdjukaar.every_compat.ECRegistry;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.dynamicpack.ClientDynamicResourcesHandler;
import net.mehvahdjukaar.moonlight.api.events.AfterLanguageLoadEvent;
import net.mehvahdjukaar.moonlight.api.misc.Registrator;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceGenTask;
import net.mehvahdjukaar.moonlight.api.set.BlockSetAPI;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public abstract class CompatModule {
    protected final String modId;
    protected final String modName;
    protected final String shortId;
    private final String myNamespace;

    @Deprecated(forRemoval=true)
    protected CompatModule(String modId, String myNamespace) {
        this(modId, modId, myNamespace);
    }

    protected CompatModule(String modId, String shortId, String myNamespace) {
        this.modId = modId;
        this.modName = PlatHelper.getModName((String)modId);
        this.myNamespace = myNamespace;
        this.shortId = shortId;
        if (myNamespace.equals("minecraft")) {
            throw new AssertionError((Object)"Every Compat module namespace cannot be minecraft");
        }
        BlockSetAPI.addDynamicRegistration((String)myNamespace, r -> EveryCompat.executeOrFail(() -> {
            for (Class<? extends BlockType> t : this.getAffectedTypes()) {
                this.registerBlocks(t, (Registrator<Block>)r);
            }
        }, this), (Registry)BuiltInRegistries.BLOCK);
        BlockSetAPI.addDynamicRegistration((String)myNamespace, r -> EveryCompat.executeOrFail(() -> this.registerItems((Registrator<Item>)((Registrator)(resourceLocation, item) -> {
            r.register(resourceLocation, item);
            EveryCompat.addItemToModuleMapping(item, this);
        })), this), (Registry)BuiltInRegistries.ITEM);
        BlockSetAPI.addDynamicRegistration((String)myNamespace, r -> EveryCompat.executeOrFail(() -> this.registerTiles((Registrator<BlockEntityType<?>>)r), this), (Registry)BuiltInRegistries.BLOCK_ENTITY_TYPE);
        BlockSetAPI.addDynamicRegistration((String)myNamespace, r -> EveryCompat.executeOrFail(() -> this.registerEntities((Registrator<EntityType<?>>)r), this), (Registry)BuiltInRegistries.ENTITY_TYPE);
    }

    public final String getModId() {
        return this.modId;
    }

    public final String getMyNamespace() {
        return this.myNamespace;
    }

    public final String getModName() {
        return this.modName;
    }

    public String shortenedId() {
        return this.shortId;
    }

    public String toString() {
        return "module[ " + this.getModName() + " @ " + this.getMyNamespace() + " ]";
    }

    public ResourceLocation modRes(String string) {
        return ResourceLocation.fromNamespaceAndPath((String)this.modId, (String)string);
    }

    public List<String> getAlreadySupportedMods() {
        return List.of();
    }

    public void onModInit() {
    }

    public void onModSetup() {
    }

    public void onClientInit() {
    }

    public void onClientSetup() {
    }

    private <T extends BlockType> void registerBlocks(Class<T> type, Registrator<Block> registry) {
        this.registerBlocks(type, registry, BlockSetAPI.getBlockSet(type).getValues());
    }

    public <T extends BlockType> void registerBlocks(Class<T> typeClass, Registrator<Block> registry, Collection<T> types) {
    }

    public void registerItems(Registrator<Item> registry) {
    }

    public void registerTiles(Registrator<BlockEntityType<?>> registry) {
    }

    public void registerEntities(Registrator<EntityType<?>> registry) {
    }

    public void addDynamicServerResources(Consumer<ResourceGenTask> executor) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void addDynamicClientResources(Consumer<ResourceGenTask> executor) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void registerBlockEntityRenderers(ClientHelper.BlockEntityRendererEvent event) {
    }

    public void addTranslations(ClientDynamicResourcesHandler clientDynamicResourcesHandler, AfterLanguageLoadEvent lang) {
    }

    public void registerBlockColors(ClientHelper.BlockColorEvent event) {
    }

    public void registerItemColors(ClientHelper.ItemColorEvent event) {
    }

    public void registerItemsToExistingTabs(RegHelper.ItemToTabEvent event) {
    }

    protected final <T extends Block> Supplier<T> getModBlock(String id, Class<T> blockClass) {
        return this.memorize(id, (Registry<?>)BuiltInRegistries.BLOCK);
    }

    @Deprecated(forRemoval=true)
    protected final Supplier<CreativeModeTab> getModTab(String id) {
        return this.memorize(id, BuiltInRegistries.CREATIVE_MODE_TAB);
    }

    protected final Supplier<Block> getModBlock(String id) {
        return this.getModBlock(id, Block.class);
    }

    protected final Supplier<Item> getModItem(String id) {
        return this.memorize(id, (Registry<?>)BuiltInRegistries.ITEM);
    }

    protected final <B extends BlockEntity> Supplier<BlockEntityType<B>> getModTile(String id, Class<B> tileEntityClass) {
        return this.memorize(id, BuiltInRegistries.BLOCK_ENTITY_TYPE);
    }

    protected final Supplier<BlockEntityType<BlockEntity>> getModTile(String id) {
        return this.getModTile(id, BlockEntity.class);
    }

    public abstract int bloatAmount();

    public <T extends BlockType> List<Item> getAllItemsOfType(T type) {
        return List.of();
    }

    public <T> Supplier<T> memorize(String id, Registry<?> reg) {
        return Suppliers.memoize(() -> {
            try {
                return reg.getOptional(this.modRes(id)).orElseThrow();
            }
            catch (Throwable e) {
                throw new IllegalStateException("Could not find \"" + id + "\" in " + String.valueOf(reg) + ". This likely means that the reigstry entry was renamed in the original mod and EC needs updating. Is the mod, " + this.getModName().toUpperCase() + " up to date, if yes, then downgrade to the previous version & wait for an Every Compat update. Otherwise, update the mod to the latest version.");
            }
        });
    }

    public ResourceKey<CreativeModeTab> getDedicatedTab() {
        return ECRegistry.MOD_TAB.getKey();
    }

    public abstract Collection<Class<? extends BlockType>> getAffectedTypes();

    public String[] getServerResourcesNamespaces() {
        return new String[]{this.modId, this.myNamespace};
    }

    public String[] getClientResourcesNamespaces() {
        return new String[]{this.myNamespace};
    }
}

