/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.replication_rs2_bridge.storage;

import com.leclowndu93150.replication_rs2_bridge.block.entity.task.model.ItemWithSourceId;
import com.leclowndu93150.replication_rs2_bridge.block.entity.task.model.TaskSourceInfo;
import com.refinedmods.refinedstorage.api.autocrafting.task.TaskId;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.NotNull;

public class BridgeTaskHandlerRepository
extends SavedData {
    public static final String NAME = "replication_rs2_bridge_task_handler";
    private static final String TAG_BRIDGES = "Bridges";
    private static final String TAG_BRIDGE_ID = "BridgeId";
    private static final String TAG_REQUEST_COUNTERS = "RequestCounters";
    private static final String TAG_PATTERN_REQUESTS = "PatternRequests";
    private static final String TAG_PATTERN_REQUESTS_BY_SOURCE = "PatternRequestsBySource";
    private static final String TAG_ACTIVE_TASKS = "ActiveTasks";
    private static final String TAG_ALLOCATED_MATTER = "AllocatedMatter";
    private static final String TAG_TASK_ID = "TaskId";
    private static final String TAG_MATTER = "Matter";
    private static final String TAG_MATTER_TYPE = "MatterType";
    private static final String TAG_AMOUNT = "Amount";
    private final Map<UUID, BridgeTaskData> bridgeData = new HashMap<UUID, BridgeTaskData>();
    private HolderLookup.Provider cachedProvider;

    public BridgeTaskHandlerRepository() {
    }

    public BridgeTaskHandlerRepository(CompoundTag tag, HolderLookup.Provider provider) {
        this.cachedProvider = provider;
        if (tag.contains(TAG_BRIDGES, 9)) {
            ListTag bridgesList = tag.getList(TAG_BRIDGES, 10);
            for (Tag bridgeTag : bridgesList) {
                CompoundTag bridgeCompound = (CompoundTag)bridgeTag;
                UUID bridgeId = bridgeCompound.getUUID(TAG_BRIDGE_ID);
                BridgeTaskData data = new BridgeTaskData();
                if (bridgeCompound.contains(TAG_REQUEST_COUNTERS, 9)) {
                    data.requestCounters = this.readItemWithSourceList(bridgeCompound.getList(TAG_REQUEST_COUNTERS, 10), provider, bridgeId);
                }
                if (bridgeCompound.contains(TAG_PATTERN_REQUESTS, 9)) {
                    data.patternRequests = this.readItemCountList(bridgeCompound.getList(TAG_PATTERN_REQUESTS, 10), provider);
                }
                if (bridgeCompound.contains(TAG_PATTERN_REQUESTS_BY_SOURCE, 9)) {
                    data.patternRequestsBySource = this.readItemCountList(bridgeCompound.getList(TAG_PATTERN_REQUESTS_BY_SOURCE, 10), provider);
                }
                if (bridgeCompound.contains(TAG_ACTIVE_TASKS, 9)) {
                    data.activeTasks = this.readActiveTaskList(bridgeCompound.getList(TAG_ACTIVE_TASKS, 10), provider, bridgeId);
                }
                if (bridgeCompound.contains(TAG_ALLOCATED_MATTER, 9)) {
                    data.allocatedMatterByTask = this.readAllocatedMatterList(bridgeCompound.getList(TAG_ALLOCATED_MATTER, 10));
                }
                if (data.isEmpty()) continue;
                this.bridgeData.put(bridgeId, data);
            }
        }
    }

    public void setCachedProvider(HolderLookup.Provider provider) {
        this.cachedProvider = provider;
    }

    public BridgeTaskData getDataForBridge(UUID bridgeId) {
        return this.bridgeData.computeIfAbsent(bridgeId, id -> new BridgeTaskData());
    }

    public void setDataForBridge(UUID bridgeId, BridgeTaskData data) {
        if (data == null || data.isEmpty()) {
            this.bridgeData.remove(bridgeId);
        } else {
            this.bridgeData.put(bridgeId, data);
        }
        this.setDirty();
    }

    public void removeBridge(UUID bridgeId) {
        if (this.bridgeData.remove(bridgeId) != null) {
            this.setDirty();
        }
    }

    public void clearBridgeData(UUID bridgeId) {
        BridgeTaskData data = this.bridgeData.get(bridgeId);
        if (data != null) {
            data.clear();
            this.setDirty();
        }
    }

    @NotNull
    public CompoundTag save(CompoundTag tag, HolderLookup.Provider provider) {
        ListTag bridgesList = new ListTag();
        for (Map.Entry<UUID, BridgeTaskData> entry : this.bridgeData.entrySet()) {
            BridgeTaskData data = entry.getValue();
            if (data.isEmpty()) continue;
            CompoundTag bridgeCompound = new CompoundTag();
            bridgeCompound.putUUID(TAG_BRIDGE_ID, entry.getKey());
            if (!data.requestCounters.isEmpty()) {
                bridgeCompound.put(TAG_REQUEST_COUNTERS, (Tag)this.writeItemWithSourceList(data.requestCounters, provider));
            }
            if (!data.patternRequests.isEmpty()) {
                bridgeCompound.put(TAG_PATTERN_REQUESTS, (Tag)this.writeItemCountList(data.patternRequests, provider));
            }
            if (!data.patternRequestsBySource.isEmpty()) {
                bridgeCompound.put(TAG_PATTERN_REQUESTS_BY_SOURCE, (Tag)this.writeItemCountList(data.patternRequestsBySource, provider));
            }
            if (!data.activeTasks.isEmpty()) {
                bridgeCompound.put(TAG_ACTIVE_TASKS, (Tag)this.writeActiveTaskList(data.activeTasks, provider));
            }
            if (!data.allocatedMatterByTask.isEmpty()) {
                bridgeCompound.put(TAG_ALLOCATED_MATTER, (Tag)this.writeAllocatedMatterList(data.allocatedMatterByTask));
            }
            bridgesList.add((Object)bridgeCompound);
        }
        tag.put(TAG_BRIDGES, (Tag)bridgesList);
        return tag;
    }

    private ListTag writeItemWithSourceList(Map<ItemWithSourceId, Integer> map, HolderLookup.Provider provider) {
        ListTag list = new ListTag();
        map.forEach((key, amount) -> {
            CompoundTag entry = new CompoundTag();
            entry.put("Stack", key.getItemStack().saveOptional(provider));
            entry.putInt("Count", amount.intValue());
            entry.putUUID("Owner", key.getSourceId());
            list.add((Object)entry);
        });
        return list;
    }

    private Map<ItemWithSourceId, Integer> readItemWithSourceList(ListTag list, HolderLookup.Provider provider, UUID defaultOwner) {
        HashMap<ItemWithSourceId, Integer> map = new HashMap<ItemWithSourceId, Integer>();
        for (Tag element : list) {
            CompoundTag entry = (CompoundTag)element;
            ItemStack stack = ItemStack.parse((HolderLookup.Provider)provider, (Tag)entry.getCompound("Stack")).orElse(ItemStack.EMPTY);
            if (stack.isEmpty()) continue;
            UUID ownerId = entry.contains("Owner") ? entry.getUUID("Owner") : defaultOwner;
            int amount = entry.getInt("Count");
            map.put(new ItemWithSourceId(stack, ownerId), amount);
        }
        return map;
    }

    private ListTag writeItemCountList(Map<ItemStack, Integer> map, HolderLookup.Provider provider) {
        ListTag list = new ListTag();
        map.forEach((stack, amount) -> {
            CompoundTag entry = new CompoundTag();
            entry.put("Stack", stack.saveOptional(provider));
            entry.putInt("Count", amount.intValue());
            list.add((Object)entry);
        });
        return list;
    }

    private Map<ItemStack, Integer> readItemCountList(ListTag list, HolderLookup.Provider provider) {
        HashMap<ItemStack, Integer> map = new HashMap<ItemStack, Integer>();
        for (Tag element : list) {
            CompoundTag entry = (CompoundTag)element;
            ItemStack stack = ItemStack.parse((HolderLookup.Provider)provider, (Tag)entry.getCompound("Stack")).orElse(ItemStack.EMPTY);
            if (stack.isEmpty()) continue;
            map.put(stack, entry.getInt("Count"));
        }
        return map;
    }

    private ListTag writeAllocatedMatterList(Map<String, Map<String, Long>> allocated) {
        ListTag list = new ListTag();
        allocated.forEach((taskId, matterMap) -> {
            if (matterMap.isEmpty()) {
                return;
            }
            CompoundTag entry = new CompoundTag();
            entry.putString(TAG_TASK_ID, taskId);
            ListTag matterList = new ListTag();
            matterMap.forEach((matterId, amount) -> {
                CompoundTag matterEntry = new CompoundTag();
                matterEntry.putString(TAG_MATTER_TYPE, matterId);
                matterEntry.putLong(TAG_AMOUNT, amount.longValue());
                matterList.add((Object)matterEntry);
            });
            entry.put(TAG_MATTER, (Tag)matterList);
            list.add((Object)entry);
        });
        return list;
    }

    private Map<String, Map<String, Long>> readAllocatedMatterList(ListTag list) {
        HashMap<String, Map<String, Long>> allocated = new HashMap<String, Map<String, Long>>();
        for (Tag element : list) {
            CompoundTag entry = (CompoundTag)element;
            String taskId = entry.getString(TAG_TASK_ID);
            if (taskId == null || taskId.isEmpty()) continue;
            HashMap<String, Long> matterMap = new HashMap<String, Long>();
            for (Tag matterTag : entry.getList(TAG_MATTER, 10)) {
                CompoundTag matterEntry = (CompoundTag)matterTag;
                String matterId = matterEntry.getString(TAG_MATTER_TYPE);
                long amount = matterEntry.getLong(TAG_AMOUNT);
                if (matterId.isEmpty() || amount <= 0L) continue;
                matterMap.put(matterId, amount);
            }
            if (matterMap.isEmpty()) continue;
            allocated.put(taskId, matterMap);
        }
        return allocated;
    }

    private ListTag writeActiveTaskList(Map<String, TaskSourceInfo> tasks, HolderLookup.Provider provider) {
        ListTag list = new ListTag();
        tasks.forEach((taskId, info) -> {
            CompoundTag entry = new CompoundTag();
            entry.putString(TAG_TASK_ID, taskId);
            entry.put("Stack", info.getItemStack().saveOptional(provider));
            if (info.getRs2TaskId() != null) {
                entry.putUUID("Rs2TaskId", info.getRs2TaskId().id());
            }
            list.add((Object)entry);
        });
        return list;
    }

    private Map<String, TaskSourceInfo> readActiveTaskList(ListTag list, HolderLookup.Provider provider, UUID blockId) {
        HashMap<String, TaskSourceInfo> map = new HashMap<String, TaskSourceInfo>();
        for (Tag element : list) {
            CompoundTag entry = (CompoundTag)element;
            ItemStack stack = ItemStack.parse((HolderLookup.Provider)provider, (Tag)entry.getCompound("Stack")).orElse(ItemStack.EMPTY);
            if (stack.isEmpty()) continue;
            String taskId = entry.getString(TAG_TASK_ID);
            TaskId rs2TaskId = null;
            if (entry.contains("Rs2TaskId")) {
                rs2TaskId = new TaskId(entry.getUUID("Rs2TaskId"));
            }
            map.put(taskId, new TaskSourceInfo(stack, blockId, rs2TaskId));
        }
        return map;
    }

    public static class BridgeTaskData {
        public Map<ItemWithSourceId, Integer> requestCounters = new HashMap<ItemWithSourceId, Integer>();
        public Map<ItemStack, Integer> patternRequests = new HashMap<ItemStack, Integer>();
        public Map<ItemStack, Integer> patternRequestsBySource = new HashMap<ItemStack, Integer>();
        public Map<String, TaskSourceInfo> activeTasks = new HashMap<String, TaskSourceInfo>();
        public Map<String, Map<String, Long>> allocatedMatterByTask = new HashMap<String, Map<String, Long>>();

        public boolean isEmpty() {
            return this.requestCounters.isEmpty() && this.patternRequests.isEmpty() && this.patternRequestsBySource.isEmpty() && this.activeTasks.isEmpty() && this.allocatedMatterByTask.isEmpty();
        }

        public void clear() {
            this.requestCounters.clear();
            this.patternRequests.clear();
            this.patternRequestsBySource.clear();
            this.activeTasks.clear();
            this.allocatedMatterByTask.clear();
        }
    }
}

