/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.replication_rs2_bridge.mixin;

import com.leclowndu93150.replication_rs2_bridge.util.MatterTypeInfo;
import com.leclowndu93150.replication_rs2_bridge.util.MatterTypeUtil;
import com.mojang.blaze3d.platform.NativeImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Function;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.SpriteLoader;
import net.minecraft.client.renderer.texture.atlas.SpriteResourceLoader;
import net.minecraft.client.renderer.texture.atlas.SpriteSourceList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.inventory.InventoryMenu;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SpriteLoader.class})
public abstract class SpriteLoaderMixin {
    @Shadow
    @Final
    private ResourceLocation location;

    @Shadow
    public abstract SpriteLoader.Preparations stitch(List<SpriteContents> var1, int var2, Executor var3);

    @Inject(method={"loadAndStitch(Lnet/minecraft/server/packs/resources/ResourceManager;Lnet/minecraft/resources/ResourceLocation;ILjava/util/concurrent/Executor;Ljava/util/Collection;)Ljava/util/concurrent/CompletableFuture;"}, at={@At(value="HEAD")}, cancellable=true)
    private void rep_rs2_bridge$loadMatterSprites(ResourceManager resourceManager, ResourceLocation atlasSource, int mipLevel, Executor executor, Collection<MetadataSectionSerializer<?>> serializers, CallbackInfoReturnable<CompletableFuture<SpriteLoader.Preparations>> cir) {
        if (!this.location.equals((Object)InventoryMenu.BLOCK_ATLAS)) {
            return;
        }
        SpriteResourceLoader spriteResourceLoader = SpriteResourceLoader.create(serializers);
        CompletionStage future = ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            List factories = SpriteSourceList.load((ResourceManager)resourceManager, (ResourceLocation)atlasSource).list(resourceManager);
            ArrayList<Function<SpriteResourceLoader, SpriteContents>> mutable = new ArrayList<Function<SpriteResourceLoader, SpriteContents>>(factories);
            this.rep_rs2_bridge$appendMatterFactories(mutable, resourceManager);
            return mutable;
        }, executor).thenCompose(factories -> SpriteLoader.runSpriteSuppliers((SpriteResourceLoader)spriteResourceLoader, (List)factories, (Executor)executor))).thenApply(contents -> this.stitch((List<SpriteContents>)contents, mipLevel, executor));
        cir.setReturnValue((Object)future);
    }

    @Unique
    private void rep_rs2_bridge$appendMatterFactories(List<Function<SpriteResourceLoader, SpriteContents>> factories, ResourceManager resourceManager) {
        for (MatterTypeInfo info : MatterTypeUtil.getAllMatters().values()) {
            factories.add(loader -> this.rep_rs2_bridge$loadMatterSprite((SpriteResourceLoader)loader, info, resourceManager));
        }
    }

    @Unique
    private SpriteContents rep_rs2_bridge$loadMatterSprite(SpriteResourceLoader loader, MatterTypeInfo info, ResourceManager resourceManager) {
        ResourceLocation spriteId = info.texture();
        ResourceLocation texturePath = ResourceLocation.fromNamespaceAndPath((String)spriteId.getNamespace(), (String)("textures/" + spriteId.getPath() + ".png"));
        Optional resourceOpt = resourceManager.getResource(texturePath);
        Resource resource = resourceOpt.orElse(null);
        if (resource == null) {
            return null;
        }
        SpriteContents contents = loader.loadSprite(spriteId, resource);
        if (contents != null && info.matterType() != null) {
            float[] color = (float[])info.matterType().getColor().get();
            this.rep_rs2_bridge$applyTint(contents.getOriginalImage(), color);
        }
        return contents;
    }

    @Unique
    private void rep_rs2_bridge$applyTint(NativeImage image, float[] color) {
        if (color == null || color.length < 3) {
            return;
        }
        float r = this.clampColor(color[0]);
        float g = this.clampColor(color[1]);
        float b = this.clampColor(color[2]);
        int height = image.getHeight();
        int width = image.getWidth();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int pixel = image.getPixelRGBA(x, y);
                int a = pixel >>> 24 & 0xFF;
                int rr = (int)Math.min(255.0f, (float)(pixel >>> 16 & 0xFF) * r);
                int gg = (int)Math.min(255.0f, (float)(pixel >>> 8 & 0xFF) * g);
                int bb = (int)Math.min(255.0f, (float)(pixel & 0xFF) * b);
                int tinted = a << 24 | bb << 16 | gg << 8 | rr;
                image.setPixelRGBA(x, y, tinted);
            }
        }
    }

    @Unique
    private float clampColor(float value) {
        return Math.max(0.0f, Math.min(1.0f, value));
    }
}

