/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.replication_rs2_bridge.block.entity.task;

import com.buuz135.replication.ReplicationRegistry;
import com.buuz135.replication.api.IMatterType;
import com.buuz135.replication.api.pattern.MatterPattern;
import com.buuz135.replication.api.task.IReplicationTask;
import com.buuz135.replication.api.task.ReplicationTask;
import com.buuz135.replication.block.tile.ChipStorageBlockEntity;
import com.buuz135.replication.calculation.MatterCompound;
import com.buuz135.replication.calculation.MatterValue;
import com.buuz135.replication.calculation.ReplicationCalculation;
import com.buuz135.replication.network.MatterNetwork;
import com.hrznstudio.titanium.block_network.element.NetworkElement;
import com.leclowndu93150.replication_rs2_bridge.block.entity.RepRS2BridgeBlockEntity;
import com.leclowndu93150.replication_rs2_bridge.block.entity.RepRS2BridgeNetworkNode;
import com.leclowndu93150.replication_rs2_bridge.block.entity.pattern.ReplicationPatternTemplate;
import com.leclowndu93150.replication_rs2_bridge.block.entity.task.model.ItemWithSourceId;
import com.leclowndu93150.replication_rs2_bridge.block.entity.task.model.TaskSourceInfo;
import com.mojang.logging.LogUtils;
import com.refinedmods.refinedstorage.api.autocrafting.task.TaskId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public final class ReplicationTaskHandler {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String TAG_LOCAL_REQUEST_COUNTERS = "LocalRequestCounters";
    private static final String TAG_LOCAL_PATTERN_REQUESTS = "LocalPatternRequests";
    private static final String TAG_LOCAL_PATTERN_REQUESTS_BY_SOURCE = "LocalPatternRequestsBySource";
    private static final String TAG_LOCAL_ACTIVE_TASKS = "LocalActiveTasks";
    private static final String TAG_ALLOCATED_MATTER = "AllocatedMatter";
    private static final String TAG_TASK_ID = "TaskId";
    private static final String TAG_MATTER_LIST = "MatterList";
    private static final String TAG_MATTER_ID = "MatterId";
    private static final String TAG_MATTER_NAME = "MatterName";
    private static final String TAG_AMOUNT = "Amount";
    private static final int REQUEST_ACCUMULATION_TICKS = 100;
    private final RepRS2BridgeBlockEntity owner;
    private final Map<UUID, Map<ItemWithSourceId, Integer>> requestCounters = new HashMap<UUID, Map<ItemWithSourceId, Integer>>();
    private final Map<UUID, Map<ItemStack, Integer>> patternRequests = new HashMap<UUID, Map<ItemStack, Integer>>();
    private final Map<UUID, Map<ItemStack, Integer>> patternRequestsBySource = new HashMap<UUID, Map<ItemStack, Integer>>();
    private final Map<UUID, Map<String, TaskSourceInfo>> activeTasks = new HashMap<UUID, Map<String, TaskSourceInfo>>();
    private final Map<String, Map<IMatterType, Long>> allocatedMatterByTask = new HashMap<String, Map<IMatterType, Long>>();
    private boolean needsTaskRescan;
    private int requestCounterTicks;

    public ReplicationTaskHandler(RepRS2BridgeBlockEntity owner) {
        this.owner = owner;
    }

    public void queuePatternRequest(ReplicationPatternTemplate template) {
        UUID sourceId = this.owner.getBlockId();
        if (sourceId == null) {
            return;
        }
        ItemStack output = template.outputStack().copy();
        Map counters = this.requestCounters.computeIfAbsent(sourceId, id -> new HashMap());
        ItemWithSourceId key = new ItemWithSourceId(output, sourceId);
        counters.merge(key, output.getCount(), Integer::sum);
        Map sourceRequests = this.patternRequestsBySource.computeIfAbsent(sourceId, id -> new HashMap());
        sourceRequests.merge(output, 1, Integer::sum);
        Map globalRequests = this.patternRequests.computeIfAbsent(sourceId, id -> new HashMap());
        globalRequests.merge(output, 1, Integer::sum);
        this.requestCounterTicks = 100;
    }

    public void tick(@Nullable MatterNetwork replicationNetwork) {
        if (this.needsTaskRescan && replicationNetwork != null) {
            this.relinkActiveTasksFromNetwork(replicationNetwork);
            this.needsTaskRescan = false;
        }
        this.cleanupCompletedTasks(replicationNetwork);
        if (this.requestCounterTicks >= 100) {
            try {
                this.processAccumulatedRequests(replicationNetwork);
                this.requestCounters.clear();
                this.requestCounterTicks = 0;
            }
            catch (Exception e) {
                LOGGER.error("Bridge: Exception in request processing: {}", (Object)e.getMessage());
            }
        } else {
            ++this.requestCounterTicks;
        }
    }

    public void cancelReplicationTaskForRs2Task(TaskId rs2TaskId) {
        ServerLevel server;
        ServerLevel serverLevel;
        UUID blockId = this.owner.getBlockId();
        Level level = this.owner.getLevel();
        ServerLevel serverLevel2 = serverLevel = level instanceof ServerLevel ? (server = (ServerLevel)level) : null;
        if (blockId == null || serverLevel == null) {
            return;
        }
        Map<String, TaskSourceInfo> sourceTasks = this.activeTasks.get(blockId);
        if (sourceTasks == null || sourceTasks.isEmpty()) {
            return;
        }
        ArrayList<String> replicationTaskIds = new ArrayList<String>();
        for (Map.Entry<String, TaskSourceInfo> entry : sourceTasks.entrySet()) {
            TaskSourceInfo info = entry.getValue();
            if (info.getRs2TaskId() == null || !info.getRs2TaskId().equals((Object)rs2TaskId)) continue;
            replicationTaskIds.add((String)entry.getKey());
        }
        if (replicationTaskIds.isEmpty()) {
            return;
        }
        MatterNetwork replicationNetwork = this.owner.getNetwork();
        if (replicationNetwork == null) {
            return;
        }
        for (String replicationTaskId : replicationTaskIds) {
            replicationNetwork.cancelTask(replicationTaskId, (Level)serverLevel);
            TaskSourceInfo info = sourceTasks.remove(replicationTaskId);
            if (info != null && info.getItemStack() != null) {
                Map<ItemStack, Integer> globalRequests;
                Map<ItemStack, Integer> sourceRequests = this.patternRequestsBySource.get(blockId);
                if (sourceRequests != null) {
                    sourceRequests.remove(info.getItemStack());
                    if (sourceRequests.isEmpty()) {
                        this.patternRequestsBySource.remove(blockId);
                    }
                }
                if ((globalRequests = this.patternRequests.get(blockId)) != null) {
                    globalRequests.remove(info.getItemStack());
                    if (globalRequests.isEmpty()) {
                        this.patternRequests.remove(blockId);
                    }
                }
            }
            this.allocatedMatterByTask.remove(replicationTaskId);
        }
        if (sourceTasks.isEmpty()) {
            this.activeTasks.remove(blockId);
        }
        this.owner.getMatterStorage().refreshCache();
        RepRS2BridgeNetworkNode networkNode = this.owner.getBridgeNetworkNode();
        if (networkNode != null) {
            networkNode.refreshStorageInNetwork();
        }
        this.owner.setChanged();
    }

    public void saveToNbt(CompoundTag tag, HolderLookup.Provider registries) {
        Map<String, Map<String, Long>> allocated;
        Map<String, TaskSourceInfo> tasks;
        Map<ItemStack, Integer> localPatternRequestsBySource;
        Map<ItemStack, Integer> localPatternRequests;
        UUID blockId = this.owner.getBlockId();
        if (blockId == null || tag == null) {
            return;
        }
        CompoundTag handler = new CompoundTag();
        Map<ItemWithSourceId, Integer> localCounters = this.requestCounters.get(blockId);
        if (localCounters != null && !localCounters.isEmpty()) {
            handler.put(TAG_LOCAL_REQUEST_COUNTERS, (Tag)this.writeItemWithSourceList(localCounters, registries));
        }
        if ((localPatternRequests = this.patternRequests.get(blockId)) != null && !localPatternRequests.isEmpty()) {
            handler.put(TAG_LOCAL_PATTERN_REQUESTS, (Tag)this.writeItemCountList(localPatternRequests, registries));
        }
        if ((localPatternRequestsBySource = this.patternRequestsBySource.get(blockId)) != null && !localPatternRequestsBySource.isEmpty()) {
            handler.put(TAG_LOCAL_PATTERN_REQUESTS_BY_SOURCE, (Tag)this.writeItemCountList(localPatternRequestsBySource, registries));
        }
        if ((tasks = this.activeTasks.get(blockId)) != null && !tasks.isEmpty()) {
            handler.put(TAG_LOCAL_ACTIVE_TASKS, (Tag)this.writeActiveTaskList(tasks, registries));
        }
        if (!(allocated = this.serializeAllocatedMatter()).isEmpty()) {
            handler.put(TAG_ALLOCATED_MATTER, (Tag)this.writeAllocatedMatterList(allocated));
        }
        tag.put("TaskHandler", (Tag)handler);
    }

    public void loadFromNbt(CompoundTag tag, HolderLookup.Provider registries) {
        UUID blockId = this.owner.getBlockId();
        if (blockId == null || tag == null || !tag.contains("TaskHandler", 10)) {
            return;
        }
        CompoundTag handler = tag.getCompound("TaskHandler");
        this.requestCounters.remove(blockId);
        this.patternRequests.remove(blockId);
        this.patternRequestsBySource.remove(blockId);
        this.activeTasks.remove(blockId);
        this.allocatedMatterByTask.clear();
        if (handler.contains(TAG_LOCAL_REQUEST_COUNTERS, 9)) {
            this.requestCounters.put(blockId, this.readItemWithSourceList(handler.getList(TAG_LOCAL_REQUEST_COUNTERS, 10), registries));
        }
        if (handler.contains(TAG_LOCAL_PATTERN_REQUESTS, 9)) {
            this.patternRequests.put(blockId, this.readItemCountList(handler.getList(TAG_LOCAL_PATTERN_REQUESTS, 10), registries));
        }
        if (handler.contains(TAG_LOCAL_PATTERN_REQUESTS_BY_SOURCE, 9)) {
            this.patternRequestsBySource.put(blockId, this.readItemCountList(handler.getList(TAG_LOCAL_PATTERN_REQUESTS_BY_SOURCE, 10), registries));
        }
        if (handler.contains(TAG_LOCAL_ACTIVE_TASKS, 9)) {
            this.activeTasks.put(blockId, this.readActiveTaskList(handler.getList(TAG_LOCAL_ACTIVE_TASKS, 10), registries));
        }
        if (handler.contains(TAG_ALLOCATED_MATTER, 9)) {
            this.deserializeAllocatedMatter(this.readAllocatedMatterList(handler.getList(TAG_ALLOCATED_MATTER, 10)));
        }
        this.pruneOrphanAllocations(blockId);
    }

    @Deprecated
    public void saveLocalRequestState(CompoundTag tag, HolderLookup.Provider registries) {
    }

    public void loadLocalRequestState(CompoundTag tag, HolderLookup.Provider registries) {
    }

    @Deprecated
    public void saveLocalActiveTasks(CompoundTag tag, HolderLookup.Provider registries) {
    }

    public void loadLocalActiveTasks(CompoundTag tag, HolderLookup.Provider registries) {
    }

    public Map<String, Map<IMatterType, Long>> getAllocatedMatterByTask() {
        return this.allocatedMatterByTask;
    }

    public Map<IMatterType, Long> summarizeAllocatedMatter() {
        HashMap<IMatterType, Long> totals = new HashMap<IMatterType, Long>();
        for (Map<IMatterType, Long> allocation : this.allocatedMatterByTask.values()) {
            for (Map.Entry<IMatterType, Long> entry : allocation.entrySet()) {
                totals.merge(entry.getKey(), entry.getValue(), Long::sum);
            }
        }
        return totals;
    }

    public void resetAfterDataLoad() {
        this.forceImmediateProcessing();
        this.needsTaskRescan = true;
    }

    public void prepareForSave(@Nullable MatterNetwork replicationNetwork) {
        if (replicationNetwork != null) {
            this.cleanupCompletedTasks(replicationNetwork);
            this.cancelOrphanReplicationTasks(replicationNetwork);
        }
        this.pruneOrphanAllocations(this.owner.getBlockId());
    }

    public void cancelAllReplicationTasks(@Nullable MatterNetwork replicationNetwork) {
        ServerLevel server;
        if (replicationNetwork == null || this.owner.getLevel() == null) {
            return;
        }
        Level level = this.owner.getLevel();
        ServerLevel serverLevel = level instanceof ServerLevel ? (server = (ServerLevel)level) : null;
        UUID blockId = this.owner.getBlockId();
        HashMap pendingTasks = replicationNetwork.getTaskManager().getPendingTasks();
        for (String taskId : new ArrayList(pendingTasks.keySet())) {
            IReplicationTask task = (IReplicationTask)pendingTasks.get(taskId);
            if (task == null || task.getSource() == null || !task.getSource().equals((Object)this.owner.getBlockPos())) continue;
            replicationNetwork.cancelTask(taskId, (Level)serverLevel);
            pendingTasks.remove(taskId);
        }
        if (blockId != null) {
            this.activeTasks.remove(blockId);
            this.patternRequests.remove(blockId);
            this.patternRequestsBySource.remove(blockId);
        }
        this.allocatedMatterByTask.clear();
        this.owner.setChanged();
    }

    public void rebuildAllocationState() {
        this.owner.getMatterStorage().refreshCache();
        RepRS2BridgeNetworkNode networkNode = this.owner.getBridgeNetworkNode();
        if (networkNode != null) {
            networkNode.refreshStorageInNetwork();
        }
        this.owner.setChanged();
    }

    public void forceImmediateProcessing() {
        this.requestCounterTicks = 100;
    }

    public void markNeedsTaskRescan() {
        this.needsTaskRescan = true;
    }

    public void clearPendingOperations() {
        this.requestCounters.clear();
        this.patternRequests.clear();
        this.patternRequestsBySource.clear();
    }

    public void compactIfIdle(boolean hasRs2Tasks) {
        if (hasRs2Tasks) {
            return;
        }
        if (!this.activeTasks.isEmpty()) {
            return;
        }
        UUID blockId = this.owner.getBlockId();
        boolean changed = false;
        if (!this.allocatedMatterByTask.isEmpty()) {
            this.allocatedMatterByTask.clear();
            changed = true;
        }
        if (blockId != null) {
            if (this.patternRequests.remove(blockId) != null) {
                changed = true;
            }
            if (this.patternRequestsBySource.remove(blockId) != null) {
                changed = true;
            }
            if (this.requestCounters.remove(blockId) != null) {
                changed = true;
            }
        }
        if (changed) {
            this.owner.setChanged();
        }
    }

    private void pruneOrphanAllocations(UUID blockId) {
        if (blockId == null) {
            return;
        }
        Map<String, TaskSourceInfo> tasks = this.activeTasks.get(blockId);
        if (tasks == null || tasks.isEmpty()) {
            if (!this.allocatedMatterByTask.isEmpty()) {
                this.allocatedMatterByTask.clear();
                this.owner.setChanged();
            }
            return;
        }
        ArrayList<String> validTaskIds = new ArrayList<String>(tasks.keySet());
        boolean changed = this.allocatedMatterByTask.keySet().removeIf(taskId -> !validTaskIds.contains(taskId));
        if (changed) {
            this.owner.setChanged();
        }
    }

    private void cleanupCompletedTasks(@Nullable MatterNetwork replicationNetwork) {
        if (replicationNetwork == null) {
            return;
        }
        HashMap pendingTasks = replicationNetwork.getTaskManager().getPendingTasks();
        boolean removedAny = false;
        for (UUID sourceId : new ArrayList<UUID>(this.activeTasks.keySet())) {
            Map<String, TaskSourceInfo> sourceTasks = this.activeTasks.get(sourceId);
            if (sourceTasks == null) continue;
            for (String taskId : new ArrayList<String>(sourceTasks.keySet())) {
                if (pendingTasks.containsKey(taskId)) continue;
                TaskSourceInfo info = sourceTasks.remove(taskId);
                this.allocatedMatterByTask.remove(taskId);
                if (info != null && info.getItemStack() != null) {
                    Map<ItemStack, Integer> globalRequests;
                    Map<ItemStack, Integer> sourceRequests = this.patternRequestsBySource.get(sourceId);
                    if (sourceRequests != null) {
                        sourceRequests.remove(info.getItemStack());
                        if (sourceRequests.isEmpty()) {
                            this.patternRequestsBySource.remove(sourceId);
                        }
                    }
                    if ((globalRequests = this.patternRequests.get(sourceId)) != null) {
                        globalRequests.remove(info.getItemStack());
                        if (globalRequests.isEmpty()) {
                            this.patternRequests.remove(sourceId);
                        }
                    }
                }
                removedAny = true;
            }
            if (!sourceTasks.isEmpty()) continue;
            this.activeTasks.remove(sourceId);
        }
        if (removedAny) {
            this.owner.getMatterStorage().refreshCache();
            RepRS2BridgeNetworkNode networkNode = this.owner.getBridgeNetworkNode();
            if (networkNode != null) {
                networkNode.refreshStorageInNetwork();
            }
            this.owner.setChanged();
        }
    }

    private void cancelOrphanReplicationTasks(MatterNetwork replicationNetwork) {
        UUID blockId = this.owner.getBlockId();
        if (blockId == null) {
            return;
        }
        HashMap pendingTasks = replicationNetwork.getTaskManager().getPendingTasks();
        for (String taskId : new ArrayList(pendingTasks.keySet())) {
            ServerLevel server;
            Map<String, TaskSourceInfo> tasks;
            IReplicationTask task = (IReplicationTask)pendingTasks.get(taskId);
            if (task == null || task.getSource() == null || !task.getSource().equals((Object)this.owner.getBlockPos()) || (tasks = this.activeTasks.get(blockId)) != null && tasks.containsKey(taskId)) continue;
            Level level = this.owner.getLevel();
            replicationNetwork.cancelTask(taskId, level instanceof ServerLevel ? (server = (ServerLevel)level) : null);
            pendingTasks.remove(taskId);
        }
    }

    private void processAccumulatedRequests(@Nullable MatterNetwork network) {
        if (RepRS2BridgeBlockEntity.isWorldUnloading() || network == null || this.requestCounters.isEmpty()) {
            return;
        }
        for (UUID sourceId : this.requestCounters.keySet()) {
            if (RepRS2BridgeBlockEntity.isWorldUnloading()) {
                return;
            }
            Map<ItemWithSourceId, Integer> sourceCounters = this.requestCounters.get(sourceId);
            if (sourceCounters == null) continue;
            for (Map.Entry<ItemWithSourceId, Integer> entry : sourceCounters.entrySet()) {
                if (RepRS2BridgeBlockEntity.isWorldUnloading()) {
                    return;
                }
                ItemWithSourceId key = entry.getKey();
                ItemStack itemStack = key.getItemStack();
                int count = entry.getValue();
                if (count <= 0) continue;
                this.createReplicationTasks(network, itemStack, count, sourceId);
            }
        }
    }

    private void createReplicationTasks(MatterNetwork network, ItemStack itemStack, int totalCount, UUID sourceId) {
        List<MatterPattern> patterns = this.findMatchingPatterns(network, itemStack);
        if (patterns.isEmpty()) {
            LOGGER.warn("Bridge: No replication pattern found for {} ({} requests)", (Object)itemStack.getDisplayName().getString(), (Object)totalCount);
            return;
        }
        MatterPattern pattern = patterns.get(0);
        this.spawnReplicationTask(network, pattern, itemStack, totalCount, sourceId);
    }

    private List<MatterPattern> findMatchingPatterns(MatterNetwork network, ItemStack requestedStack) {
        ArrayList<MatterPattern> matches = new ArrayList<MatterPattern>();
        Level level = this.owner.getLevel();
        if (level == null) {
            return matches;
        }
        for (NetworkElement chipSupplier : network.getChipSuppliers()) {
            BlockEntity tile = chipSupplier.getLevel().getBlockEntity(chipSupplier.getPos());
            if (!(tile instanceof ChipStorageBlockEntity)) continue;
            ChipStorageBlockEntity chipStorage = (ChipStorageBlockEntity)tile;
            for (MatterPattern pattern : chipStorage.getPatterns(level, chipStorage)) {
                if (!ItemStack.isSameItemSameComponents((ItemStack)pattern.getStack(), (ItemStack)requestedStack)) continue;
                matches.add(pattern);
            }
        }
        return matches;
    }

    private void spawnReplicationTask(MatterNetwork network, MatterPattern pattern, ItemStack requestedStack, int amount, UUID sourceId) {
        BlockPos blockPos = this.owner.getBlockPos();
        ReplicationTask task = new ReplicationTask(pattern.getStack().copy(), amount, IReplicationTask.Mode.MULTIPLE, blockPos, false);
        String taskId = task.getUuid().toString();
        network.getTaskManager().getPendingTasks().put(taskId, task);
        Level level = this.owner.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            network.onTaskValueChanged((IReplicationTask)task, serverLevel);
        }
        TaskSourceInfo info = this.getTaskSourceInfo(requestedStack, sourceId);
        Map sourceTasks = this.activeTasks.computeIfAbsent(sourceId, id -> new HashMap());
        sourceTasks.put(taskId, info);
        Map sourceRequests = this.patternRequestsBySource.computeIfAbsent(sourceId, id -> new HashMap());
        int currentPatternRequests = sourceRequests.getOrDefault(requestedStack, 0);
        sourceRequests.put(requestedStack, currentPatternRequests + amount);
        this.extractMatterForTask(pattern, amount, taskId);
        this.owner.setChanged();
    }

    @NotNull
    private TaskSourceInfo getTaskSourceInfo(ItemStack itemStack, UUID sourceId) {
        TaskId rs2TaskId = null;
        RepRS2BridgeNetworkNode networkNode = this.owner.getBridgeNetworkNode();
        if (networkNode != null) {
            rs2TaskId = networkNode.peekActiveTaskId();
        }
        return new TaskSourceInfo(itemStack, sourceId, rs2TaskId);
    }

    private void extractMatterForTask(MatterPattern pattern, int count, String taskId) {
        MatterCompound matterCompound = ReplicationCalculation.getMatterCompound((ItemStack)pattern.getStack());
        if (matterCompound == null) {
            return;
        }
        HashMap<IMatterType, Long> allocated = new HashMap<IMatterType, Long>();
        for (MatterValue matterValue : matterCompound.getValues().values()) {
            IMatterType matterType = matterValue.getMatter();
            if (matterType == null) continue;
            long matterAmount = (long)Math.ceil(matterValue.getAmount()) * (long)count;
            allocated.merge(matterType, matterAmount, Long::sum);
        }
        if (!allocated.isEmpty()) {
            this.allocatedMatterByTask.put(taskId, allocated);
        }
    }

    private void relinkActiveTasksFromNetwork(MatterNetwork network) {
        UUID blockId = this.owner.getBlockId();
        if (blockId == null) {
            return;
        }
        Map tasks = this.activeTasks.computeIfAbsent(blockId, id -> new HashMap());
        HashMap previous = new HashMap(tasks);
        tasks.clear();
        network.getTaskManager().getPendingTasks().forEach((taskId, task) -> {
            if (task == null || task.getSource() == null) {
                return;
            }
            if (!task.getSource().equals((Object)this.owner.getBlockPos())) {
                return;
            }
            TaskSourceInfo existing = (TaskSourceInfo)previous.get(taskId);
            if (existing != null) {
                tasks.put(taskId, new TaskSourceInfo(task.getReplicatingStack(), existing.getSourceId(), existing.getRs2TaskId()));
            } else {
                tasks.put(taskId, new TaskSourceInfo(task.getReplicatingStack(), blockId));
            }
        });
    }

    private ListTag writeItemWithSourceList(Map<ItemWithSourceId, Integer> map, HolderLookup.Provider registries) {
        ListTag list = new ListTag();
        map.forEach((key, amount) -> {
            CompoundTag entry = new CompoundTag();
            entry.put("Stack", key.getItemStack().saveOptional(registries));
            entry.putInt("Count", amount.intValue());
            entry.putUUID("Owner", key.getSourceId());
            list.add((Object)entry);
        });
        return list;
    }

    private Map<ItemWithSourceId, Integer> readItemWithSourceList(ListTag list, HolderLookup.Provider registries) {
        HashMap<ItemWithSourceId, Integer> map = new HashMap<ItemWithSourceId, Integer>();
        for (Tag element : list) {
            CompoundTag entry = (CompoundTag)element;
            ItemStack stack = ItemStack.parse((HolderLookup.Provider)registries, (Tag)entry.getCompound("Stack")).orElse(ItemStack.EMPTY);
            if (stack.isEmpty()) continue;
            UUID ownerId = entry.contains("Owner") ? entry.getUUID("Owner") : this.owner.getBlockId();
            int amount = entry.getInt("Count");
            map.put(new ItemWithSourceId(stack, ownerId), amount);
        }
        return map;
    }

    private ListTag writeItemCountList(Map<ItemStack, Integer> map, HolderLookup.Provider registries) {
        ListTag list = new ListTag();
        map.forEach((stack, amount) -> {
            CompoundTag entry = new CompoundTag();
            entry.put("Stack", stack.saveOptional(registries));
            entry.putInt("Count", amount.intValue());
            list.add((Object)entry);
        });
        return list;
    }

    private Map<ItemStack, Integer> readItemCountList(ListTag list, HolderLookup.Provider registries) {
        HashMap<ItemStack, Integer> map = new HashMap<ItemStack, Integer>();
        for (Tag element : list) {
            CompoundTag entry = (CompoundTag)element;
            ItemStack stack = ItemStack.parse((HolderLookup.Provider)registries, (Tag)entry.getCompound("Stack")).orElse(ItemStack.EMPTY);
            if (stack.isEmpty()) continue;
            map.put(stack, entry.getInt("Count"));
        }
        return map;
    }

    private ListTag writeActiveTaskList(Map<String, TaskSourceInfo> tasks, HolderLookup.Provider registries) {
        ListTag list = new ListTag();
        tasks.forEach((taskId, info) -> {
            CompoundTag entry = new CompoundTag();
            entry.putString(TAG_TASK_ID, taskId);
            entry.put("Stack", info.getItemStack().saveOptional(registries));
            if (info.getRs2TaskId() != null) {
                entry.putUUID("Rs2TaskId", info.getRs2TaskId().id());
            }
            list.add((Object)entry);
        });
        return list;
    }

    private Map<String, TaskSourceInfo> readActiveTaskList(ListTag list, HolderLookup.Provider registries) {
        HashMap<String, TaskSourceInfo> map = new HashMap<String, TaskSourceInfo>();
        for (Tag element : list) {
            CompoundTag entry = (CompoundTag)element;
            ItemStack stack = ItemStack.parse((HolderLookup.Provider)registries, (Tag)entry.getCompound("Stack")).orElse(ItemStack.EMPTY);
            if (stack.isEmpty()) continue;
            String taskId = entry.getString(TAG_TASK_ID);
            TaskId rs2TaskId = null;
            if (entry.contains("Rs2TaskId")) {
                rs2TaskId = new TaskId(entry.getUUID("Rs2TaskId"));
            }
            map.put(taskId, new TaskSourceInfo(stack, this.owner.getBlockId(), rs2TaskId));
        }
        return map;
    }

    private Map<String, Map<String, Long>> serializeAllocatedMatter() {
        HashMap<String, Map<String, Long>> serialized = new HashMap<String, Map<String, Long>>();
        this.allocatedMatterByTask.forEach((taskId, allocations) -> {
            if (allocations.isEmpty()) {
                return;
            }
            HashMap matterMap = new HashMap();
            allocations.forEach((matterType, amount) -> {
                if (amount <= 0L) {
                    return;
                }
                Integer numericId = ReplicationRegistry.MATTER_TYPES_REGISTRY.getId(matterType);
                if (numericId != null && numericId >= 0) {
                    matterMap.put(Integer.toString(numericId), amount);
                } else {
                    ResourceLocation key = ReplicationRegistry.MATTER_TYPES_REGISTRY.getKey(matterType);
                    if (key != null) {
                        matterMap.put(key.toString(), amount);
                    }
                }
            });
            if (!matterMap.isEmpty()) {
                serialized.put((String)taskId, matterMap);
            }
        });
        return serialized;
    }

    private ListTag writeAllocatedMatterList(Map<String, Map<String, Long>> allocated) {
        ListTag list = new ListTag();
        allocated.forEach((taskId, matterMap) -> {
            if (matterMap.isEmpty()) {
                return;
            }
            CompoundTag entry = new CompoundTag();
            entry.putString(TAG_TASK_ID, taskId);
            ListTag matterList = new ListTag();
            matterMap.forEach((matterId, amount) -> {
                CompoundTag matterEntry = new CompoundTag();
                Integer numericId = null;
                try {
                    numericId = Integer.parseInt(matterId);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (numericId == null || numericId < 0) {
                    ResourceLocation key = ResourceLocation.tryParse((String)matterId);
                    IMatterType type = key != null ? (IMatterType)ReplicationRegistry.MATTER_TYPES_REGISTRY.get(key) : null;
                    Integer n = numericId = type != null ? Integer.valueOf(ReplicationRegistry.MATTER_TYPES_REGISTRY.getId((Object)type)) : null;
                }
                if (numericId != null && numericId >= 0) {
                    matterEntry.putInt(TAG_MATTER_ID, numericId.intValue());
                } else {
                    matterEntry.putString(TAG_MATTER_NAME, matterId);
                }
                matterEntry.putLong(TAG_AMOUNT, amount.longValue());
                matterList.add((Object)matterEntry);
            });
            entry.put(TAG_MATTER_LIST, (Tag)matterList);
            list.add((Object)entry);
        });
        return list;
    }

    private Map<String, Map<String, Long>> readAllocatedMatterList(ListTag list) {
        HashMap<String, Map<String, Long>> allocated = new HashMap<String, Map<String, Long>>();
        for (Tag element : list) {
            CompoundTag entry = (CompoundTag)element;
            String taskId = entry.getString(TAG_TASK_ID);
            if (taskId == null || taskId.isEmpty()) continue;
            HashMap<String, Long> matters = new HashMap<String, Long>();
            for (Tag matterTag : entry.getList(TAG_MATTER_LIST, 10)) {
                CompoundTag matterEntry = (CompoundTag)matterTag;
                String matterId = matterEntry.getString(TAG_MATTER_NAME);
                if (matterEntry.contains(TAG_MATTER_ID, 3)) {
                    IMatterType type = (IMatterType)ReplicationRegistry.MATTER_TYPES_REGISTRY.byId(matterEntry.getInt(TAG_MATTER_ID));
                    if (type != null && ReplicationRegistry.MATTER_TYPES_REGISTRY.getKey((Object)type) != null) {
                        matterId = ReplicationRegistry.MATTER_TYPES_REGISTRY.getKey((Object)type).toString();
                    }
                } else if (!matterId.isEmpty()) {
                    try {
                        int numericId = Integer.parseInt(matterId);
                        IMatterType type = (IMatterType)ReplicationRegistry.MATTER_TYPES_REGISTRY.byId(numericId);
                        if (type != null && ReplicationRegistry.MATTER_TYPES_REGISTRY.getKey((Object)type) != null) {
                            matterId = ReplicationRegistry.MATTER_TYPES_REGISTRY.getKey((Object)type).toString();
                        }
                    }
                    catch (NumberFormatException numericId) {
                        // empty catch block
                    }
                }
                long amount = matterEntry.getLong(TAG_AMOUNT);
                if (matterId.isEmpty() || amount <= 0L) continue;
                matters.put(matterId, amount);
            }
            if (matters.isEmpty()) continue;
            allocated.put(taskId, matters);
        }
        return allocated;
    }

    private void deserializeAllocatedMatter(Map<String, Map<String, Long>> serialized) {
        this.allocatedMatterByTask.clear();
        serialized.forEach((taskId, matterMap) -> {
            HashMap allocations = new HashMap();
            matterMap.forEach((matterId, amount) -> {
                if (amount <= 0L) {
                    return;
                }
                IMatterType type = null;
                try {
                    int numericId = Integer.parseInt(matterId);
                    type = (IMatterType)ReplicationRegistry.MATTER_TYPES_REGISTRY.byId(numericId);
                }
                catch (NumberFormatException numericId) {
                    // empty catch block
                }
                if (type == null) {
                    ResourceLocation key = ResourceLocation.tryParse((String)matterId);
                    IMatterType iMatterType = type = key != null ? (IMatterType)ReplicationRegistry.MATTER_TYPES_REGISTRY.get(key) : null;
                }
                if (type != null) {
                    allocations.put(type, amount);
                }
            });
            if (!allocations.isEmpty()) {
                this.allocatedMatterByTask.put((String)taskId, allocations);
            }
        });
    }
}

