/*
 * Decompiled with CFR 0.152.
 */
package chappie.displaycase.mixin;

import chappie.displaycase.client.tile.DisplayCaseItemRenderer;
import chappie.displaycase.client.tile.DisplayCaseRenderer;
import chappie.displaycase.common.items.DisplayCaseItem;
import chappie.displaycase.common.items.DisplayCaseLidItem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemRenderer.class})
public abstract class ItemRendererMixin {
    @Shadow
    protected abstract void renderModelLists(BakedModel var1, ItemStack var2, int var3, int var4, PoseStack var5, VertexConsumer var6);

    @Inject(method={"render"}, at={@At(value="HEAD")}, cancellable=true)
    public void render(ItemStack stack, ItemDisplayContext transformType, boolean $$2, PoseStack poseStack, MultiBufferSource bufferSource, int light, int overlay, BakedModel model, CallbackInfo info) {
        if (!stack.isEmpty() && (stack.getItem() instanceof DisplayCaseLidItem || stack.getItem() instanceof DisplayCaseItem)) {
            poseStack.pushPose();
            model.getTransforms().getTransform(transformType).apply($$2, poseStack);
            poseStack.translate(-0.5, -0.5, -0.5);
            if (stack.getItem() instanceof DisplayCaseLidItem) {
                DyeColor color = (DyeColor)stack.get(DataComponents.BASE_COLOR);
                poseStack.pushPose();
                poseStack.scale(0.7f, 0.7f, 0.7f);
                poseStack.translate(0.215, 0.0, 0.215);
                Block block = DisplayCaseRenderer.ITEM_BY_DYE.getOrDefault(color, Blocks.GLASS);
                this.renderModelLists(Minecraft.getInstance().getBlockRenderer().getBlockModel(block.defaultBlockState()), block.asItem().getDefaultInstance(), light, overlay, poseStack, bufferSource.getBuffer(Sheets.translucentCullBlockSheet()));
                poseStack.popPose();
            } else {
                DisplayCaseItemRenderer.ITEM_RENDERER.renderByItem(stack, poseStack, bufferSource, light, overlay);
                info.cancel();
            }
            poseStack.popPose();
        }
    }
}

