/*
 * Decompiled with CFR 0.152.
 */
package chappie.displaycase.common.tile;

import chappie.displaycase.common.criterions.ExplosionOfDisplayCaseTrigger;
import chappie.displaycase.common.items.DisplayCaseItem;
import chappie.displaycase.common.items.DisplayCaseLidItem;
import chappie.displaycase.common.items.ModItems;
import chappie.displaycase.common.tile.ModTileEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PlayerHeadItem;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class DisplayCaseTileEntity
extends BlockEntity {
    private int rot = 0;
    private int timeToBoom = 0;
    private ItemStack stack = ItemStack.EMPTY;
    private ItemStack lidItem = ModItems.DISPLAY_CASE_LID.getDefaultInstance();
    private boolean waxed = false;

    public DisplayCaseTileEntity(BlockPos pos, BlockState state) {
        super(ModTileEntities.DISPLAY_CASE, pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, DisplayCaseTileEntity tile) {
        tile.rotTick();
        if (tile.timeToBoom > 0) {
            --tile.timeToBoom;
        }
        if (tile.timeToBoom == 1 && !level.isClientSide()) {
            level.explode(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 3.0f, Level.ExplosionInteraction.BLOCK);
            for (ServerPlayer entity : level.getEntitiesOfClass(ServerPlayer.class, new AABB(pos.getCenter(), pos.getCenter()).inflate(10.0, 10.0, 10.0))) {
                ExplosionOfDisplayCaseTrigger.INSTANCE.trigger(entity);
            }
        }
    }

    public void rotTick() {
        if (this.level == null) {
            return;
        }
        if (!this.waxed && this.rot != Short.MIN_VALUE) {
            ++this.rot;
        }
    }

    public DyeColor getColor() {
        PlayerHeadItem item;
        Item item2 = this.getItem().getItem();
        if (item2 instanceof PlayerHeadItem && (item = (PlayerHeadItem)item2).getName(this.getItem()).toString().equals("ChappiePie")) {
            return DyeColor.values()[this.rot % 75 / 5];
        }
        if (this.lidItem != null && !this.lidItem.isEmpty()) {
            return (DyeColor)this.lidItem.get(DataComponents.BASE_COLOR);
        }
        return null;
    }

    public void setColor(DyeColor color) {
        if (this.lidItem != null) {
            if (color == null) {
                this.lidItem.remove(DataComponents.BASE_COLOR);
            } else {
                this.lidItem.set(DataComponents.BASE_COLOR, (Object)color);
            }
        }
        this.markUpdated();
    }

    public boolean hasLid() {
        return this.lidItem != null && this.lidItem.getItem() instanceof DisplayCaseLidItem;
    }

    public ItemStack getLidItem() {
        return this.lidItem;
    }

    public void setLidItem(ItemStack lidItem) {
        this.lidItem = lidItem;
        this.markUpdated();
    }

    public int getRot() {
        return this.rot;
    }

    public boolean isWaxed() {
        return this.waxed;
    }

    public void setWaxed(boolean waxed) {
        this.waxed = waxed;
        this.markUpdated();
    }

    public ItemStack getItem() {
        return this.stack;
    }

    public boolean setItem(ItemStack stack) {
        if (this.timeToBoom > 0) {
            return false;
        }
        this.stack = stack;
        this.stack.setCount(1);
        if (stack.getItem() instanceof DisplayCaseItem && this.level != null) {
            ItemStack stack1 = stack;
            boolean shouldBoom = false;
            for (int i = 0; i < 11 && stack1.get(DataComponents.BLOCK_ENTITY_DATA) != null; ++i) {
                ItemStack displayCaseIn = ItemStack.parseOptional((HolderLookup.Provider)this.level.registryAccess(), (CompoundTag)((CustomData)stack1.get(DataComponents.BLOCK_ENTITY_DATA)).getUnsafe().getList("Item", 10).getCompound(0));
                if (i == 9) {
                    shouldBoom = true;
                    break;
                }
                if (!(displayCaseIn.getItem() instanceof DisplayCaseItem)) break;
                stack1 = displayCaseIn;
            }
            if (shouldBoom) {
                if (this.level != null) {
                    this.level.playSound(null, this.getBlockPos(), SoundEvents.GOAT_SCREAMING_DEATH, SoundSource.BLOCKS, 4.0f, 1.0f);
                }
                this.timeToBoom = 160;
            }
        }
        this.markUpdated();
        return true;
    }

    public void markUpdated() {
        this.setChanged();
        if (this.level != null) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider pRegistries) {
        return this.saveWithoutMetadata(pRegistries);
    }

    public void removeComponentsFromTag(CompoundTag pTag) {
        super.removeComponentsFromTag(pTag);
        pTag.remove("Rotation");
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider pRegistries) {
        super.saveAdditional(nbt, pRegistries);
        nbt.putInt("Rotation", this.rot);
        nbt.putBoolean("Waxed", this.waxed);
        ListTag listTag = new ListTag();
        listTag.add(0, (Tag)(!this.stack.isEmpty() ? this.stack.save(pRegistries) : new CompoundTag()));
        if (this.lidItem != null && !this.lidItem.isEmpty()) {
            listTag.add(1, this.lidItem.save(pRegistries));
        } else {
            CompoundTag lidTag = new CompoundTag();
            lidTag.putString("nothing", "");
            listTag.add(1, (Tag)lidTag);
        }
        nbt.put("Item", (Tag)listTag);
    }

    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider pRegistries) {
        super.loadAdditional(nbt, pRegistries);
        this.rot = nbt.getInt("Rotation");
        ListTag list = nbt.getList("Item", 10);
        this.stack = ItemStack.parseOptional((HolderLookup.Provider)pRegistries, (CompoundTag)list.getCompound(0));
        this.lidItem = list.getCompound(1).isEmpty() ? ModItems.DISPLAY_CASE_LID.getDefaultInstance() : (list.getCompound(1).contains("nothing") ? null : (ItemStack)ItemStack.parse((HolderLookup.Provider)pRegistries, (Tag)list.getCompound(1)).orElse(null));
        this.waxed = nbt.getBoolean("Waxed");
    }
}

