/*
 * Decompiled with CFR 0.152.
 */
package chappie.displaycase.common.items;

import chappie.displaycase.client.tile.DisplayCaseItemRenderer;
import chappie.displaycase.common.blocks.ModBlocks;
import chappie.displaycase.common.tile.DisplayCaseTileEntity;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;

public class DisplayCaseItem
extends BlockItem {
    public DisplayCaseItem() {
        super((Block)ModBlocks.DISPLAY_CASE, new Item.Properties());
    }

    public void inventoryTick(ItemStack itemStack, Level level, Entity entity, int slot, boolean selected) {
        super.inventoryTick(itemStack, level, entity, slot, selected);
        this.updateDisplayCase(level, itemStack);
    }

    public void updateDisplayCase(Level level, ItemStack itemStack) {
        if (level.isClientSide) {
            DisplayCaseTileEntity tile = DisplayCaseItemRenderer.ITEM_RENDERER.getDisplayCaseTileEntity();
            CompoundTag compoundtag = ((CustomData)itemStack.getOrDefault(DataComponents.BLOCK_ENTITY_DATA, (Object)CustomData.EMPTY)).getUnsafe();
            tile.loadWithComponents(compoundtag, (HolderLookup.Provider)level.registryAccess());
            tile.setLevel(level);
            tile.rotTick();
            BlockItem.setBlockEntityData((ItemStack)itemStack, (BlockEntityType)tile.getType(), (CompoundTag)tile.saveWithoutMetadata((HolderLookup.Provider)level.registryAccess()));
        }
    }
}

