/*
 * Decompiled with CFR 0.152.
 */
package chappie.displaycase.common.blocks;

import chappie.displaycase.common.criterions.PaintItemTrigger;
import chappie.displaycase.common.criterions.PutItemInDisplayCaseTrigger;
import chappie.displaycase.common.items.DisplayCaseLidItem;
import chappie.displaycase.common.tile.DisplayCaseTileEntity;
import chappie.displaycase.common.tile.ModTileEntities;
import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class DisplayCaseBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final VoxelShape SHAPE = Stream.of(Shapes.join((VoxelShape)Block.box((double)6.875, (double)14.024999999999988, (double)8.0, (double)9.125, (double)15.524999999999988, (double)8.0), (VoxelShape)Shapes.join((VoxelShape)Block.box((double)6.5, (double)13.424999999999994, (double)6.5, (double)9.5, (double)14.17499999999999, (double)9.5), (VoxelShape)Shapes.join((VoxelShape)Block.box((double)6.5625, (double)12.587499999999991, (double)6.5625, (double)9.4375, (double)13.212499999999988, (double)9.4375), (VoxelShape)Block.box((double)8.0, (double)14.024999999999988, (double)6.875, (double)8.0, (double)15.524999999999988, (double)9.125), (BooleanOp)BooleanOp.AND), (BooleanOp)BooleanOp.AND), (BooleanOp)BooleanOp.AND), Block.box((double)1.875, (double)1.2249999999999992, (double)1.875, (double)14.125, (double)13.47499999999999, (double)14.125), Block.box((double)2.0, (double)4.163336342344337E-17, (double)2.0, (double)14.0, (double)1.5, (double)14.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    public static final VoxelShape SHAPE_2 = Block.box((double)1.75, (double)0.0, (double)1.75, (double)14.25, (double)2.0, (double)14.25);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final MapCodec<DisplayCaseBlock> CODEC = DisplayCaseBlock.simpleCodec(DisplayCaseBlock::new);

    public DisplayCaseBlock(BlockBehaviour.Properties properties) {
        super(properties.mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).strength(0.5f));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected InteractionResult useWithoutItem(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, BlockHitResult pHitResult) {
        BlockEntity blockEntity;
        if (pPlayer instanceof ServerPlayer && (blockEntity = pLevel.getBlockEntity(pPos)) instanceof DisplayCaseTileEntity) {
            DisplayCaseTileEntity tile = (DisplayCaseTileEntity)blockEntity;
            if (pPlayer.isCrouching() && tile.hasLid()) {
                ItemStack lidItem = tile.getLidItem();
                tile.setLidItem(ItemStack.EMPTY);
                pPlayer.getInventory().placeItemBackInInventory(lidItem, true);
                return InteractionResult.SUCCESS;
            }
            if (!tile.getItem().isEmpty()) {
                if (!pPlayer.getAbilities().instabuild || pPlayer.isCrouching()) {
                    pPlayer.getInventory().placeItemBackInInventory(tile.getItem(), true);
                }
                tile.setItem(ItemStack.EMPTY);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.CONSUME;
    }

    protected ItemInteractionResult useItemOn(ItemStack pStack, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHitResult) {
        if (pPlayer instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)pPlayer;
            BlockEntity blockEntity = pLevel.getBlockEntity(pPos);
            if (blockEntity instanceof DisplayCaseTileEntity) {
                DisplayCaseTileEntity tile = (DisplayCaseTileEntity)blockEntity;
                if (!pStack.isEmpty()) {
                    CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger(serverPlayer, pPos, pStack);
                    if (!tile.hasLid() && pStack.getItem() instanceof DisplayCaseLidItem) {
                        tile.setLidItem(pStack.copyWithCount(1));
                        pStack.shrink(1);
                        return ItemInteractionResult.CONSUME;
                    }
                    if (tile.getItem().isEmpty()) {
                        ItemStack stack1 = pStack.copy();
                        if (tile.setItem(stack1)) {
                            if (!pPlayer.getAbilities().instabuild) {
                                pStack.shrink(1);
                            }
                            PutItemInDisplayCaseTrigger.INSTANCE.trigger(pPlayer, stack1);
                            return ItemInteractionResult.CONSUME;
                        }
                        return ItemInteractionResult.FAIL;
                    }
                    Item item = pStack.getItem();
                    if (item instanceof DyeItem) {
                        DyeItem item2 = (DyeItem)item;
                        if (tile.getColor() != item2.getDyeColor()) {
                            PaintItemTrigger.INSTANCE.trigger(serverPlayer);
                            tile.setColor(item2.getDyeColor());
                            if (!pPlayer.getAbilities().instabuild) {
                                pStack.shrink(1);
                            }
                            pLevel.playSound(pPlayer, pPos, SoundEvents.CALCITE_BREAK, SoundSource.BLOCKS, 1.0f, 1.0f);
                            return ItemInteractionResult.CONSUME;
                        }
                    }
                    if (tile.getColor() != null && pStack.getItem() == Items.WATER_BUCKET) {
                        tile.setColor(null);
                        if (!pPlayer.getAbilities().instabuild) {
                            pPlayer.setItemInHand(pHand, Items.BUCKET.getDefaultInstance());
                        }
                        pLevel.playSound(pPlayer, pPos, SoundEvents.BUCKET_EMPTY, SoundSource.BLOCKS, 1.0f, 1.0f);
                        pLevel.gameEvent((Entity)pPlayer, (Holder)GameEvent.FLUID_PLACE, pPos);
                        return ItemInteractionResult.CONSUME;
                    }
                    if (tile.isWaxed()) {
                        if (pStack.getItem() instanceof AxeItem) {
                            pLevel.playSound(null, pPos, SoundEvents.AXE_WAX_OFF, SoundSource.BLOCKS, 1.0f, 1.0f);
                            pLevel.levelEvent(null, 3004, pPos, 0);
                            pStack.hurtAndBreak(1, (LivingEntity)pPlayer, LivingEntity.getSlotForHand((InteractionHand)pHand));
                            tile.setWaxed(false);
                            if (pLevel.random.nextFloat() < 0.1f) {
                                pLevel.destroyBlock(pPos, false, (Entity)pPlayer);
                            }
                            return ItemInteractionResult.CONSUME;
                        }
                    } else if (pStack.getItem() instanceof HoneycombItem) {
                        if (!pPlayer.getAbilities().instabuild) {
                            pStack.shrink(1);
                        }
                        pLevel.levelEvent(null, 3003, pPos, 0);
                        tile.setWaxed(true);
                        return ItemInteractionResult.CONSUME;
                    }
                }
            }
        }
        return super.useItemOn(pStack, pState, pLevel, pPos, pPlayer, pHand, pHitResult);
    }

    public ItemStack getCloneItemStack(LevelReader world, BlockPos pos, BlockState state) {
        ItemStack itemstack = super.getCloneItemStack(world, pos, state);
        world.getBlockEntity(pos, ModTileEntities.DISPLAY_CASE).ifPresent(tile -> tile.saveToItem(itemstack, (HolderLookup.Provider)world.registryAccess()));
        return itemstack;
    }

    protected List<ItemStack> getDrops(BlockState pState, LootParams.Builder pParams) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        stacks.addAll(super.getDrops(pState, pParams));
        BlockEntity blockentity = (BlockEntity)pParams.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
        if (blockentity instanceof DisplayCaseTileEntity) {
            DisplayCaseTileEntity tile = (DisplayCaseTileEntity)blockentity;
            ItemStack itemstack = new ItemStack((ItemLike)this);
            tile.saveToItem(itemstack, (HolderLookup.Provider)pParams.getLevel().registryAccess());
            stacks.add(itemstack);
        }
        return stacks;
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState state1, LevelAccessor accessor, BlockPos pos, BlockPos pos1) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            accessor.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)accessor));
        }
        return super.updateShape(state, direction, state1, accessor, pos, pos1);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{WATERLOGGED});
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = this.defaultBlockState();
        if (state.canSurvive((LevelReader)context.getLevel(), context.getClickedPos())) {
            return (BlockState)state.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.getLevel().getFluidState(context.getClickedPos()).getType() == Fluids.WATER));
        }
        return null;
    }

    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        DisplayCaseTileEntity tile;
        BlockEntity blockEntity = getter.getBlockEntity(pos);
        if (blockEntity instanceof DisplayCaseTileEntity && !(tile = (DisplayCaseTileEntity)blockEntity).hasLid()) {
            return SHAPE_2;
        }
        return SHAPE;
    }

    public float getShadeBrightness(BlockState state, BlockGetter getter, BlockPos pos) {
        return 1.0f;
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new DisplayCaseTileEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return DisplayCaseBlock.createTickerHelper(type, ModTileEntities.DISPLAY_CASE, DisplayCaseTileEntity::tick);
    }
}

