/*
 * Decompiled with CFR 0.152.
 */
package chappie.displaycase;

import chappie.displaycase.CommonClass;
import chappie.displaycase.Constants;
import chappie.displaycase.common.blocks.ModBlocks;
import chappie.displaycase.common.items.ModItems;
import chappie.displaycase.common.recipe.ModRecipes;
import chappie.displaycase.common.tile.ModTileEntities;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Items;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.registries.RegisterEvent;

@Mod(value="display_case")
public class DisplayCaseMod {
    public DisplayCaseMod(IEventBus bus) {
        Constants.LOG.info("Hello NeoForge world!");
        CommonClass.init();
        bus.addListener(this::register);
        bus.addListener(this::buildContents);
    }

    private void register(RegisterEvent event) {
        event.register(Registries.BLOCK, helper -> ModBlocks.registerBlocks((t, r) -> helper.register(r, t)));
        event.register(Registries.ITEM, helper -> ModItems.registerItems((t, r) -> helper.register(r, t)));
        event.register(Registries.BLOCK_ENTITY_TYPE, helper -> ModTileEntities.registerTiles((t, r) -> helper.register(r, t)));
        event.register(Registries.RECIPE_SERIALIZER, helper -> ModRecipes.register((t, r) -> helper.register(r, t), CriteriaTriggers::register));
    }

    private void buildContents(BuildCreativeModeTabContentsEvent event) {
        if (event.getTab() == BuiltInRegistries.CREATIVE_MODE_TAB.get(CreativeModeTabs.FUNCTIONAL_BLOCKS)) {
            event.insertBefore(Items.LOOM.getDefaultInstance(), ModItems.DISPLAY_CASE.getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        }
    }
}

