/*
 * Decompiled with CFR 0.152.
 */
package com.github.eterdelta.crittersandcompanions.entity.brain;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;

public class SprintingFollowParentGoal
extends FollowOwnerGoal {
    private final TamableAnimal mob;
    private final double speedModifier;
    private final float sprintAtSqr;
    private int timeToRecalcPath;

    public SprintingFollowParentGoal(TamableAnimal mob, double speedModifier, float start, float sprintAt, float stop) {
        super(mob, 1.0, start, stop);
        this.mob = mob;
        this.speedModifier = speedModifier;
        this.sprintAtSqr = sprintAt * sprintAt;
    }

    public void tick() {
        boolean shouldTeleport = this.mob.shouldTryTeleportToOwner();
        LivingEntity owner = this.mob.getOwner();
        if (owner == null) {
            return;
        }
        if (!shouldTeleport) {
            this.mob.getLookControl().setLookAt((Entity)owner, 10.0f, (float)this.mob.getMaxHeadXRot());
        }
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = this.adjustedTickDelay(10);
            if (shouldTeleport) {
                this.mob.tryToTeleportToOwner();
            } else {
                double distance = this.mob.distanceToSqr((Entity)owner);
                double speed = distance >= (double)this.sprintAtSqr ? this.speedModifier : 1.0;
                this.mob.getNavigation().moveTo((Entity)owner, speed);
            }
        }
    }
}

