/*
 * Decompiled with CFR 0.152.
 */
package com.github.eterdelta.crittersandcompanions.entity;

import com.github.eterdelta.crittersandcompanions.extension.IGrapplingState;
import com.github.eterdelta.crittersandcompanions.network.CACPacketHandler;
import com.github.eterdelta.crittersandcompanions.network.ClientboundGrapplingStatePacket;
import com.github.eterdelta.crittersandcompanions.platform.Services;
import com.github.eterdelta.crittersandcompanions.registry.CACEntities;
import com.github.eterdelta.crittersandcompanions.registry.CACItems;
import java.util.OptionalInt;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class GrapplingHookEntity
extends ThrowableItemProjectile {
    protected boolean isStick;
    protected double stickLength;
    private boolean addedToWorld;

    public GrapplingHookEntity(EntityType<? extends GrapplingHookEntity> entityType, Level level) {
        super(entityType, level);
    }

    public GrapplingHookEntity(Player owner, ItemStack ownerStack, Level level) {
        this((EntityType<? extends GrapplingHookEntity>)((EntityType)CACEntities.GRAPPLING_HOOK.get()), level);
        this.moveTo(owner.getX(), owner.getEyeY(), owner.getZ(), owner.getYHeadRot(), owner.getXRot());
        this.setOwner((Entity)owner);
        this.setItem(ownerStack);
    }

    protected Item getDefaultItem() {
        return (Item)CACItems.GRAPPLING_HOOK.get();
    }

    public void tick() {
        super.tick();
        if (!this.addedToWorld) {
            this.updateOwnerState();
            this.addedToWorld = true;
        }
        double offsetLengthSqr = this.distanceToSqr(this.getOwner());
        Double maxDistance = (Double)Services.CONFIGS.common().grapplingHookMaxDistance.get();
        double maxDistanceSqr = maxDistance * maxDistance;
        if (!(this.level().isClientSide() || this.isFocused() && !(offsetLengthSqr > maxDistanceSqr))) {
            this.discard();
            return;
        }
        AABB collidableBox = this.getBoundingBox().inflate(0.25);
        Iterable collisions = this.level().getBlockCollisions((Entity)this, collidableBox);
        boolean willStick = false;
        for (VoxelShape shape : collisions) {
            if (shape.isEmpty() || !shape.bounds().intersects(collidableBox)) continue;
            willStick = true;
            break;
        }
        if (willStick && !this.isStick) {
            this.stickLength = offsetLengthSqr;
            this.playSound(SoundEvents.SLIME_SQUISH);
        }
        this.isStick = willStick;
        if (this.isStick && this.getOwner() != null) {
            if (offsetLengthSqr > this.stickLength) {
                Vec3 direction = this.position().subtract(this.getOwner().position()).normalize();
                Double maxSpeed = (Double)Services.CONFIGS.common().grapplingHookMaxSpeed.get();
                double scale = Math.min(maxSpeed, 0.01 * Math.sqrt(offsetLengthSqr));
                if (scale >= 0.0) {
                    this.getOwner().setDeltaMovement(this.getOwner().getDeltaMovement().add(direction.scale(scale)));
                    this.getOwner().hurtMarked = true;
                }
            }
            this.setDeltaMovement(0.0, 0.0, 0.0);
        } else {
            this.setDeltaMovement(this.getDeltaMovement().scale(0.98));
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.03, 0.0));
        }
        this.move(MoverType.SELF, this.getDeltaMovement());
    }

    public void remove(Entity.RemovalReason removalReason) {
        super.remove(removalReason);
        this.updateOwnerState();
    }

    public boolean shouldRenderAtSqrDistance(double distance) {
        return distance < 4096.0;
    }

    public void pull() {
        if (this.getOwner() != null) {
            if (this.isStick) {
                double pullSpeed = (Double)Services.CONFIGS.common().grapplingHookSpeed.get() / 4.0;
                Double maxSpeed = (Double)Services.CONFIGS.common().grapplingHookMaxSpeed.get();
                Vec3 direction = this.position().subtract(this.getOwner().position()).normalize();
                float distance = this.distanceTo(this.getOwner());
                this.getOwner().setDeltaMovement(direction.scale(Math.min(maxSpeed, pullSpeed * (double)distance)));
            }
            this.discard();
        }
    }

    public void updateOwnerState() {
        Entity entity;
        if (!this.level().isClientSide() && this.getOwner() != null && (entity = this.getOwner()) instanceof Player) {
            Player player = (Player)entity;
            entity = this.getOwner();
            if (entity instanceof IGrapplingState) {
                IGrapplingState grapplingState = (IGrapplingState)entity;
                grapplingState.setHook(this.isAlive() ? this : null);
                CACPacketHandler.GRAPPLING_STATE.sendToTracking((Entity)player, new ClientboundGrapplingStatePacket(this.isAlive() ? OptionalInt.of(this.getId()) : OptionalInt.empty(), player.getId()));
            }
        }
    }

    public boolean isFocused() {
        Entity entity = this.getOwner();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return ItemStack.isSameItemSameComponents((ItemStack)player.getMainHandItem(), (ItemStack)this.getItem()) || ItemStack.isSameItemSameComponents((ItemStack)player.getOffhandItem(), (ItemStack)this.getItem());
        }
        return false;
    }
}

