/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.reliquified_ars_nouveau.network.packets;

import com.hollingsworth.arsnouveau.common.capability.ManaCap;
import it.hurts.octostudios.reliquified_ars_nouveau.init.ItemRegistry;
import it.hurts.octostudios.reliquified_ars_nouveau.items.back.WhirlingBroomItem;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record ActivatedBoostBroomPacket(boolean toggled) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ActivatedBoostBroomPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"reliquified_ars_nouveau", (String)"flying_boost"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ActivatedBoostBroomPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, ActivatedBoostBroomPacket::toggled, ActivatedBoostBroomPacket::new);

    public void handle(IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Player player = ctx.player();
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ItemRegistry.WHIRLING_BROOM.value()));
            Item patt0$temp = stack.getItem();
            if (!(patt0$temp instanceof WhirlingBroomItem)) {
                return;
            }
            WhirlingBroomItem relic = (WhirlingBroomItem)patt0$temp;
            ManaCap mana = new ManaCap((LivingEntity)player);
            double manaCostInTick = relic.getStatValue(stack, "broom", "manacost") / 10.0;
            if (this.toggled && mana.getCurrentMana() >= manaCostInTick) {
                if (!player.isCreative()) {
                    mana.removeMana(manaCostInTick);
                }
                relic.setToggled(stack, true);
            } else {
                relic.setToggled(stack, false);
            }
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

