/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.reliquified_ars_nouveau.mixin;

import it.hurts.octostudios.reliquified_ars_nouveau.entities.MagicShellEntity;
import it.hurts.octostudios.reliquified_ars_nouveau.init.EntityRegistry;
import it.hurts.octostudios.reliquified_ars_nouveau.init.ItemRegistry;
import it.hurts.octostudios.reliquified_ars_nouveau.items.bracelet.BallistarianBracerItem;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Projectile.class})
public class ProjectileMixin {
    @Inject(method={"shoot"}, at={@At(value="HEAD")})
    private void onEntityInside(CallbackInfo ci) {
        BallistarianBracerItem relic;
        Player player;
        Projectile projectile = (Projectile)this;
        Entity entity = projectile.getOwner();
        if (!(entity instanceof Player) || (player = (Player)entity).getCommandSenderWorld().isClientSide() || !(projectile instanceof AbstractArrow)) {
            return;
        }
        ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ItemRegistry.BALLISTARIAN_BRACER.value()));
        Item item = stack.getItem();
        if (!(item instanceof BallistarianBracerItem) || (relic = (BallistarianBracerItem)item).getUUIDListFromComponents(stack).isEmpty()) {
            return;
        }
        ServerLevel level = (ServerLevel)player.getCommandSenderWorld();
        ListTag uuidListTag = new ListTag();
        RandomSource random = projectile.getRandom();
        for (UUID uuidBow : relic.getUUIDListFromComponents(stack)) {
            Entity bow = level.getEntity(uuidBow);
            if (bow == null || !bow.isAlive() || (double)random.nextFloat() >= relic.getStatValue(stack, "striker", "chance")) continue;
            MagicShellEntity shell = new MagicShellEntity((EntityType<? extends ThrowableProjectile>)((EntityType)EntityRegistry.MAGIC_SHELL.value()), (Level)level);
            shell.getPersistentData().putUUID("TargetUUID", projectile.getUUID());
            shell.getPersistentData().putInt("BowIndex", relic.getUUIDListFromComponents(stack).indexOf(uuidBow));
            shell.setOwner((Entity)player);
            shell.setPos(bow.getEyePosition(0.0f).add(0.0, -0.5, 0.0));
            shell.setDeltaMovement(bow.getLookAngle().normalize().scale(0.6));
            shell.setDamage(Math.round(relic.getStatValue(stack, "striker", "damage")));
            level.addFreshEntity((Entity)shell);
            CompoundTag uuidTag = new CompoundTag();
            uuidTag.putLong("MostSigBits", shell.getUUID().getMostSignificantBits());
            uuidTag.putLong("LeastSigBits", shell.getUUID().getLeastSignificantBits());
            uuidListTag.add((Object)uuidTag);
        }
        projectile.getPersistentData().put("ShellUUIDs", (Tag)uuidListTag);
    }
}

