/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client.gui.button;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import sonar.fluxnetworks.client.gui.EnumNavigationTab;
import sonar.fluxnetworks.client.gui.basic.GuiButtonCore;
import sonar.fluxnetworks.client.gui.basic.GuiFocusable;

public class NavigationButton
extends GuiButtonCore {
    private final EnumNavigationTab mTab;
    private boolean mSelected = false;

    public NavigationButton(GuiFocusable screen, int x, int y, EnumNavigationTab tab) {
        super(screen, x, y, 16, 16);
        this.mTab = tab;
    }

    @Override
    protected void drawButton(GuiGraphics gr, int mouseX, int mouseY, float deltaTicks) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        boolean hovered = this.isMouseHovered(mouseX, mouseY);
        if (this.mClickable) {
            if (this.mSelected || hovered) {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            } else {
                RenderSystem.setShaderColor((float)0.7f, (float)0.7f, (float)0.7f, (float)1.0f);
            }
        } else {
            RenderSystem.setShaderColor((float)0.5f, (float)0.5f, (float)0.5f, (float)1.0f);
        }
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)GuiFocusable.ICON);
        GuiFocusable.blitF(gr, this.x, this.y, this.width, this.height, 64 * this.mTab.ordinal(), 192.0f, 64.0f, 64.0f);
        if (hovered && this.mClickable) {
            gr.drawCenteredString(this.screen.getMinecraft().font, this.mTab.getTranslatedName(), this.x + this.width / 2, this.y - 10, -1);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public EnumNavigationTab getTab() {
        return this.mTab;
    }

    public boolean isSelected() {
        return this.mSelected;
    }

    public void setSelected(boolean selected) {
        this.mSelected = selected;
    }
}

