/*
 * Decompiled with CFR 0.152.
 */
package com.agent772.createshufflefilter.mixins;

import com.agent772.createshufflefilter.CreateShuffleFilter;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.kinetics.deployer.DeployerFakePlayer;
import com.simibubi.create.content.kinetics.deployer.DeployerMovementBehaviour;
import com.simibubi.create.content.logistics.filter.FilterItemStack;
import com.simibubi.create.foundation.item.ItemHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.CombinedInvWrapper;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={DeployerMovementBehaviour.class})
public class MixinDeployerMovementBehaviour {
    @Shadow
    private DeployerFakePlayer getPlayer(MovementContext context) {
        throw new AssertionError();
    }

    @Inject(method={"tryGrabbingItem"}, at={@At(value="HEAD")}, cancellable=true)
    private void onTryGrabbingItem(MovementContext context, CallbackInfo ci) {
        ItemStack chosen;
        boolean isShuffleFilter;
        Level world = context.world;
        if (world.isClientSide) {
            return;
        }
        FilterItemStack filter = context.getFilterFromBE();
        boolean bl = isShuffleFilter = filter != null && !filter.item().isEmpty() && filter.item().getItem() == CreateShuffleFilter.SHUFFLE_FILTER.get();
        if (!isShuffleFilter) {
            return;
        }
        DeployerFakePlayer player = this.getPlayer(context);
        if (player == null || !player.getMainHandItem().isEmpty()) {
            return;
        }
        CombinedInvWrapper inv = context.contraption.getStorage().getAllItems();
        if (inv == null) {
            return;
        }
        ArrayList<ItemStack> candidates = new ArrayList<ItemStack>();
        for (int slot = 0; slot < inv.getSlots(); ++slot) {
            ItemStack s = inv.getStackInSlot(slot);
            if (s.isEmpty() || filter == null || !filter.test(world, s)) continue;
            boolean found = false;
            for (ItemStack c : candidates) {
                if (!ItemStack.isSameItemSameComponents((ItemStack)c, (ItemStack)s)) continue;
                found = true;
                break;
            }
            if (found) continue;
            candidates.add(s.copy());
        }
        if (candidates.isEmpty()) {
            return;
        }
        boolean useWeightedMode = false;
        if (filter != null) {
            try {
                ItemStack filterItem = filter.item();
                DataComponentMap components = filterItem.getComponents();
                String componentsStr = components.toString();
                if (componentsStr.contains("create:filter_items_respect_nbt=>")) {
                    String valueStr;
                    int n;
                    int n2;
                    int startIndex = componentsStr.indexOf("create:filter_items_respect_nbt=>") + "create:filter_items_respect_nbt=>".length();
                    String string = componentsStr.substring(startIndex);
                    int n3 = string.indexOf(44);
                    if (n3 == -1) {
                        n2 = string.indexOf(125);
                    }
                    if (n2 == -1) {
                        n = string.length();
                    }
                    if ((valueStr = string.substring(0, n).trim()).equals("true")) {
                        useWeightedMode = false;
                    } else if (valueStr.equals("false")) {
                        useWeightedMode = true;
                    }
                }
            }
            catch (Exception filterItem) {
                // empty catch block
            }
        }
        if (candidates.size() == 1) {
            chosen = (ItemStack)candidates.get(0);
        } else {
            RandomSource r = world.getRandom();
            if (useWeightedMode) {
                HashMap<ItemStack, Integer> stackCounts = new HashMap<ItemStack, Integer>();
                for (ItemStack itemStack : candidates) {
                    int n = 0;
                    for (int slot = 0; slot < inv.getSlots(); ++slot) {
                        ItemStack s = inv.getStackInSlot(slot);
                        if (s.isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)s, (ItemStack)itemStack)) continue;
                        ++n;
                    }
                    stackCounts.put(itemStack, n);
                }
                ArrayList<ItemStack> weightedList = new ArrayList<ItemStack>();
                for (Map.Entry entry : stackCounts.entrySet()) {
                    for (int i = 0; i < (Integer)entry.getValue(); ++i) {
                        weightedList.add((ItemStack)entry.getKey());
                    }
                }
                int n = r.nextInt(weightedList.size());
                chosen = (ItemStack)weightedList.get(n);
            } else {
                int randomIndex = r.nextInt(candidates.size());
                chosen = (ItemStack)candidates.get(randomIndex);
            }
        }
        ItemStack held = ItemHelper.extract((IItemHandler)inv, stack -> ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)chosen), (int)1, (boolean)false);
        player.setItemInHand(InteractionHand.MAIN_HAND, held);
        ci.cancel();
    }
}

