/*
 * Decompiled with CFR 0.152.
 */
package com.frikinjay.letmedespawn.command;

import com.frikinjay.letmedespawn.LetMeDespawn;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.concurrent.CompletableFuture;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.MobCategory;

public class LetMeDespawnCommands {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"letmedespawn").requires(source -> source.hasPermission(2))).then(Commands.literal((String)"add").then(Commands.argument((String)"mobName", (ArgumentType)StringArgumentType.greedyString()).suggests(LetMeDespawnCommands::suggestMobNames).executes(LetMeDespawnCommands::addMob)))).then(Commands.literal((String)"remove").then(Commands.argument((String)"mobName", (ArgumentType)StringArgumentType.greedyString()).suggests(LetMeDespawnCommands::suggestConfiguredMobNames).executes(LetMeDespawnCommands::removeMob)))).then(Commands.literal((String)"addPersistenceEnabler").then(Commands.argument((String)"itemName", (ArgumentType)StringArgumentType.greedyString()).suggests(LetMeDespawnCommands::suggestItems).executes(LetMeDespawnCommands::addItem)))).then(Commands.literal((String)"removePersistenceEnabler").then(Commands.argument((String)"itemName", (ArgumentType)StringArgumentType.greedyString()).suggests(LetMeDespawnCommands::suggestConfiguredItems).executes(LetMeDespawnCommands::removeItem))));
    }

    private static CompletableFuture<Suggestions> suggestMobNames(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        BuiltInRegistries.ENTITY_TYPE.forEach(entityType -> {
            if (entityType.getCategory().equals((Object)MobCategory.MONSTER)) {
                builder.suggest(BuiltInRegistries.ENTITY_TYPE.getKey(entityType).toString());
            }
        });
        return builder.buildFuture();
    }

    private static CompletableFuture<Suggestions> suggestConfiguredMobNames(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        LetMeDespawn.config.getMobNames().stream().filter(mobName -> mobName.startsWith(builder.getRemaining())).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    }

    private static int addMob(CommandContext<CommandSourceStack> context) {
        String mobName = StringArgumentType.getString(context, (String)"mobName");
        if (LetMeDespawn.config.getMobNames().contains(mobName)) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Mob '" + mobName + "' is already in the configuration.")).withStyle(ChatFormatting.RED), false);
        } else {
            LetMeDespawn.config.addMobName(mobName);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Added '" + mobName + "' to LetMeDespawn configuration.")).withStyle(ChatFormatting.AQUA), true);
        }
        return 1;
    }

    private static int removeMob(CommandContext<CommandSourceStack> context) {
        String mobName = StringArgumentType.getString(context, (String)"mobName");
        if (LetMeDespawn.config.getMobNames().contains(mobName)) {
            LetMeDespawn.config.removeMobName(mobName);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Removed '" + mobName + "' from LetMeDespawn configuration.")).withStyle(ChatFormatting.GOLD), true);
        } else {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Mob '" + mobName + "' is not in the configuration.")).withStyle(ChatFormatting.RED), false);
        }
        return 1;
    }

    private static CompletableFuture<Suggestions> suggestItems(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        BuiltInRegistries.ITEM.forEach(item -> builder.suggest(BuiltInRegistries.ITEM.getKey(item).toString()));
        return builder.buildFuture();
    }

    private static CompletableFuture<Suggestions> suggestConfiguredItems(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        LetMeDespawn.config.getPersistenceEnablers().stream().filter(itemName -> itemName.startsWith(builder.getRemaining())).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    }

    private static int addItem(CommandContext<CommandSourceStack> context) {
        String itemName = StringArgumentType.getString(context, (String)"itemName");
        if (LetMeDespawn.config.getPersistenceEnablers().contains(itemName)) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Item '" + itemName + "' is already a persistence enabler.")).withStyle(ChatFormatting.RED), false);
        } else {
            LetMeDespawn.config.addPersistenceEnabler(itemName);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Added '" + itemName + "' to persistence enablers.")).withStyle(ChatFormatting.AQUA), true);
        }
        return 1;
    }

    private static int removeItem(CommandContext<CommandSourceStack> context) {
        String itemName = StringArgumentType.getString(context, (String)"itemName");
        if (LetMeDespawn.config.getPersistenceEnablers().contains(itemName)) {
            LetMeDespawn.config.removePersistenceEnabler(itemName);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Removed '" + itemName + "' from persistence enablers.")).withStyle(ChatFormatting.GOLD), true);
        } else {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Item '" + itemName + "' is not a persistence enabler.")).withStyle(ChatFormatting.RED), false);
        }
        return 1;
    }
}

