/*
 * Decompiled with CFR 0.152.
 */
package com.bobvarioa.kubejsarsnouveau.components;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.latvian.mods.kubejs.recipe.RecipeScriptContext;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponentType;
import dev.latvian.mods.kubejs.recipe.component.SimpleRecipeComponent;
import dev.latvian.mods.kubejs.recipe.filter.RecipeMatchContext;
import dev.latvian.mods.kubejs.recipe.match.Replaceable;
import dev.latvian.mods.kubejs.recipe.match.ReplacementMatch;
import dev.latvian.mods.kubejs.recipe.match.ReplacementMatchInfo;
import dev.latvian.mods.rhino.type.TypeInfo;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public class ArsComponents {
    public static RecipeComponentType<CrushItem> CRUSH_OUTPUT = RecipeComponentType.unit((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"ars_nouveau", (String)"crush_item"), CrushItemComponent::new);
    public static RecipeComponentType<Sound> SOUND = RecipeComponentType.unit((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"ars_nouveau", (String)"sound"), SoundComponent::new);
    public static RecipeComponentType<Color> COLOR = RecipeComponentType.unit((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"ars_nouveau", (String)"color"), ColorComponent::new);

    public static class SoundComponent
    extends SimpleRecipeComponent<Sound> {
        public SoundComponent(RecipeComponentType<?> type) {
            super(type, Sound.CODEC, TypeInfo.of(Sound.class));
        }
    }

    public record Sound(Optional<String> family, Optional<Float> volume, Optional<Float> pitch) {
        public static Codec<Sound> CODEC = Codec.lazyInitialized(() -> RecordCodecBuilder.create(o -> o.group((App)Codec.withAlternative((Codec)Codec.STRING, SoundFamily.FAMILY_CODEC, v -> v.id).optionalFieldOf("sound").forGetter(Sound::family), (App)Codec.FLOAT.optionalFieldOf("volume").forGetter(Sound::volume), (App)Codec.FLOAT.optionalFieldOf("pitch").forGetter(Sound::pitch)).apply((Applicative)o, Sound::new)));
    }

    public record SoundFamily(String id) {
        public static Codec<SoundFamily> FAMILY_CODEC = RecordCodecBuilder.create(o -> o.group((App)Codec.STRING.fieldOf("id").forGetter(SoundFamily::id)).apply((Applicative)o, SoundFamily::new));
    }

    public static class ColorComponent
    extends SimpleRecipeComponent<Color> {
        public ColorComponent(RecipeComponentType<?> type) {
            super(type, Color.CODEC, TypeInfo.of(Color.class));
        }
    }

    public record Color(String id, int r, int g, int b) {
        public static Codec<Color> CODEC = Codec.lazyInitialized(() -> RecordCodecBuilder.create(o -> o.group((App)Codec.STRING.fieldOf("id").forGetter(Color::id), (App)Codec.INT.fieldOf("r").forGetter(Color::r), (App)Codec.INT.fieldOf("g").forGetter(Color::g), (App)Codec.INT.fieldOf("b").forGetter(Color::b)).apply((Applicative)o, Color::new)));
    }

    public static class CrushItemComponent
    extends SimpleRecipeComponent<CrushItem>
    implements Replaceable {
        public CrushItemComponent(RecipeComponentType<?> type) {
            super(type, CrushItem.CODEC, TypeInfo.of(CrushItem.class));
        }

        public boolean matches(RecipeMatchContext cx, CrushItem value, ReplacementMatchInfo match) {
            Ingredient in;
            ReplacementMatch mat = match.match();
            ReplacementMatch replacementMatch = mat;
            if (replacementMatch instanceof Ingredient && (in = (Ingredient)replacementMatch).test(value.stack)) {
                return true;
            }
            return super.matches(cx, (Object)value, match);
        }

        public CrushItem replace(RecipeScriptContext cx, CrushItem original, ReplacementMatchInfo match, Object with) {
            if (with instanceof ItemStack) {
                ItemStack stack = (ItemStack)with;
                return new CrushItem(stack, 1.0f, 1.0);
            }
            return this.matches((RecipeMatchContext)cx, original, match) ? (CrushItem)super.replaceThisWith(cx, with) : original;
        }
    }

    public record CrushItem(ItemStack stack, float chance, double maxRange) {
        public static Codec<CrushItem> CODEC = Codec.lazyInitialized(() -> RecordCodecBuilder.create(o -> o.group((App)Codec.withAlternative((Codec)ItemStack.CODEC, (Codec)ItemStack.SIMPLE_ITEM_CODEC).fieldOf("stack").forGetter(CrushItem::stack), (App)Codec.FLOAT.fieldOf("chance").forGetter(CrushItem::chance), (App)Codec.DOUBLE.fieldOf("maxRange").forGetter(CrushItem::maxRange)).apply((Applicative)o, CrushItem::new)));
    }
}

