/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.trashcans;

import com.supermartijn642.core.CommonUtils;
import com.supermartijn642.core.block.BaseBlockEntity;
import com.supermartijn642.core.block.TickableBlockEntity;
import com.supermartijn642.core.util.TriFunction;
import com.supermartijn642.trashcans.compat.Compatibility;
import com.supermartijn642.trashcans.filter.ItemFilter;
import com.supermartijn642.trashcans.filter.LiquidTrashCanFilters;
import com.supermartijn642.trashcans.screen.DummySlot;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;

public class TrashCanBlockEntity
extends BaseBlockEntity
implements TickableBlockEntity {
    public static final int DEFAULT_ENERGY_LIMIT = 10000;
    public static final int MAX_ENERGY_LIMIT = 10000000;
    public static final int MIN_ENERGY_LIMIT = 1;
    public final IItemHandler ITEM_HANDLER = new IItemHandlerModifiable(){

        public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        }

        public int getSlots() {
            return 1;
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return ItemStack.EMPTY;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            for (ItemStack filter : TrashCanBlockEntity.this.itemFilter) {
                if (filter.isEmpty() || !ItemStack.isSameItem((ItemStack)stack, (ItemStack)filter)) continue;
                return TrashCanBlockEntity.this.itemFilterWhitelist ? ItemStack.EMPTY : stack;
            }
            return TrashCanBlockEntity.this.itemFilterWhitelist ? stack : ItemStack.EMPTY;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.EMPTY;
        }

        public int getSlotLimit(int slot) {
            return Integer.MAX_VALUE;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            for (ItemStack filter : TrashCanBlockEntity.this.itemFilter) {
                if (filter.isEmpty() || !ItemStack.isSameItem((ItemStack)stack, (ItemStack)filter)) continue;
                return TrashCanBlockEntity.this.itemFilterWhitelist;
            }
            return !TrashCanBlockEntity.this.itemFilterWhitelist;
        }
    };
    public final IFluidHandler FLUID_HANDLER = new IFluidHandler(){

        public int getTanks() {
            return 1;
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            return FluidStack.EMPTY;
        }

        public int getTankCapacity(int tank) {
            return Integer.MAX_VALUE;
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            for (ItemFilter filter : TrashCanBlockEntity.this.liquidFilter) {
                if (filter == null || !filter.matches(stack)) continue;
                return TrashCanBlockEntity.this.liquidFilterWhitelist;
            }
            return !TrashCanBlockEntity.this.liquidFilterWhitelist;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            for (ItemFilter filter : TrashCanBlockEntity.this.liquidFilter) {
                if (filter == null || !filter.matches(resource)) continue;
                return TrashCanBlockEntity.this.liquidFilterWhitelist ? resource.getAmount() : 0;
            }
            return TrashCanBlockEntity.this.liquidFilterWhitelist ? 0 : resource.getAmount();
        }

        @Nonnull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            return FluidStack.EMPTY;
        }

        @Nonnull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            return FluidStack.EMPTY;
        }
    };
    public final TriFunction<Integer, Integer, Integer, Slot> LIQUID_ITEM_HANDLER = (slot, x, y) -> new DummySlot((int)slot, (int)x, (int)y){

        public boolean mayPlace(ItemStack stack) {
            return this.isItemValid(stack);
        }

        @Override
        public ItemStack getItem() {
            return TrashCanBlockEntity.this.liquidItem;
        }

        @Override
        public void set(ItemStack stack) {
            TrashCanBlockEntity.this.liquidItem = stack.copy();
            TrashCanBlockEntity.this.liquidItem.setCount(1);
            TrashCanBlockEntity.this.dataChanged();
        }

        @Override
        public void setChanged() {
        }

        @Override
        public int getMaxStackSize() {
            return 1;
        }

        @Override
        public ItemStack remove(int count) {
            ItemStack result = TrashCanBlockEntity.this.liquidItem.split(count);
            TrashCanBlockEntity.this.dataChanged();
            return result;
        }

        public boolean isItemValid(ItemStack stack) {
            boolean filtered = !TrashCanBlockEntity.this.liquidFilterWhitelist;
            for (ItemFilter filter : TrashCanBlockEntity.this.liquidFilter) {
                if (filter == null || !filter.matches(stack)) continue;
                filtered = TrashCanBlockEntity.this.liquidFilterWhitelist;
                break;
            }
            if (!filtered) {
                return false;
            }
            IFluidHandlerItem handler = (IFluidHandlerItem)stack.getCapability(Capabilities.FluidHandler.ITEM);
            if (handler != null) {
                for (int tank = 0; tank < handler.getTanks(); ++tank) {
                    if (handler.getFluidInTank(tank).isEmpty()) continue;
                    return true;
                }
            }
            return Compatibility.MEKANISM.doesItemHaveGasStored(stack);
        }
    };
    public final IEnergyStorage ENERGY_STORAGE = new IEnergyStorage(){

        public int receiveEnergy(int maxReceive, boolean simulate) {
            return TrashCanBlockEntity.this.useEnergyLimit ? Math.min(maxReceive, TrashCanBlockEntity.this.energyLimit) : maxReceive;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return 0;
        }

        public int getEnergyStored() {
            return 0;
        }

        public int getMaxEnergyStored() {
            return Integer.MAX_VALUE;
        }

        public boolean canExtract() {
            return false;
        }

        public boolean canReceive() {
            return true;
        }
    };
    public final TriFunction<Integer, Integer, Integer, Slot> ENERGY_ITEM_HANDLER = (slot, x, y) -> new DummySlot((int)slot, (int)x, (int)y){

        public boolean mayPlace(ItemStack stack) {
            return this.isItemValid(stack);
        }

        @Override
        public ItemStack getItem() {
            return TrashCanBlockEntity.this.energyItem;
        }

        @Override
        public void set(ItemStack stack) {
            TrashCanBlockEntity.this.energyItem = stack.copy();
            TrashCanBlockEntity.this.energyItem.setCount(1);
            TrashCanBlockEntity.this.dataChanged();
        }

        @Override
        public void setChanged() {
        }

        @Override
        public int getMaxStackSize() {
            return 1;
        }

        @Override
        public ItemStack remove(int count) {
            ItemStack result = TrashCanBlockEntity.this.energyItem.split(count);
            TrashCanBlockEntity.this.dataChanged();
            return result;
        }

        public boolean isItemValid(ItemStack stack) {
            return stack.getCapability(Capabilities.ItemHandler.ITEM) != null;
        }
    };
    public final boolean items;
    public final ArrayList<ItemStack> itemFilter = new ArrayList();
    public boolean itemFilterWhitelist = false;
    public final boolean liquids;
    public final ArrayList<ItemFilter> liquidFilter = new ArrayList();
    public boolean liquidFilterWhitelist = false;
    public ItemStack liquidItem = ItemStack.EMPTY;
    public final boolean energy;
    public int energyLimit = 10000;
    public boolean useEnergyLimit = false;
    public ItemStack energyItem = ItemStack.EMPTY;

    public TrashCanBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state, boolean items, boolean liquids, boolean energy) {
        super(blockEntityType, pos, state);
        this.items = items;
        this.liquids = liquids;
        this.energy = energy;
        for (int i = 0; i < 9; ++i) {
            this.itemFilter.add(ItemStack.EMPTY);
            this.liquidFilter.add(null);
        }
    }

    public void update() {
        IEnergyStorage energyStorage;
        if (this.liquids && !this.liquidItem.isEmpty() && this.liquidItem.getItem() != Items.BUCKET) {
            IFluidHandlerItem fluidHandler = (IFluidHandlerItem)this.liquidItem.getCapability(Capabilities.FluidHandler.ITEM);
            if (fluidHandler != null) {
                boolean changed = false;
                for (int tank = 0; tank < fluidHandler.getTanks(); ++tank) {
                    if (fluidHandler.getFluidInTank(tank).isEmpty()) continue;
                    fluidHandler.drain(fluidHandler.getFluidInTank(tank), IFluidHandler.FluidAction.EXECUTE);
                    changed = true;
                }
                if (changed) {
                    this.liquidItem = fluidHandler.getContainer();
                    this.dataChanged();
                }
            }
            if (Compatibility.MEKANISM.drainGasFromItem(this.liquidItem)) {
                this.dataChanged();
            }
        }
        if (this.energy && !this.energyItem.isEmpty() && (energyStorage = (IEnergyStorage)this.energyItem.getCapability(Capabilities.EnergyStorage.ITEM)) != null) {
            energyStorage.extractEnergy(energyStorage.getEnergyStored(), false);
            this.dataChanged();
        }
    }

    public boolean isRegularItemValid(ItemStack stack) {
        for (ItemStack filter : this.itemFilter) {
            if (filter.isEmpty() || !ItemStack.isSameItem((ItemStack)stack, (ItemStack)filter)) continue;
            return this.itemFilterWhitelist;
        }
        return !this.itemFilterWhitelist;
    }

    protected CompoundTag writeData() {
        int i;
        if (this.level.isClientSide) {
            return new CompoundTag();
        }
        CompoundTag tag = new CompoundTag();
        if (this.items) {
            for (i = 0; i < this.itemFilter.size(); ++i) {
                tag.put("itemFilter" + i, this.itemFilter.get(i).saveOptional((HolderLookup.Provider)this.level.registryAccess()));
            }
            tag.putBoolean("itemFilterWhitelist", this.itemFilterWhitelist);
        }
        if (this.liquids) {
            for (i = 0; i < this.liquidFilter.size(); ++i) {
                if (this.liquidFilter.get(i) == null) continue;
                tag.put("liquidFilter" + i, (Tag)LiquidTrashCanFilters.write(this.liquidFilter.get(i), (HolderLookup.Provider)this.level.registryAccess()));
            }
            tag.putBoolean("liquidFilterWhitelist", this.liquidFilterWhitelist);
            if (!this.liquidItem.isEmpty()) {
                tag.put("liquidItem", this.liquidItem.saveOptional((HolderLookup.Provider)this.level.registryAccess()));
            }
        }
        if (this.energy) {
            tag.putBoolean("useEnergyLimit", this.useEnergyLimit);
            tag.putInt("energyLimit", this.energyLimit);
            if (!this.energyItem.isEmpty()) {
                tag.put("energyItem", this.energyItem.saveOptional((HolderLookup.Provider)this.level.registryAccess()));
            }
        }
        return tag;
    }

    protected void readData(CompoundTag tag) {
        int i;
        if (this.items) {
            for (i = 0; i < this.itemFilter.size(); ++i) {
                this.itemFilter.set(i, tag.contains("itemFilter" + i) ? ItemStack.parseOptional((HolderLookup.Provider)CommonUtils.getRegistryAccess(), (CompoundTag)tag.getCompound("itemFilter" + i)) : ItemStack.EMPTY);
            }
            boolean bl = this.itemFilterWhitelist = tag.contains("itemFilterWhitelist") && tag.getBoolean("itemFilterWhitelist");
        }
        if (this.liquids) {
            for (i = 0; i < this.liquidFilter.size(); ++i) {
                this.liquidFilter.set(i, tag.contains("liquidFilter" + i) ? LiquidTrashCanFilters.read(tag.getCompound("liquidFilter" + i), (HolderLookup.Provider)CommonUtils.getRegistryAccess()) : null);
            }
            this.liquidFilterWhitelist = tag.contains("liquidFilterWhitelist") && tag.getBoolean("liquidFilterWhitelist");
            ItemStack itemStack = this.liquidItem = tag.contains("liquidItem") ? ItemStack.parseOptional((HolderLookup.Provider)CommonUtils.getRegistryAccess(), (CompoundTag)tag.getCompound("liquidItem")) : ItemStack.EMPTY;
        }
        if (this.energy) {
            this.useEnergyLimit = tag.contains("useEnergyLimit") && tag.getBoolean("useEnergyLimit");
            this.energyLimit = tag.contains("energyLimit") ? tag.getInt("energyLimit") : 10000;
            this.energyItem = tag.contains("energyItem") ? ItemStack.parseOptional((HolderLookup.Provider)CommonUtils.getRegistryAccess(), (CompoundTag)tag.getCompound("energyItem")) : ItemStack.EMPTY;
        }
    }
}

