/*
 * Decompiled with CFR 0.152.
 */
package dev.qther.ars_unification.recipe;

import com.hollingsworth.arsnouveau.common.crafting.recipes.CrushRecipe;
import dev.qther.ars_unification.ArsUnification;
import dev.qther.ars_unification.recipe.CutRecipe;
import dev.qther.ars_unification.recipe.PressRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;

public abstract class RecipeWrapper<R extends Recipe<?>, O> {
    public ResourceLocation path;
    public Ingredient ing;
    List<O> outputs = new ArrayList<O>();

    public RecipeWrapper(String string, Ingredient ingredient) {
        this.path = ArsUnification.prefix(string);
        this.ing = ingredient;
    }

    RecipeWrapper(String prefix, ResourceLocation location, Ingredient ingredient) {
        this.path = ArsUnification.prefix(prefix + "/" + location.getNamespace() + "/" + location.getPath());
        this.ing = ingredient;
    }

    public abstract RecipeWrapper<R, O> withItems(ItemStack var1, float var2);

    public abstract RecipeWrapper<R, O> withItems(ItemStack var1);

    public abstract R asRecipe();

    public RecipeHolder<R> asHolder() {
        return new RecipeHolder(this.path, this.asRecipe());
    }

    public static class Press
    extends RecipeWrapper<PressRecipe, PressRecipe.PressOutput> {
        public Press(ResourceLocation location, Ingredient ingredient) {
            super("press", location, ingredient);
        }

        public Press withItems(ItemStack output, float chance) {
            if (output.isEmpty()) {
                return this;
            }
            this.outputs.add(new PressRecipe.PressOutput(output, chance));
            return this;
        }

        public Press withItems(ItemStack output) {
            if (output.isEmpty()) {
                return this;
            }
            this.outputs.add(new PressRecipe.PressOutput(output, 1.0f));
            return this;
        }

        @Override
        public PressRecipe asRecipe() {
            return new PressRecipe(this.ing, this.outputs);
        }
    }

    public static class Cut
    extends RecipeWrapper<CutRecipe, CutRecipe.CutOutput> {
        public Cut(ResourceLocation location, Ingredient ingredient) {
            super("cut", location, ingredient);
        }

        public Cut withItems(ItemStack output, float chance) {
            if (output.isEmpty()) {
                return this;
            }
            this.outputs.add(new CutRecipe.CutOutput(output, chance));
            return this;
        }

        public Cut withItems(ItemStack output) {
            if (output.isEmpty()) {
                return this;
            }
            this.outputs.add(new CutRecipe.CutOutput(output, 1.0f));
            return this;
        }

        @Override
        public CutRecipe asRecipe() {
            return new CutRecipe(this.ing, this.outputs);
        }
    }

    public static class Crush
    extends RecipeWrapper<CrushRecipe, CrushRecipe.CrushOutput> {
        public Crush(ResourceLocation location, Ingredient ingredient) {
            super("crush", location, ingredient);
        }

        public Crush withItems(ItemStack output, float chance) {
            if (output.isEmpty()) {
                return this;
            }
            this.outputs.add(new CrushRecipe.CrushOutput(output, chance));
            return this;
        }

        public Crush withItems(ItemStack output) {
            if (output.isEmpty()) {
                return this;
            }
            this.outputs.add(new CrushRecipe.CrushOutput(output, 1.0f));
            return this;
        }

        @Override
        public CrushRecipe asRecipe() {
            return new CrushRecipe(this.ing, this.outputs);
        }
    }
}

